/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.api.constant;

import com.yunxi.dg.base.center.report.api.constant.SaleOrderStatus;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum ExchangeOrderStatus implements SaleOrderStatus
{
    INIT("INIT", "\u521d\u59cb\u5316\u72b6\u6001"),
    CREATED("CREATED", "\u521d\u59cb\u5316\u521b\u5efa"),
    WAIT_AUDIT("WAIT_AUDIT", "\u5f85\u5ba1\u6838"),
    WAIT_STORAGE("WAIT_STORAGE", "\u5f85\u5165\u5e93"),
    ALREADY_STORAGE("ALREADY_STORAGE", "\u5df2\u5165\u5e93"),
    CANCEL("CANCEL", "\u5df2\u53d6\u6d88"),
    CLOSE("CLOSE", "\u5df2\u5173\u95ed"),
    WAIT_RETURNED("WAIT_RETURNED", "\u5f85\u9000\u8d27"),
    COMPLETE("COMPLETE", "\u5df2\u5b8c\u6210");

    private String code;
    private String desc;
    public static final Map<String, ExchangeOrderStatus> CODE_LOOKUP;
    public static final Map<String, String> CODE_DESC_MAP;

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    private ExchangeOrderStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ExchangeOrderStatus forCode(String code) {
        return CODE_LOOKUP.get(code);
    }

    public Map<String, String> getCodeAndDesc() {
        return CODE_DESC_MAP;
    }

    static {
        CODE_LOOKUP = Arrays.stream(ExchangeOrderStatus.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
        CODE_DESC_MAP = Arrays.stream(ExchangeOrderStatus.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum.desc));
    }
}

