/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.api.constant;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public enum AfterSaleOrderReturnBizTypeEnum {
    SPECIAL_RETURN("001", "\u7ecf\u9500\u5546\u4e00\u9000", 1),
    DEALER_SECOND_RETURN("101", "\u7ecf\u9500\u5546\u4e8c\u9000", 2),
    UNDELIVERED_RETURN("011", "\u7ecf\u9500\u5546\u672a\u53d1\u8d27\u9000\u8d27", 3),
    DIRECT_SALE_FIRST_RETURN("002", "\u76f4\u8425\u7535\u5546\u4e00\u9000", 4),
    DIRECT_SALE_SECOND_RETURN("102", "\u76f4\u8425\u7535\u5546\u4e8c\u9000", 5),
    DIRECT_SALE_UNDELIVERED_RETURN("012", "\u76f4\u8425\u672a\u53d1\u8d27\u9000\u8d27", 6),
    UNKNOWN("999", "\u672a\u77e5\u9000\u8d27\u7c7b\u578b", 9);

    private static final Map<String, AfterSaleOrderReturnBizTypeEnum> returnTypesMap;
    private final String key;
    private final String description;
    private final Integer code;

    private AfterSaleOrderReturnBizTypeEnum(String key, String description, Integer code) {
        this.key = key;
        this.description = description;
        this.code = code;
    }

    public String getKey() {
        return this.key;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getCode() {
        return this.code;
    }

    public static AfterSaleOrderReturnBizTypeEnum calculateReturnBizType(Integer relateToPlatformOrder, Integer unshippedReturn, String bizType) {
        Optional<Integer> relateToPlatformOrderOpt = Optional.ofNullable(relateToPlatformOrder);
        Optional<Integer> unshippedReturnOpt = Optional.ofNullable(unshippedReturn);
        if (StringUtils.isBlank((CharSequence)bizType)) {
            return UNKNOWN;
        }
        Integer bizTypeValue = Integer.valueOf(bizType);
        if (!relateToPlatformOrderOpt.isPresent() || !unshippedReturnOpt.isPresent()) {
            return UNKNOWN;
        }
        String key = String.format("%d%d%d", relateToPlatformOrderOpt.orElse(0), unshippedReturnOpt.orElse(0), bizTypeValue);
        return returnTypesMap.getOrDefault(key, UNKNOWN);
    }

    static {
        returnTypesMap = new HashMap<String, AfterSaleOrderReturnBizTypeEnum>();
        for (AfterSaleOrderReturnBizTypeEnum returnType : AfterSaleOrderReturnBizTypeEnum.values()) {
            returnTypesMap.put(returnType.getKey(), returnType);
        }
    }
}

