/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.api.constant;

import com.yunxi.dg.base.center.report.api.constant.SaleOrderStatus;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum ExchangeDeliveryStatus implements SaleOrderStatus
{
    WAIT_DELIVERY("WAIT_DELIVERY", "\u5f85\u53d1\u8d27"),
    PART_DELIVERY("PART_DELIVERY", "\u90e8\u5206\u53d1\u8d27"),
    FINISH("FINISH", "\u5df2\u53d1\u8d27"),
    CANCEL("CANCEL", "\u5df2\u53d6\u6d88");

    private String code;
    private String desc;
    public static final Map<String, ExchangeDeliveryStatus> CODE_LOOKUP;
    public static final Map<String, String> CODE_DESC_MAP;

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    private ExchangeDeliveryStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ExchangeDeliveryStatus forCode(String code) {
        return CODE_LOOKUP.get(code);
    }

    public Map<String, String> getCodeAndDesc() {
        return CODE_DESC_MAP;
    }

    static {
        CODE_LOOKUP = Arrays.stream(ExchangeDeliveryStatus.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
        CODE_DESC_MAP = Arrays.stream(ExchangeDeliveryStatus.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum.desc));
    }
}

