/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.dao.das.impl.transform;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.eo.BaseEo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.dao.das.transform.TfOrderDas;
import com.yunxi.dg.base.center.report.dao.mapper.transform.TfOrderMapper;
import com.yunxi.dg.base.center.report.dto.transform.OrderExtPageReqDto;
import com.yunxi.dg.base.center.report.dto.transform.OrderExtPageRespDto;
import com.yunxi.dg.base.center.report.eo.transform.TfOrderEo;
import com.yunxi.dg.base.framework.core.db.das.AbstractDas;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.springframework.stereotype.Service;

@Service
public class TfOrderDasImpl
extends AbstractDas<TfOrderEo, String>
implements TfOrderDas {
    private TfOrderMapper tfOrderMapper() {
        return (TfOrderMapper)this.getMapper();
    }

    @Override
    public PageInfo<OrderExtPageRespDto> queryByPage(OrderExtPageReqDto orderExtPageReqDto, Integer currentPage, Integer pageSize) {
        this.queryParamConcat(orderExtPageReqDto);
        currentPage = Objects.isNull(currentPage) ? DEFAULT_PAGE_NUMBER : currentPage;
        pageSize = Objects.isNull(pageSize) ? DEFAULT_PAGE_SIZE : pageSize;
        PageHelper.startPage((int)currentPage, (int)pageSize);
        List<OrderExtPageRespDto> list = this.tfOrderMapper().queryList(orderExtPageReqDto);
        return new PageInfo(list);
    }

    @Override
    public List<OrderExtPageRespDto> exportList(OrderExtPageReqDto orderExtPageReqDto) {
        return this.tfOrderMapper().exportList(orderExtPageReqDto);
    }

    @Override
    public List<OrderExtPageRespDto> queryByParam(OrderExtPageReqDto orderExtPageReqDto) {
        this.queryParamConcat(orderExtPageReqDto);
        PageHelper.startPage((int)1, (int)orderExtPageReqDto.getOrderByIdLimit());
        List<OrderExtPageRespDto> list = this.tfOrderMapper().queryList(orderExtPageReqDto);
        return list;
    }

    @Override
    public LocalDateTime getMinPayTime() {
        return this.tfOrderMapper().getMinPayTime();
    }

    @Override
    public PageInfo<TfOrderEo> pageByPayTime(LocalDateTime startTime, LocalDateTime endTime, int pageNum, int pageSize) {
        return PageHelper.startPage((int)pageNum, (int)pageSize).doSelectPageInfo(() -> this.tfOrderMapper().queryByPayTime(startTime, endTime));
    }

    @Override
    public LocalDateTime getMinUpdateTimeWithoutDr() {
        return this.tfOrderMapper().getMinUpdateTimeWithoutDr();
    }

    @Override
    public PageInfo<TfOrderEo> pageByUpdateTimeWithoutDr(LocalDateTime startTime, LocalDateTime endTime, int pageNum, int pageSize) {
        return PageHelper.startPage((int)pageNum, (int)pageSize).doSelectPageInfo(() -> this.tfOrderMapper().queryByUpdateTimeWithoutDr(startTime, endTime));
    }

    @Override
    public List<TfOrderEo> queryByPlatformOrderNos(Collection<String> orderNos) {
        if (orderNos == null || orderNos.isEmpty()) {
            return new ArrayList<TfOrderEo>(0);
        }
        return this.tfOrderMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery((Class)this.eoClass).in(TfOrderEo::getPlatformOrderNo, orderNos)).eq(BaseEo::getDr, (Object)0));
    }

    private void queryParamConcat(OrderExtPageReqDto orderExtPageReqDto) {
        if (Objects.isNull(orderExtPageReqDto)) {
            return;
        }
        List orderNoList = orderExtPageReqDto.getOrderNoList();
        if (CollUtil.isEmpty((Collection)orderNoList)) {
            return;
        }
        if (orderNoList.size() == 1) {
            orderExtPageReqDto.setOrderNoLike((String)orderNoList.get(0));
            orderExtPageReqDto.setOrderNoList(null);
        }
    }
}

