/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.domain.entity.impl;

import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.report.dao.das.ICostCategoryDas;
import com.yunxi.dg.base.center.report.domain.entity.ICostCategoryDomain;
import com.yunxi.dg.base.center.report.eo.CostCategoryEo;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CostCategoryDomainImpl
extends BaseDomainImpl<CostCategoryEo>
implements ICostCategoryDomain {
    @Resource
    private ICostCategoryDas das;

    public ICommonDas<CostCategoryEo> commonDas() {
        return this.das;
    }

    @Override
    public int countByParentId(Long parentId) {
        return this.das.countByParentId(parentId);
    }

    @Override
    public String getCodePath(String code) {
        CostCategoryEo category = this.getByCode(code);
        AssertUtils.notNull((Object)category, (String)"\u8d39\u7528\u7c7b\u76ee\u4e0d\u5b58\u5728");
        List ids = Arrays.stream(category.getIdPath().split(",")).map(Long::parseLong).collect(Collectors.toList());
        List categories = this.das.selectByIds(ids);
        Map<Long, CostCategoryEo> map = categories.stream().collect(Collectors.toMap(BaseEo::getId, v -> v));
        return ids.stream().map(map::get).map(CostCategoryEo::getCode).collect(Collectors.joining("/"));
    }

    @Override
    public CostCategoryEo getByCode(String code) {
        CostCategoryEo eo = new CostCategoryEo();
        eo.setCode(code);
        return (CostCategoryEo)this.das.selectOne((BaseEo)eo);
    }
}

