/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.domain.entity.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.yunxi.dg.base.center.report.dao.das.IEnterpriceCrossOrderDas;
import com.yunxi.dg.base.center.report.domain.entity.IEnterpriceCrossOrderDomain;
import com.yunxi.dg.base.center.report.dto.companytrade.EnterpriseDocumentNoDto;
import com.yunxi.dg.base.center.report.dto.companytrade.EnterpriseDto;
import com.yunxi.dg.base.center.report.dto.companytrade.ErpPurchaseOrderDto;
import com.yunxi.dg.base.center.report.dto.companytrade.ErpSaleOrderDto;
import com.yunxi.dg.base.center.report.dto.companytrade.SupplierDto;
import com.yunxi.dg.base.center.report.dto.enterprice.EnterpriceInOtherStorageOrderOrgDto;
import com.yunxi.dg.base.center.report.dto.enterprice.EnterpriceInPlanOrderOrgDto;
import com.yunxi.dg.base.center.report.dto.enterprice.EnterpriceOeaPurchaseOrderLine;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossOrderDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossOrderPageReqDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossOrderUpdateDto;
import com.yunxi.dg.base.center.report.enums.BusinessTypeEnum;
import com.yunxi.dg.base.center.report.enums.CompanyTradeTypeEnum;
import com.yunxi.dg.base.center.report.eo.EnterpriceCrossOrderEo;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
public class EnterpriceCrossOrderDomainImpl
extends BaseDomainImpl<EnterpriceCrossOrderEo>
implements IEnterpriceCrossOrderDomain {
    private final Map<String, Integer> cacheOrderNoInc = new HashMap<String, Integer>();
    @Resource
    private IEnterpriceCrossOrderDas das;
    @Resource
    private IContext context;
    @Resource
    private ICacheService cacheService;

    public ICommonDas<EnterpriceCrossOrderEo> commonDas() {
        return this.das;
    }

    @Override
    public List<EnterpriceCrossOrderDto> queryPage(EnterpriceCrossOrderPageReqDto dto) {
        List list = this.das.queryPage(dto);
        list.forEach(d -> {
            if (!d.getBusinessType().equals(BusinessTypeEnum.PURCHASE_ORDER.getType()) && !d.getBusinessType().equals(BusinessTypeEnum.PURCHASE_ORDER_RETURN.getType())) {
                d.setReceiveDetailAddress("\u6c55\u5934\u6f84\u6d77");
            }
        });
        return list;
    }

    @Override
    public void updateOrder(EnterpriceCrossOrderUpdateDto dto, EnterpriceCrossOrderEo orderEo) {
        if (orderEo.getType().equals(CompanyTradeTypeEnum.SALE_ORDER.getType()) || orderEo.getType().equals(CompanyTradeTypeEnum.AFTERSALE_ORDER.getType())) {
            orderEo.setSaleEnterpriseId(dto.getSaleEnterpriseId());
            orderEo.setSaleEnterpriseCode(dto.getSaleEnterpriseCode());
            orderEo.setCustomerId(dto.getCustomerId());
            orderEo.setCustomerCode(dto.getCustomerCode());
            orderEo.setCalculateCompanyCode(dto.getSaleEnterpriseCode());
        }
        if (orderEo.getType().equals(CompanyTradeTypeEnum.PURCHASE_ORDER.getType()) || orderEo.getType().equals(CompanyTradeTypeEnum.PURCHASE_AFTERSALE_ORDER.getType())) {
            orderEo.setSupplierId(dto.getSupplierId());
            orderEo.setSupplierCode(dto.getSupplierCode());
            orderEo.setPurchaseEnterpriseId(dto.getPurchaseEnterpriseId());
            orderEo.setPurchaseEnterpriseCode(dto.getPurchaseEnterpriseCode());
            orderEo.setCalculateCompanyCode(dto.getPurchaseEnterpriseCode());
        }
        orderEo.setUpdatePerson(this.context.userName());
        orderEo.setUpdateTime(new Date());
        this.updateSelective((BaseEo)orderEo);
    }

    @Override
    public String createDocumentNo(String type) {
        CompanyTradeTypeEnum enumByType;
        String time = DateTimeFormatter.ofPattern("yyyyMMdd").format(LocalDateTime.now());
        StringBuilder incNum = this.getOrderNoIncNumByRedis(time, type);
        if (incNum.length() < 6) {
            String prefix = "0";
            Integer index = 6 - incNum.length();
            for (int i = 0; i < index; ++i) {
                incNum.insert(0, prefix);
            }
        }
        if ((enumByType = CompanyTradeTypeEnum.getEnumByType((String)type)).equals((Object)CompanyTradeTypeEnum.PURCHASE_ORDER)) {
            return "RE" + time + incNum;
        }
        if (enumByType.equals((Object)CompanyTradeTypeEnum.PURCHASE_AFTERSALE_ORDER)) {
            return "RET" + time + incNum;
        }
        if (enumByType.equals((Object)CompanyTradeTypeEnum.SALE_ORDER)) {
            return "SR" + time + incNum;
        }
        if (enumByType.equals((Object)CompanyTradeTypeEnum.AFTERSALE_ORDER)) {
            return "SRT" + time + incNum;
        }
        return "";
    }

    private StringBuilder getOrderNoIncNumByRedis(String time, String type) {
        String key = "orderNoInc:" + type + ":" + time;
        Long incNum = this.cacheService.incr(key);
        if (incNum.equals(1L)) {
            List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"type", (Object)type)).orderByDesc((Object)"id")).last("limit 1")).list();
            String documentNo = "";
            if (!list.isEmpty()) {
                documentNo = ((EnterpriceCrossOrderEo)list.get(0)).getDocumentNo();
                String oriNum = StrUtil.isBlank((CharSequence)documentNo) ? "0" : documentNo.substring(documentNo.length() - 6);
                Long incr = this.cacheService.incrBy(key, Long.parseLong(oriNum));
                return new StringBuilder(String.valueOf(incr));
            }
        }
        return new StringBuilder(String.valueOf(incNum));
    }

    @NotNull
    private synchronized StringBuilder getOrderNoIncNum(String time, String type) {
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"type", (Object)type)).orderByDesc((Object)"id")).last("limit 1")).list();
        String documentNo = "";
        if (!list.isEmpty()) {
            documentNo = ((EnterpriceCrossOrderEo)list.get(0)).getDocumentNo();
        }
        String oriNum = StrUtil.isBlank((CharSequence)documentNo) ? "0" : documentNo.substring(documentNo.length() - 6);
        String incNum = String.valueOf(Integer.parseInt(oriNum) + 1);
        Integer i = this.cacheOrderNoInc.get(time + type);
        if (Integer.valueOf(incNum).equals(i)) {
            this.cacheOrderNoInc.put(time + type, i + 1);
            incNum = String.valueOf(i + 1);
        }
        return new StringBuilder(incNum);
    }

    @Override
    public EnterpriseDto getSaleOrderEnterprise(Long orderId) {
        return this.das.getSaleOrderEnterprise(orderId);
    }

    @Override
    public EnterpriseDto getAfterSaleOrderEnterprise(Long resultOrderId) {
        return this.das.getAfterSaleOrderEnterprise(resultOrderId);
    }

    @Override
    public EnterpriseDto getLogicWarehouseEnterprise(String logicWarehouseCode) {
        return this.das.getLogicWarehouseEnterprise(logicWarehouseCode);
    }

    @Override
    public String getTransferOrderStatus(String relevanceNo) {
        return this.das.getTransferOrderStatus(relevanceNo);
    }

    @Override
    public List<ErpSaleOrderDto> getSaleOrderByOrderIds(List<Long> collect) {
        return this.das.getSaleOrderByOrderIds(collect);
    }

    @Override
    public List<ErpPurchaseOrderDto> getPurchaseOrderByOrderIds(List<Long> collect) {
        List list = this.das.getPurchaseOrderByOrderIds(collect);
        list.forEach(d -> {
            if (!d.getBusinessType().equals(BusinessTypeEnum.PURCHASE_ORDER.getType()) && !d.getBusinessType().equals(BusinessTypeEnum.PURCHASE_ORDER_RETURN.getType())) {
                d.setVendorAddress("\u6c55\u5934\u6f84\u6d77");
            }
        });
        return list;
    }

    @Override
    public String checkPurchaseOrPurchaseReturn(String relevanceNo) {
        return this.das.checkPurchaseOrPurchaseReturn(relevanceNo);
    }

    @Override
    public Long getSaleOrderByPurchaseOrderId(Long id) {
        return this.das.getSaleOrderByPurchaseOrderId(id);
    }

    @Override
    public EnterpriceCrossOrderEo selectRelevanceSaleOrderOrPurchaseOrder(Long id) {
        return this.das.selectRelevanceSaleOrderOrPurchaseOrder(id);
    }

    @Override
    public SupplierDto selectInPlanOrderSupplier(String relevanceNo) {
        return this.das.selectInPlanOrderSupplier(relevanceNo);
    }

    @Override
    public List<EnterpriseDocumentNoDto> selectDocumentNo(String relevanceNo) {
        return this.das.selectDocumentNo(relevanceNo);
    }

    @Override
    public EnterpriceCrossOrderDto selectOrder(Long id) {
        return this.das.selectOrder(id);
    }

    @Override
    public EnterpriceInPlanOrderOrgDto selectInPlanOrderOrgByInPlanOrderNo(String inPlanOrderNo) {
        return this.das.selectInPlanOrderOrgByInPlanOrderNo(inPlanOrderNo);
    }

    @Override
    public List<EnterpriceOeaPurchaseOrderLine> selectOeaPurchaseSkuPriceList(Long resultOrderId) {
        return this.das.selectOeaPurchaseSkuPriceList(resultOrderId);
    }

    @Override
    public EnterpriceInOtherStorageOrderOrgDto selectInOtherStorageOrderByOrderNo(String orderNo) {
        return this.das.selectInOtherStorageOrderByOrderNo(orderNo);
    }
}

