/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.domain.entity.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.yunxi.dg.base.center.report.constants.enterprice.EnterpriceConstants;
import com.yunxi.dg.base.center.report.dao.das.IEnterpriceCrossOrderLineDas;
import com.yunxi.dg.base.center.report.domain.entity.IEnterpriceCrossOrderDeductRecordDomain;
import com.yunxi.dg.base.center.report.domain.entity.IEnterpriceCrossOrderLineDomain;
import com.yunxi.dg.base.center.report.domain.entity.IEnterpriceCrossPriceDomain;
import com.yunxi.dg.base.center.report.dto.companytrade.ErpPurchaseOrderLineDto;
import com.yunxi.dg.base.center.report.dto.companytrade.ErpSaleOrderLineDto;
import com.yunxi.dg.base.center.report.dto.enterprice.EnterpriceOeaPurchaseOrderLine;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossOrderLineDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossOrderLinePageReqDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossReceiveDeliveryResultDetailDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossReceiveDeliveryResultDto;
import com.yunxi.dg.base.center.report.enums.BusinessTypeEnum;
import com.yunxi.dg.base.center.report.enums.CompanyTradeTypeEnum;
import com.yunxi.dg.base.center.report.enums.DisplayBusinessTypeEnum;
import com.yunxi.dg.base.center.report.eo.EnterpriceCrossOrderDeductRecordEo;
import com.yunxi.dg.base.center.report.eo.EnterpriceCrossOrderEo;
import com.yunxi.dg.base.center.report.eo.EnterpriceCrossOrderLineEo;
import com.yunxi.dg.base.center.report.eo.EnterpriceCrossPriceEo;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EnterpriceCrossOrderLineDomainImpl
extends BaseDomainImpl<EnterpriceCrossOrderLineEo>
implements IEnterpriceCrossOrderLineDomain {
    private static final Logger log = LoggerFactory.getLogger(EnterpriceCrossOrderLineDomainImpl.class);
    @Resource
    IContext context;
    @Resource
    private IEnterpriceCrossOrderLineDas das;
    @Resource
    private IEnterpriceCrossPriceDomain priceDomain;
    @Resource
    private IEnterpriceCrossOrderDeductRecordDomain deductRecordDomain;

    public ICommonDas<EnterpriceCrossOrderLineEo> commonDas() {
        return this.das;
    }

    @Override
    public List<EnterpriceCrossOrderLineDto> queryPage(EnterpriceCrossOrderLinePageReqDto dto) {
        List list = this.das.queryPage(dto);
        list.forEach(d -> {
            if (!d.getBusinessType().equals(BusinessTypeEnum.PURCHASE_ORDER.getType()) && !d.getBusinessType().equals(BusinessTypeEnum.PURCHASE_ORDER_RETURN.getType())) {
                d.setReceiveDetailAddress("\u6c55\u5934\u6f84\u6d77");
            }
        });
        return list;
    }

    @Override
    public void updateOrderLine(Long orderId, Long orderLineId, BigDecimal price) {
        EnterpriceCrossOrderLineEo orderLineQuery = new EnterpriceCrossOrderLineEo();
        orderLineQuery.setOrderId(orderId);
        orderLineQuery.setId(orderLineId);
        EnterpriceCrossOrderLineEo orderLineEo = (EnterpriceCrossOrderLineEo)this.selectOne((BaseEo)orderLineQuery);
        if (orderLineEo != null) {
            int n = this.das.updateOrderLinePrice(price, orderLineEo.getOrderId(), orderLineEo.getId());
        }
    }

    @Override
    public Boolean createOrderLine(EnterpriceCrossReceiveDeliveryResultDto dto, List<EnterpriceCrossReceiveDeliveryResultDetailDto> resultDetailDtoList, EnterpriceCrossOrderEo order) {
        AtomicReference<Boolean> findPriceFlag = new AtomicReference<Boolean>(Boolean.TRUE);
        ArrayList orderLineEoList = new ArrayList();
        List<String> skuCodeList = resultDetailDtoList.stream().map(EnterpriceCrossReceiveDeliveryResultDetailDto::getSkuCode).collect(Collectors.toList());
        Map prices = Optional.ofNullable(this.getPrices(order, skuCodeList)).orElse(new HashMap());
        resultDetailDtoList.forEach(detailDto -> {
            if (prices.get(detailDto.getSkuCode()) == null) {
                findPriceFlag.set(Boolean.FALSE);
            }
            EnterpriceCrossOrderLineEo orderLineEo = this.createEo();
            orderLineEo.setOrderId(order.getId());
            orderLineEo.setResultOrderDetailId(detailDto.getId());
            if (order.getType().equals(CompanyTradeTypeEnum.SALE_ORDER.getType())) {
                orderLineEo.setPrice((BigDecimal)prices.get(detailDto.getSkuCode()));
            }
            if (order.getType().equals(CompanyTradeTypeEnum.PURCHASE_ORDER.getType())) {
                BigDecimal bigDecimal = (BigDecimal)prices.get(detailDto.getSkuCode());
                bigDecimal = bigDecimal == null ? null : bigDecimal.divide(EnterpriceConstants.ENTERPRICE_PRICE_FIXED_RATIO, 6, RoundingMode.HALF_UP);
                orderLineEo.setPrice(bigDecimal);
            }
            orderLineEo.setSkuCode(detailDto.getSkuCode());
            orderLineEo.setNum(detailDto.getDoneQuantity());
            orderLineEo.setWaitDeductNum(detailDto.getDoneQuantity());
            orderLineEo.setAmount(orderLineEo.getPrice() == null || detailDto.getDoneQuantity() == null ? null : orderLineEo.getPrice().multiply(detailDto.getDoneQuantity()));
            orderLineEoList.add(orderLineEo);
        });
        this.das.insertBatch(orderLineEoList);
        return findPriceFlag.get();
    }

    @Override
    public Boolean purchaseOrderReturnDeductAndCreateOrderLine(List<EnterpriceCrossReceiveDeliveryResultDetailDto> resultDetailDtoList, EnterpriceCrossOrderEo order) {
        Boolean deductResult = Boolean.TRUE;
        for (EnterpriceCrossReceiveDeliveryResultDetailDto detail : resultDetailDtoList) {
            List<EnterpriceCrossOrderLineEo> waitList = this.purchaseOrderWaitDeductList(detail.getSkuCode(), order.getPurchaseEnterpriseId(), order.getSupplierId(), order.getBusinessType());
            Boolean result = this.purchaseOrderReturnDeductDetail(waitList, detail.getDoneQuantity(), detail.getId(), detail.getSkuCode(), order.getId());
            deductResult = result.equals(Boolean.TRUE);
        }
        return deductResult;
    }

    @Override
    public Boolean saleOrderReturnDeductAndCreateOrderLine(List<EnterpriceCrossReceiveDeliveryResultDetailDto> resultDetailDtoList, EnterpriceCrossOrderEo order) {
        try {
            TimeUnit.SECONDS.sleep(5L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        List<EnterpriceCrossOrderLineEo> waitList = this.selectRelevanceOrderLineByOrderId(order.getId());
        if (CollUtil.isEmpty(waitList)) {
            this.saleOrderReturnDeductDetailByResultDetail(resultDetailDtoList, order.getId());
            return Boolean.FALSE;
        }
        this.saleOrderReturnDeductDetail(waitList, resultDetailDtoList, order.getId());
        return Boolean.TRUE;
    }

    private Boolean purchaseOrderReturnDeductDetail(List<EnterpriceCrossOrderLineEo> inventoryList, BigDecimal doneQuantity, Long resultOrderDetailId, String skuCode, Long orderId) {
        Boolean result = Boolean.TRUE;
        for (EnterpriceCrossOrderLineEo inventoryOrderLine : inventoryList) {
            boolean deductSuccFlag;
            if (doneQuantity.compareTo(BigDecimal.ZERO) == 0) break;
            BigDecimal deductNum = doneQuantity;
            if (inventoryOrderLine.getWaitDeductNum().compareTo(doneQuantity) >= 0) {
                doneQuantity = doneQuantity.subtract(doneQuantity);
            } else if (inventoryOrderLine.getWaitDeductNum().compareTo(doneQuantity) < 0) {
                doneQuantity = doneQuantity.subtract(inventoryOrderLine.getWaitDeductNum());
                deductNum = inventoryOrderLine.getWaitDeductNum();
            } else {
                deductNum = doneQuantity = doneQuantity.subtract(doneQuantity);
            }
            Integer i = this.deductDetail(inventoryOrderLine.getId(), inventoryOrderLine.getWaitDeductNum(), deductNum);
            boolean bl = deductSuccFlag = i > 0;
            if (!deductSuccFlag) continue;
            log.info("======>\u51b2\u62b5 resultOrderDetailId:{}, skuCode:{}, orderId:{}, inventoryOrderLine:{}, deductNum:{}", new Object[]{resultOrderDetailId, skuCode, orderId, JSONUtil.toJsonStr((Object)inventoryOrderLine), deductNum});
            this.createOrderLineAndDeductDetail(resultOrderDetailId, skuCode, orderId, inventoryOrderLine, deductNum);
        }
        if (doneQuantity.compareTo(BigDecimal.ZERO) > 0) {
            result = Boolean.FALSE;
            log.info("======>\u51b2\u62b5\u5931\u8d25 resultOrderDetailId:{}, skuCode:{}, orderId:{}", new Object[]{resultOrderDetailId, skuCode, orderId});
            EnterpriceCrossOrderLineEo orderLineEo = new EnterpriceCrossOrderLineEo();
            orderLineEo.setOrderId(orderId);
            orderLineEo.setResultOrderDetailId(resultOrderDetailId);
            orderLineEo.setPrice(null);
            orderLineEo.setAmount(null);
            orderLineEo.setSkuCode(skuCode);
            orderLineEo.setNum(doneQuantity);
            orderLineEo.setWaitDeductNum(null);
            orderLineEo.setTenantId(this.context.tenantId());
            orderLineEo.setInstanceId(this.context.instanceId());
            orderLineEo.setCreatePerson(this.context.userName());
            orderLineEo.setCreateTime(new Date());
            orderLineEo.setUpdatePerson(this.context.userName());
            orderLineEo.setUpdateTime(new Date());
            this.insert((BaseEo)orderLineEo);
        }
        return result;
    }

    private void createOrderLineAndDeductDetail(Long resultOrderDetailId, String skuCode, Long orderId, EnterpriceCrossOrderLineEo inventoryOrderLine, BigDecimal deductNum) {
        EnterpriceCrossOrderLineEo orderLineEo = new EnterpriceCrossOrderLineEo();
        orderLineEo.setOrderId(orderId);
        orderLineEo.setResultOrderDetailId(resultOrderDetailId);
        orderLineEo.setPrice(inventoryOrderLine.getPrice());
        orderLineEo.setAmount(inventoryOrderLine.getPrice().multiply(deductNum));
        orderLineEo.setSkuCode(skuCode);
        orderLineEo.setNum(deductNum);
        orderLineEo.setWaitDeductNum(deductNum);
        orderLineEo.setTenantId(this.context.tenantId());
        orderLineEo.setInstanceId(this.context.instanceId());
        orderLineEo.setCreatePerson(this.context.userName());
        orderLineEo.setCreateTime(new Date());
        orderLineEo.setUpdatePerson(this.context.userName());
        orderLineEo.setUpdateTime(new Date());
        this.insert((BaseEo)orderLineEo);
        EnterpriceCrossOrderDeductRecordEo recordEo = new EnterpriceCrossOrderDeductRecordEo();
        recordEo.setOrderId(orderId);
        recordEo.setOrderLineId(orderLineEo.getId());
        recordEo.setSkuCode(orderLineEo.getSkuCode());
        recordEo.setSourceOrderId(inventoryOrderLine.getOrderId());
        recordEo.setSourceOrderLineId(inventoryOrderLine.getId());
        recordEo.setNum(deductNum);
        recordEo.setType(CompanyTradeTypeEnum.PURCHASE_AFTERSALE_ORDER.getType());
        recordEo.setTenantId(this.context.tenantId());
        recordEo.setInstanceId(this.context.instanceId());
        recordEo.setCreatePerson(this.context.userName());
        recordEo.setCreateTime(new Date());
        recordEo.setUpdatePerson(this.context.userName());
        recordEo.setUpdateTime(new Date());
        this.deductRecordDomain.insert((BaseEo)recordEo);
    }

    private void saleOrderReturnDeductDetail(List<EnterpriceCrossOrderLineEo> waitList, List<EnterpriceCrossReceiveDeliveryResultDetailDto> detailDtoList, Long orderId) {
        detailDtoList.forEach(detailDto -> {
            for (EnterpriceCrossOrderLineEo ol : waitList) {
                if (!ol.getSkuCode().equals(detailDto.getSkuCode())) continue;
                EnterpriceCrossOrderLineEo orderLineEo = new EnterpriceCrossOrderLineEo();
                orderLineEo.setOrderId(orderId);
                orderLineEo.setResultOrderDetailId(detailDto.getId());
                orderLineEo.setPrice(ol.getPrice() == null ? null : ol.getPrice().multiply(EnterpriceConstants.ENTERPRICE_PRICE_FIXED_RATIO).setScale(6, RoundingMode.HALF_EVEN));
                orderLineEo.setAmount(ol.getAmount());
                orderLineEo.setSkuCode(detailDto.getSkuCode());
                orderLineEo.setNum(ol.getNum());
                orderLineEo.setTenantId(this.context.tenantId());
                orderLineEo.setInstanceId(this.context.instanceId());
                orderLineEo.setCreatePerson(this.context.userName());
                orderLineEo.setCreateTime(new Date());
                orderLineEo.setUpdatePerson(this.context.userName());
                orderLineEo.setUpdateTime(new Date());
                this.insert((BaseEo)orderLineEo);
            }
        });
    }

    private void saleOrderReturnDeductDetailByResultDetail(List<EnterpriceCrossReceiveDeliveryResultDetailDto> resultDetailDtoList, Long orderId) {
        resultDetailDtoList.forEach(detailDto -> {
            EnterpriceCrossOrderLineEo orderLineEo = new EnterpriceCrossOrderLineEo();
            orderLineEo.setOrderId(orderId);
            orderLineEo.setResultOrderDetailId(detailDto.getId());
            orderLineEo.setPrice(null);
            orderLineEo.setAmount(null);
            orderLineEo.setSkuCode(detailDto.getSkuCode());
            orderLineEo.setNum(detailDto.getDoneQuantity());
            orderLineEo.setTenantId(this.context.tenantId());
            orderLineEo.setInstanceId(this.context.instanceId());
            orderLineEo.setCreatePerson(this.context.userName());
            orderLineEo.setCreateTime(new Date());
            orderLineEo.setUpdatePerson(this.context.userName());
            orderLineEo.setUpdateTime(new Date());
            this.insert((BaseEo)orderLineEo);
        });
    }

    @Override
    public List<EnterpriceCrossOrderLineEo> purchaseOrderWaitDeductList(String skuCode, Long purchaseEnterpriseId, Long supplierId, String businessType) {
        businessType = BusinessTypeEnum.FINISHED_PRODUCT_RECEIVE_RETURN.getType().equals(businessType) ? BusinessTypeEnum.FINISHED_PRODUCT_RECEIVE.getType() : null;
        return this.das.purchaseOrderWaitDeductList(skuCode, purchaseEnterpriseId, supplierId, businessType);
    }

    @Override
    public List<ErpSaleOrderLineDto> getSaleOrderLineByOrderIds(List<Long> collect) {
        return this.das.getSaleOrderLineByOrderIds(collect);
    }

    @Override
    public List<ErpPurchaseOrderLineDto> getPurchaseOrderLineByOrderIds(List<Long> collect) {
        return this.das.getPurchaseOrderLineByOrderIds(collect);
    }

    @Override
    public List<ErpPurchaseOrderLineDto> getReturnPurchaseOrderLineByOrderIds(List<Long> collect) {
        return this.das.getReturnPurchaseOrderLineByOrderIds(collect);
    }

    @Override
    public EnterpriceCrossOrderLineEo selectRelevanceSaleOrderLineOrPurchaseOrderLine(Long id) {
        return this.das.selectRelevanceSaleOrderLineOrPurchaseOrderLine(id);
    }

    @Override
    public List<EnterpriceCrossOrderLineEo> selectRelevanceOrderLineByOrderId(Long orderId) {
        return this.das.selectRelevanceOrderLineByOrderId(orderId);
    }

    @Override
    public int deductDetail(Long id, BigDecimal waitDeductNum, BigDecimal num) {
        return this.das.deductDetail(id, waitDeductNum, num);
    }

    @Override
    public List<EnterpriceCrossReceiveDeliveryResultDetailDto> selectResultDetailList(Long orderId) {
        return this.das.selectResultDetailList(orderId);
    }

    @Override
    public void freshPurchaseOrderReturnDeductAndCreateOrderLine(EnterpriceCrossOrderEo purchaseAftersaleOrder) {
        List orderLineList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.filter().eq((Object)"order_id", (Object)purchaseAftersaleOrder.getId())).isNull((Object)"price")).orderByDesc((Object)"create_time")).list();
        for (int i = 0; i < orderLineList.size(); ++i) {
            EnterpriceCrossOrderLineEo orderLineEo = (EnterpriceCrossOrderLineEo)orderLineList.get(i);
            this.logicDeleteById(orderLineEo.getId());
            List<EnterpriceCrossOrderLineEo> inventoryOrderLineList = this.purchaseOrderWaitDeductList(orderLineEo.getSkuCode(), purchaseAftersaleOrder.getPurchaseEnterpriseId(), purchaseAftersaleOrder.getSupplierId(), purchaseAftersaleOrder.getBusinessType());
            this.purchaseOrderReturnDeductDetail(inventoryOrderLineList, orderLineEo.getNum(), orderLineEo.getResultOrderDetailId(), orderLineEo.getSkuCode(), orderLineEo.getOrderId());
        }
    }

    @Override
    public void freshSaleOrderReturnDeductAndCreateOrderLine(EnterpriceCrossOrderEo aftersaleOrder) {
        List collect = ((ExtQueryChainWrapper)this.filter().select(new String[]{"id"}).eq((Object)"order_id", (Object)aftersaleOrder.getId())).list().stream().map(BaseEo::getId).collect(Collectors.toList());
        if (!collect.isEmpty()) {
            this.logicDeleteByIds(collect);
        }
        List<EnterpriceCrossReceiveDeliveryResultDetailDto> aftersaleOrderResultDetailList = this.selectResultDetailList(aftersaleOrder.getId());
        this.saleOrderReturnDeductAndCreateOrderLine(aftersaleOrderResultDetailList, aftersaleOrder);
    }

    @Override
    public Boolean createPurchaseBusinessTypeOrderLine(EnterpriceCrossReceiveDeliveryResultDto dto, List<EnterpriceCrossReceiveDeliveryResultDetailDto> lineDtoList, EnterpriceCrossOrderEo order, List<EnterpriceOeaPurchaseOrderLine> oeaPurchaseOrderLines, BigDecimal ratio) {
        AtomicReference<Boolean> result = new AtomicReference<Boolean>(Boolean.TRUE);
        ArrayList orderLineEoList = new ArrayList();
        Map<String, BigDecimal> collect = oeaPurchaseOrderLines.stream().collect(Collectors.toMap(EnterpriceOeaPurchaseOrderLine::getSkuCode, EnterpriceOeaPurchaseOrderLine::getPrice));
        lineDtoList.forEach(detailDto -> {
            EnterpriceCrossOrderLineEo orderLineEo = this.createEo();
            orderLineEo.setOrderId(order.getId());
            orderLineEo.setResultOrderDetailId(detailDto.getId());
            BigDecimal price = (BigDecimal)collect.get(orderLineEo.getSkuCode());
            if (order.getType().equals(CompanyTradeTypeEnum.SALE_ORDER.getType())) {
                price = price == null ? null : price.multiply(EnterpriceConstants.ENTERPRICE_PRICE_FIXED_RATIO).multiply(ratio).setScale(6, RoundingMode.HALF_UP);
            } else {
                BigDecimal bigDecimal = price = price == null ? null : price.multiply(ratio).setScale(6, RoundingMode.HALF_UP);
            }
            if (price == null || price.compareTo(BigDecimal.ZERO) == 0) {
                result.set(Boolean.FALSE);
            }
            orderLineEo.setPrice(price);
            orderLineEo.setSkuCode(detailDto.getSkuCode());
            orderLineEo.setNum(detailDto.getDoneQuantity());
            orderLineEo.setWaitDeductNum(detailDto.getDoneQuantity());
            orderLineEo.setAmount(orderLineEo.getPrice() == null || detailDto.getDoneQuantity() == null ? BigDecimal.ZERO : orderLineEo.getPrice().multiply(detailDto.getDoneQuantity()));
            orderLineEoList.add(orderLineEo);
        });
        this.das.insertBatch(orderLineEoList);
        return result.get();
    }

    @Override
    public EnterpriceCrossOrderLineDto selectOrderLine(Long id) {
        return this.das.selectOrderLine(id);
    }

    private EnterpriceCrossOrderLineEo createEo() {
        EnterpriceCrossOrderLineEo orderLineEo = new EnterpriceCrossOrderLineEo();
        orderLineEo.setTenantId(this.context.tenantId());
        orderLineEo.setInstanceId(this.context.instanceId());
        orderLineEo.setCreatePerson(this.context.userName());
        orderLineEo.setCreateTime(new Date());
        orderLineEo.setUpdatePerson(this.context.userName());
        orderLineEo.setUpdateTime(new Date());
        orderLineEo.setDr(0);
        return orderLineEo;
    }

    private Map<String, BigDecimal> getPrices(EnterpriceCrossOrderEo orderEo, List<String> skuCodes) {
        if (orderEo.getType().equals(CompanyTradeTypeEnum.AFTERSALE_ORDER.getType()) || orderEo.getType().equals(CompanyTradeTypeEnum.PURCHASE_AFTERSALE_ORDER.getType())) {
            if (orderEo.getDisplayBusinessType().equals(DisplayBusinessTypeEnum.COMPANY_TRANSACTION_RETURN.getType())) {
                // empty if block
            }
            if (orderEo.getDisplayBusinessType().equals(DisplayBusinessTypeEnum.COMPANY_TRANSACTION_RETURN.getType())) {
                // empty if block
            }
        }
        List priceEos = ((ExtQueryChainWrapper)this.priceDomain.filter().in((Object)"sku_code", skuCodes)).list();
        Map<String, BigDecimal> collect = priceEos.stream().collect(Collectors.toMap(EnterpriceCrossPriceEo::getSkuCode, EnterpriceCrossPriceEo::getPrice));
        return collect;
    }
}

