/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.domain.impl.es;

import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.huieryun.opensearch.api.IOpenSearchService;
import com.dtyunxi.huieryun.opensearch.api.RowMapper;
import com.dtyunxi.huieryun.opensearch.enums.LogicalSymbol;
import com.dtyunxi.huieryun.opensearch.vo.FilterFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.JacksonUtil;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public abstract class BaseEsService {
    private static final Logger logger = LoggerFactory.getLogger(BaseEsService.class);
    @Autowired
    protected IOpenSearchService openSearchService;

    protected SearchResultVo searchData(String indexName, OSSearchVo osSearchVo) {
        try {
            osSearchVo.setIndexName(indexName);
            return this.openSearchService.search(osSearchVo);
        }
        catch (Exception e) {
            logger.error("\u641c\u7d22\u5f02\u5e38\uff1a", (Throwable)e);
            e.printStackTrace();
            return null;
        }
    }

    protected SearchResultVo searchWithScrollId(String scrollId, String keepAlive) {
        return this.openSearchService.searchWithScrollId(scrollId, keepAlive);
    }

    protected <T> List<T> baseRowMapper(SearchResultVo searchResultVo, final Class<T> valueType) {
        return searchResultVo.getDocValues(new RowMapper<T>(){

            public T mapRow(Map<String, Object> docValue) {
                return JacksonUtil.readValue((String)JacksonUtil.toJson(docValue), (Class)valueType);
            }
        });
    }

    protected PageInfo searchResultPage(SearchResultVo searchResultVo) {
        PageInfo pageInfo = new PageInfo();
        pageInfo.setTotal(searchResultVo.getTotalSize());
        pageInfo.setPageSize(searchResultVo.getPageSize());
        pageInfo.setPageNum(searchResultVo.getCurrentPage());
        pageInfo.setPages(searchResultVo.getTotalPageNum().intValue());
        return pageInfo;
    }

    protected String wildcard(String wildcard) {
        if (StringUtils.isBlank((String)wildcard)) {
            return "";
        }
        return String.format("*%s*", wildcard).replaceAll(" ", "");
    }

    protected Date beginTime(String time) {
        return DateUtil.parse((String)(time + " 00:00:00"), (String)DatePattern.DATETIME_PATTERN.getPattern());
    }

    protected Date endTime(String time) {
        return DateUtil.parse((String)(time + " 23:59:59"), (String)DatePattern.DATETIME_PATTERN.getPattern());
    }

    protected Date beginTime() {
        return this.beginTime("1970-01-01");
    }

    protected Date endTime() {
        return this.endTime("2050-12-30");
    }

    protected String beginTimeLong(String time) {
        return String.valueOf(this.beginTime(time).getTime());
    }

    protected String endTimeLong(String time) {
        return String.valueOf(this.endTime(time).getTime());
    }

    public final void addWildcardFilter(FilterFieldVo compoundFilter, String[] fieldNames, String likeValue) {
        for (int i = 0; i < fieldNames.length; ++i) {
            compoundFilter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.wildcard((String)fieldNames[i], (String)likeValue, (LogicalSymbol)LogicalSymbol.OR)});
        }
    }

    public final void addEqualsFilter(FilterFieldVo compoundFilter, String[] fieldNames, String likeValue) {
        for (int i = 0; i < fieldNames.length; ++i) {
            compoundFilter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)fieldNames[i], (String)likeValue, (LogicalSymbol)LogicalSymbol.OR)});
        }
    }
}

