/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.domain.item.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.report.dao.das.item.DirDgDas;
import com.yunxi.dg.base.center.report.domain.item.IDirDgDomain;
import com.yunxi.dg.base.center.report.eo.item.DirDgEo;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DirDgDomainImpl
extends BaseDomainImpl<DirDgEo>
implements IDirDgDomain {
    @Resource
    private DirDgDas das;

    public ICommonDas<DirDgEo> commonDas() {
        return this.das;
    }

    @Override
    public List<DirDgEo> queryAllSub(Set<String> indexPath) {
        return this.das.queryAllSub(indexPath);
    }

    @Override
    public List<DirDgEo> getDescendants(List<Long> dirIdList) {
        if (dirIdList == null || dirIdList.isEmpty()) {
            return Collections.emptyList();
        }
        List dirs = this.das.selectAll();
        HashMap<Long, List<DirDgEo>> group = new HashMap<Long, List<DirDgEo>>();
        HashMap map = new HashMap();
        dirs.forEach(dir -> {
            map.put(dir.getId(), dir);
            List list = group.computeIfAbsent(dir.getParentId(), i -> new ArrayList());
            list.add(dir);
        });
        List<DirDgEo> parents = dirIdList.stream().map(map::get).filter(Objects::nonNull).collect(Collectors.toList());
        parents.addAll(this.getDescendants(parents, group));
        return parents;
    }

    @Override
    public List<Long> getDescendantIds(List<Long> dirIdList) {
        return this.getDescendants(dirIdList).stream().map(BaseEo::getId).collect(Collectors.toList());
    }

    @Override
    public Map<Long, List<DirDgEo>> getAncestors(List<Long> dirIds) {
        if (dirIds == null || dirIds.isEmpty()) {
            return new HashMap<Long, List<DirDgEo>>();
        }
        List dirs = this.das.selectAll();
        Map<Long, DirDgEo> map = dirs.stream().collect(Collectors.toMap(BaseEo::getId, v -> v));
        HashMap<Long, List<DirDgEo>> result = new HashMap<Long, List<DirDgEo>>();
        dirIds.forEach(dirId -> {
            List<DirDgEo> ancestors = this.getAncestors((Long)dirId, map);
            result.put((Long)dirId, ancestors);
        });
        return result;
    }

    private List<DirDgEo> getAncestors(Long dirId, Map<Long, DirDgEo> map) {
        ArrayList<DirDgEo> ancestors = new ArrayList<DirDgEo>();
        DirDgEo dir = map.get(dirId);
        if (dir == null) {
            return ancestors;
        }
        ancestors.addAll(this.getAncestors(dir.getParentId(), map));
        ancestors.add(dir);
        return ancestors;
    }

    private List<DirDgEo> getDescendants(List<DirDgEo> parents, Map<Long, List<DirDgEo>> group) {
        ArrayList<DirDgEo> result = new ArrayList<DirDgEo>();
        if (parents.isEmpty()) {
            return result;
        }
        for (DirDgEo parent : parents) {
            List<DirDgEo> children = group.getOrDefault(parent.getId(), Collections.emptyList());
            result.addAll(children);
            result.addAll(this.getDescendants(children, group));
        }
        return result;
    }

    @Override
    public <T> void setFullDirName(List<T> list, Function<T, Long> dirIdGetter, BiConsumer<T, String> dirNameSetter) {
        if (list == null || list.isEmpty()) {
            return;
        }
        List<Long> dirIds = list.stream().map(dirIdGetter).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (dirIds.isEmpty()) {
            return;
        }
        Map<Long, List<DirDgEo>> map = this.getAncestors(dirIds);
        list.forEach(dto -> {
            Long dirId = (Long)dirIdGetter.apply(dto);
            if (dirId == null) {
                return;
            }
            List ancestors = (List)map.get(dirId);
            if (CollectionUtil.isEmpty((Collection)ancestors)) {
                return;
            }
            DirDgEo root = (DirDgEo)ancestors.get(0);
            if (root.getId().equals(root.getRootId())) {
                ancestors.remove(root);
            }
            String fullDirName = ancestors.stream().map(DirDgEo::getName).collect(Collectors.joining("/"));
            dirNameSetter.accept(dto, fullDirName);
        });
    }
}

