/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.domain.impl.es;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.opensearch.api.RowMapper;
import com.dtyunxi.huieryun.opensearch.enums.LogicalSymbol;
import com.dtyunxi.huieryun.opensearch.enums.SortOrder;
import com.dtyunxi.huieryun.opensearch.vo.AggFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.AggResult;
import com.dtyunxi.huieryun.opensearch.vo.AggResultItem;
import com.dtyunxi.huieryun.opensearch.vo.FilterFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.util.JacksonUtil;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.config.SearchConfigVo;
import com.yunxi.dg.base.center.report.constants.IsFlagEnum;
import com.yunxi.dg.base.center.report.domain.es.IEsPerformOrderDomain;
import com.yunxi.dg.base.center.report.domain.impl.es.BaseEsService;
import com.yunxi.dg.base.center.report.dto.trade.req.DgEsPerformOrderReqDto;
import com.yunxi.dg.base.center.report.dto.trade.resp.DgEsAddressRespDto;
import com.yunxi.dg.base.center.report.dto.trade.resp.DgEsPerformOrderRespDto;
import com.yunxi.dg.base.center.report.dto.trade.resp.DgEsPerformOrderStatusCountRespDto;
import com.yunxi.dg.base.center.report.enums.DgPerformOrderStatusEnum;
import com.yunxi.dg.base.center.report.util.EsSearchUtils;
import com.yunxi.dg.base.center.report.util.RptUtil;
import com.yunxi.dg.base.commons.dataLimit.annotations.DataLimitSelector;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EsPerformOrderDomainImpl
extends BaseEsService
implements IEsPerformOrderDomain {
    private static final Logger log = LoggerFactory.getLogger(EsPerformOrderDomainImpl.class);
    String tableName = "tr_dg_perform_order_info";
    @Resource
    private SearchConfigVo searchConfigVo;
    private static final String[] ORDER_NOS = new String[]{"platformOrderNo", "saleOrderNo", "inventoryLogisticsNo", "deliveryNoticeNo", "mergeOrderNo", "shippingNoList", "distributionOrderNo"};
    private static final String[] LOGICAL_WAREHOUSE = new String[]{"logicalWarehouseCode", "logicalWarehouseName"};
    private static final String[] KEYWORD = new String[]{"deliveryName", "deliveryPhone", "buyerNickname", "platformOrderNo", "saleOrderNo"};
    private static final String[] H5_KEYWORD = new String[]{"customerName", "itemNameList", "saleOrderNo", "receivePhone"};
    private static final String[] ORDER_LABEL_CODES = new String[]{"orderLabelCodes", "orderItemLabelCodes"};

    @Override
    public PageInfo<DgEsPerformOrderRespDto> queryEsByPage(DgEsPerformOrderReqDto filter) {
        String indexName = this.searchConfigVo.getIndexNamePreFix() + "-" + this.tableName;
        PageInfo pageInfo = new PageInfo();
        try {
            OSSearchVo queryVo = this.initSearchVo(filter);
            BigDecimal pageNum = new BigDecimal(filter.getPageNum());
            BigDecimal pageSize = new BigDecimal(filter.getPageSize());
            BigDecimal maxSize = new BigDecimal(10000);
            queryVo.setPage(pageNum.intValue());
            queryVo.setPageSize(pageSize.intValue());
            ServiceContext.getContext().setAttachment("data_limit_authority_selector", "tr_dg_perform_order_snapshot");
            ServiceContext.getContext().setAttachment("data_limit_authority_selector_counter", "1");
            SearchResultVo searchResultVo = this.searchData(indexName, queryVo);
            log.info("\u5206\u9875\u67e5\u8be2es\u5206\u9875\u6570\u636e\u5165\u53c2===============================================================>{}", (Object)JacksonUtil.toJson((Object)queryVo));
            if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
                return new PageInfo();
            }
            pageInfo = this.searchResultPage(searchResultVo);
            pageInfo.setList(searchResultVo.getDocValues((RowMapper)new PerformOrderRowMapper()));
        }
        catch (Exception e) {
            log.error("ES\u67e5\u8be2\u5f02\u5e38:", (Throwable)e);
            throw new BizException("ES\u67e5\u8be2\u5f02\u5e38:" + e.getMessage());
        }
        return pageInfo;
    }

    @Override
    @DataLimitSelector(tableName="tr_dg_perform_order_snapshot")
    public DgEsPerformOrderStatusCountRespDto queryCount(DgEsPerformOrderReqDto filter) {
        DgEsPerformOrderStatusCountRespDto data = new DgEsPerformOrderStatusCountRespDto();
        String indexName = this.searchConfigVo.getIndexNamePreFix() + "-" + this.tableName;
        try {
            List aggResults;
            OSSearchVo queryVo = this.initSearchVo(filter);
            ArrayList<AggFieldVo> aggFieldVoList = new ArrayList<AggFieldVo>();
            AggFieldVo orderStatus = AggFieldVo.terms((String)"orderStatus");
            AggFieldVo errorType = AggFieldVo.terms((String)"errorType");
            AggFieldVo orderLabelCodes = AggFieldVo.terms((String)"orderLabelCode");
            AggFieldVo errorReasons = AggFieldVo.terms((String)"errorReason");
            aggFieldVoList.add(orderStatus);
            aggFieldVoList.add(errorType);
            aggFieldVoList.add(orderLabelCodes);
            aggFieldVoList.add(errorReasons);
            queryVo.setAggFields(aggFieldVoList);
            ServiceContext.getContext().setAttachment("data_limit_authority_selector", "tr_dg_perform_order_snapshot");
            ServiceContext.getContext().setAttachment("data_limit_authority_selector_counter", "1");
            log.info("\u5206\u9875\u67e5\u8be2es\u7edf\u8ba1\u6570\u636e\u5165\u53c2===============================================================>{}", (Object)JacksonUtil.toJson((Object)queryVo));
            SearchResultVo searchResultVo = this.searchData(indexName, queryVo);
            if (log.isDebugEnabled()) {
                // empty if block
            }
            if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
                return new DgEsPerformOrderStatusCountRespDto();
            }
            if (searchResultVo != null && CollectionUtils.isNotEmpty((Collection)(aggResults = searchResultVo.getAggResults()))) {
                for (AggResult aggResult : aggResults) {
                    AggResultItem aggResultItem;
                    Object aggResultItem22;
                    List aggResultItems = aggResult.getAggResultItems();
                    BigDecimal allCount = BigDecimal.ZERO;
                    if (Objects.equals("orderStatus", aggResult.getFieldName())) {
                        if (!CollectionUtils.isNotEmpty((Collection)aggResultItems)) continue;
                        for (Object aggResultItem22 : aggResultItems) {
                            String fieldValue = aggResultItem22.getFieldValue();
                            DgPerformOrderStatusEnum orderStatusEnum = DgPerformOrderStatusEnum.forCode((String)fieldValue);
                            switch (orderStatusEnum) {
                                case WAIT_CHECK: {
                                    data.setWaitCheckCount(BigDecimal.valueOf(aggResultItem22.getDocCount()));
                                    break;
                                }
                                case WAIT_PAY: {
                                    data.setWaitPayCount(BigDecimal.valueOf(aggResultItem22.getDocCount()));
                                    break;
                                }
                                case DELIVERY_ALL: {
                                    data.setDeliveryAllCount(BigDecimal.valueOf(aggResultItem22.getDocCount()));
                                    break;
                                }
                                case PART_DELIVERY: {
                                    data.setPartDeliveryCount(BigDecimal.valueOf(aggResultItem22.getDocCount()));
                                    break;
                                }
                                case CLOSE: {
                                    data.setCloseCount(BigDecimal.valueOf(aggResultItem22.getDocCount()));
                                    break;
                                }
                                case WAIT_FINANCE_AUDIT: {
                                    data.setWaitFinanceAuditCount(BigDecimal.valueOf(aggResultItem22.getDocCount()));
                                    break;
                                }
                                case WAIT_OUT_STORAGE: {
                                    data.setWaitOutStorageCount(BigDecimal.valueOf(aggResultItem22.getDocCount()));
                                    break;
                                }
                                case LOCK_UN_DELIVERY: {
                                    data.setLockUnDeliveryCount(BigDecimal.valueOf(aggResultItem22.getDocCount()));
                                    break;
                                }
                                case WAIT_DELIVERY: {
                                    data.setWaitDeliveryCount(BigDecimal.valueOf(aggResultItem22.getDocCount()));
                                    break;
                                }
                                case COMPLETE: {
                                    data.setCompleteCount(BigDecimal.valueOf(aggResultItem22.getDocCount()));
                                    break;
                                }
                                case CANCEL: {
                                    data.setCancelCount(BigDecimal.valueOf(aggResultItem22.getDocCount()));
                                    break;
                                }
                                case FINISH: {
                                    data.setFinishCount(BigDecimal.valueOf(aggResultItem22.getDocCount()));
                                    break;
                                }
                                case SPLIT: {
                                    data.setSplitCount(BigDecimal.valueOf(aggResultItem22.getDocCount()));
                                    break;
                                }
                                case CANCELING: {
                                    data.setCancelingCount(BigDecimal.valueOf(aggResultItem22.getDocCount()));
                                    break;
                                }
                                case RECEIVED: {
                                    data.setReceivedCount(BigDecimal.valueOf(aggResultItem22.getDocCount()));
                                    break;
                                }
                                case OBSOLETE: {
                                    data.setObsoleteCount(BigDecimal.valueOf(aggResultItem22.getDocCount()));
                                    break;
                                }
                                case WAIT_CUSTOMER_AUDIT: {
                                    data.setWaitCustomerAuditCount(BigDecimal.valueOf(aggResultItem22.getDocCount()));
                                    break;
                                }
                                case WAIT_BUSINESS_AUDIT: {
                                    data.setWaitBusinessAuditCount(BigDecimal.valueOf(aggResultItem22.getDocCount()));
                                    break;
                                }
                                case WAIT_PICK: {
                                    data.setWaitPickCount(BigDecimal.valueOf(aggResultItem22.getDocCount()));
                                    break;
                                }
                                case WAIT_AUDIT: {
                                    data.setWaitAuditCount(BigDecimal.valueOf(aggResultItem22.getDocCount()));
                                    break;
                                }
                                case LACK: {
                                    data.setLackCount(BigDecimal.valueOf(aggResultItem22.getDocCount()));
                                    break;
                                }
                                case WAIT_EXTERNAL_AUDIT: {
                                    data.setExternalAuditCount(BigDecimal.valueOf(aggResultItem22.getDocCount()));
                                    break;
                                }
                                case WAIT_PUSH: {
                                    data.setWaitPushCount(BigDecimal.valueOf(aggResultItem22.getDocCount()));
                                    break;
                                }
                                case PICKED: {
                                    data.setPickedCount(BigDecimal.valueOf(aggResultItem22.getDocCount()));
                                    break;
                                }
                                case DELIVERY_PART: {
                                    data.setDeliveryPartCount(BigDecimal.valueOf(aggResultItem22.getDocCount()));
                                }
                            }
                            allCount = allCount.add(BigDecimal.valueOf(aggResultItem22.getDocCount()));
                        }
                        data.setAllCount(allCount);
                        continue;
                    }
                    if (Objects.equals("errorType", aggResult.getFieldName())) {
                        if (!CollectionUtils.isNotEmpty((Collection)aggResultItems)) continue;
                        log.info("\u5f02\u5e38\u7edf\u8ba1\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)aggResultItems);
                        BigDecimal abnormalCount = BigDecimal.ZERO;
                        aggResultItem22 = aggResultItems.iterator();
                        while (aggResultItem22.hasNext()) {
                            aggResultItem = (AggResultItem)aggResultItem22.next();
                            abnormalCount = abnormalCount.add(BigDecimal.valueOf(aggResultItem.getDocCount()));
                            allCount = allCount.add(BigDecimal.valueOf(aggResultItem.getDocCount()));
                        }
                        data.setAbnormalCount(abnormalCount);
                        continue;
                    }
                    if (Objects.equals("orderLabelCode", aggResult.getFieldName())) {
                        BigDecimal lockCount = BigDecimal.ZERO;
                        if (CollectionUtils.isNotEmpty((Collection)aggResultItems)) {
                            log.info("\u6302\u8d77\u72b6\u6001\u7edf\u8ba1\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)aggResultItems);
                            aggResultItem22 = aggResultItems.iterator();
                            while (aggResultItem22.hasNext()) {
                                aggResultItem = (AggResultItem)aggResultItem22.next();
                                String fieldValue = aggResultItem.getFieldValue();
                                if (!fieldValue.contains("LOCK") && !fieldValue.contains("F2B_LOCK")) continue;
                                lockCount = lockCount.add(BigDecimal.valueOf(aggResultItem.getDocCount()));
                                allCount = allCount.add(BigDecimal.valueOf(aggResultItem.getDocCount()));
                            }
                        }
                        data.setLockCount(lockCount);
                        continue;
                    }
                    if (!Objects.equals("errorReason", aggResult.getFieldName())) continue;
                    for (Object aggResultItem22 : aggResultItems) {
                        if (!"\u53d1\u8d27\u524d\u9000\u6b3e\u62e6\u622a\u5931\u8d25".equals(aggResultItem22.getFieldValue())) continue;
                        data.setInterceptBeforeDeliveryCount(aggResultItem22.getDocCount());
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u5c65\u7ea6\u8ba2\u5355\u72b6\u6001\u7edf\u8ba1ES\u67e5\u8be2\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new BizException("\u5c65\u7ea6\u8ba2\u5355\u72b6\u6001\u7edf\u8ba1ES\u67e5\u8be2\u5f02\u5e38");
        }
        return data;
    }

    private OSSearchVo initSearchVo(DgEsPerformOrderReqDto reqDto) throws Exception {
        String endTime;
        String startTime;
        FilterFieldVo nonExistsFilter;
        String keyword;
        FilterFieldVo keywordFilter;
        int n;
        int n2;
        String[] stringArray;
        log.info("ES\u67e5\u8be2\u8ba2\u5355\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)reqDto));
        OSSearchVo queryVo = EsSearchUtils.newInstance().getNewSearchVo(reqDto);
        if (Objects.nonNull(reqDto.getOrderNo()) && CollectionUtils.isEmpty((Collection)reqDto.getOrderNos())) {
            String o;
            String orderNo = reqDto.getOrderNo();
            orderNo = orderNo.replaceAll("\uff0c", ",");
            String[] orderNos = RptUtil.regExSplit(orderNo);
            FilterFieldVo filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            if (orderNos.length > 1) {
                stringArray = ORDER_NOS;
                n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    o = stringArray[n];
                    filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)o, (String[])orderNos, (LogicalSymbol)LogicalSymbol.OR)});
                }
            } else {
                stringArray = orderNos;
                n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    o = stringArray[n];
                    this.addWildcardFilter(filter, ORDER_NOS, this.wildcard(o));
                }
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getNotInOrderList())) {
            queryVo.addNonInFilter("saleOrderNo", reqDto.getNotInOrderList().toArray(new String[reqDto.getNotInOrderList().size()]));
        }
        if (Objects.nonNull(reqDto.getKeyword()) || CollectionUtils.isNotEmpty((Collection)reqDto.getOrderNos())) {
            keywordFilter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            if (Objects.nonNull(reqDto.getKeyword())) {
                keyword = reqDto.getKeyword();
                this.addWildcardFilter(keywordFilter, KEYWORD, this.wildcard(keyword));
            }
            if (CollectionUtils.isNotEmpty((Collection)reqDto.getOrderNos())) {
                String[] orderNos;
                List orderNoList = reqDto.getOrderNos();
                if (Objects.nonNull(reqDto.getOrderNo())) {
                    String[] orderNos2;
                    String orderNo = reqDto.getOrderNo();
                    String[] stringArray2 = orderNos2 = RptUtil.regExSplit(orderNo);
                    n = stringArray2.length;
                    for (int o = 0; o < n; ++o) {
                        String o2 = stringArray2[o];
                        orderNoList.add(o2);
                    }
                }
                if ((orderNos = orderNoList.toArray(new String[0])).length > 20) {
                    stringArray = ORDER_NOS;
                    n2 = stringArray.length;
                    for (n = 0; n < n2; ++n) {
                        String o = stringArray[n];
                        keywordFilter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)o, (String[])orderNos, (LogicalSymbol)LogicalSymbol.OR)});
                    }
                } else {
                    stringArray = orderNos;
                    n2 = stringArray.length;
                    for (n = 0; n < n2; ++n) {
                        String o = stringArray[n];
                        this.addWildcardFilter(keywordFilter, ORDER_NOS, this.wildcard(String.valueOf(o)));
                    }
                }
            }
            queryVo.addFilters(new FilterFieldVo[]{keywordFilter});
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getOrderStatus())) {
            String[] statuses = RptUtil.regExSplit(reqDto.getOrderStatus());
            FilterFieldVo filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (String o : statuses) {
                this.addWildcardFilter(filter, new String[]{"orderStatus"}, this.wildcard(o));
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getOrderLabelCodes())) {
            FilterFieldVo filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (String o : reqDto.getOrderLabelCodes()) {
                if ("ARRANGE_SHIPMENT_ENTERPRISE".equals(o)) {
                    queryVo.addExistsFilter("planShipmentEnterpriseName");
                    continue;
                }
                this.addWildcardFilter(filter, ORDER_LABEL_CODES, o);
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (Objects.nonNull(reqDto.getRemarkFlag()) && StringUtils.isEmpty((CharSequence)reqDto.getRemark())) {
            if (IsFlagEnum.YES.getCode().equals(reqDto.getRemarkFlag().toString())) {
                queryVo.addExistsFilter("remark");
            } else {
                nonExistsFilter = FilterFieldVo.exists((String)"remark");
                nonExistsFilter.setNon(Boolean.valueOf(true));
                queryVo.addFilters(new FilterFieldVo[]{nonExistsFilter});
            }
        } else if (StringUtils.isNotEmpty((CharSequence)reqDto.getRemark())) {
            if (Objects.isNull(reqDto.getRemarkFlag()) || IsFlagEnum.YES.getCode().equals(reqDto.getRemarkFlag().toString())) {
                queryVo.addWildcardFilter("remark", this.wildcard(reqDto.getRemark()));
            } else {
                nonExistsFilter = FilterFieldVo.exists((String)"remark");
                nonExistsFilter.setNon(Boolean.valueOf(true));
                queryVo.addFilters(new FilterFieldVo[]{nonExistsFilter});
            }
        }
        if (Objects.nonNull(reqDto.getSellerRemarkFlag()) && StringUtils.isEmpty((CharSequence)reqDto.getSellerRemark())) {
            if (IsFlagEnum.YES.getCode().equals(reqDto.getSellerRemarkFlag().toString())) {
                queryVo.addExistsFilter("sellerRemark");
            } else {
                nonExistsFilter = FilterFieldVo.exists((String)"sellerRemark");
                nonExistsFilter.setNon(Boolean.valueOf(true));
                queryVo.addFilters(new FilterFieldVo[]{nonExistsFilter});
            }
        } else if (StringUtils.isNotEmpty((CharSequence)reqDto.getSellerRemark())) {
            if (Objects.isNull(reqDto.getSellerRemarkFlag()) || IsFlagEnum.YES.getCode().equals(reqDto.getSellerRemarkFlag().toString())) {
                queryVo.addWildcardFilter("sellerRemark", this.wildcard(reqDto.getSellerRemark()));
            } else {
                nonExistsFilter = FilterFieldVo.exists((String)"sellerRemark");
                nonExistsFilter.setNon(Boolean.valueOf(true));
                queryVo.addFilters(new FilterFieldVo[]{nonExistsFilter});
            }
        }
        if (Objects.nonNull(reqDto.getBuyerRemarkFlag()) && StringUtils.isEmpty((CharSequence)reqDto.getBuyerRemark())) {
            if (IsFlagEnum.YES.getCode().equals(reqDto.getBuyerRemarkFlag().toString())) {
                queryVo.addExistsFilter("buyerRemark");
            } else {
                nonExistsFilter = FilterFieldVo.exists((String)"buyerRemark");
                nonExistsFilter.setNon(Boolean.valueOf(true));
                queryVo.addFilters(new FilterFieldVo[]{nonExistsFilter});
            }
        } else if (StringUtils.isNotEmpty((CharSequence)reqDto.getBuyerRemark())) {
            if (Objects.isNull(reqDto.getBuyerRemarkFlag()) || IsFlagEnum.YES.getCode().equals(reqDto.getBuyerRemarkFlag().toString())) {
                queryVo.addWildcardFilter("buyerRemark", this.wildcard(reqDto.getBuyerRemark()));
            } else {
                nonExistsFilter = FilterFieldVo.exists((String)"buyerRemark");
                nonExistsFilter.setNon(Boolean.valueOf(true));
                queryVo.addFilters(new FilterFieldVo[]{nonExistsFilter});
            }
        }
        if (Objects.isNull(reqDto.getGoodsTotalNumGt()) && Objects.nonNull(reqDto.getGoodsTotalNumLt()) || Objects.nonNull(reqDto.getGoodsTotalNumGt()) && Objects.isNull(reqDto.getGoodsTotalNumLt())) {
            if (Objects.isNull(reqDto.getGoodsTotalNumGt())) {
                queryVo.addRangeFilter("goodsTotalNum", "0", reqDto.getGoodsTotalNumLt().toString());
            } else {
                queryVo.addRangeFilter("goodsTotalNum", reqDto.getGoodsTotalNumGt().toString(), String.valueOf(Integer.MAX_VALUE));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getNotOrderTagCodes())) {
            queryVo.addNonInFilter("orderTagCodes", reqDto.getNotOrderTagCodes().toArray(new String[reqDto.getNotOrderTagCodes().size()]));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getNotOrderLabelCodes())) {
            queryVo.addNonInFilter("orderLabelCodes", reqDto.getNotOrderLabelCodes().toArray(new String[reqDto.getNotOrderLabelCodes().size()]));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getNotInOrderStatusList())) {
            queryVo.addNonInFilter("orderStatus", reqDto.getNotInOrderStatusList().toArray(new String[reqDto.getNotInOrderStatusList().size()]));
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getH5Keyword())) {
            keywordFilter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            keyword = reqDto.getH5Keyword();
            this.addWildcardFilter(keywordFilter, H5_KEYWORD, this.wildcard(keyword));
            queryVo.addFilters(new FilterFieldVo[]{keywordFilter});
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getCsAuditStartTime()) && StringUtils.isNotBlank((CharSequence)reqDto.getCsAuditEndTime())) {
            startTime = String.valueOf(DateUtil.parseDateTime((CharSequence)reqDto.getCsAuditStartTime()).getTime());
            endTime = String.valueOf(DateUtil.parseDateTime((CharSequence)reqDto.getCsAuditEndTime()).getTime());
            queryVo.addRangeFilter("csAuditTime", startTime, endTime);
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getFinanceAuditStartTime()) && StringUtils.isNotBlank((CharSequence)reqDto.getFinanceAuditEndTime())) {
            startTime = String.valueOf(DateUtil.parseDateTime((CharSequence)reqDto.getFinanceAuditStartTime()).getTime());
            endTime = String.valueOf(DateUtil.parseDateTime((CharSequence)reqDto.getFinanceAuditEndTime()).getTime());
            queryVo.addRangeFilter("financeAuditTime", startTime, endTime);
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getSaleAuditStartTime()) && StringUtils.isNotBlank((CharSequence)reqDto.getSaleAuditEndTime())) {
            startTime = String.valueOf(DateUtil.parseDateTime((CharSequence)reqDto.getSaleAuditStartTime()).getTime());
            endTime = String.valueOf(DateUtil.parseDateTime((CharSequence)reqDto.getSaleAuditEndTime()).getTime());
            queryVo.addRangeFilter("customerAuditTime", startTime, endTime);
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getCustomerBatch())) {
            queryVo.addWildcardFilter("customerBatch", this.wildcard(reqDto.getCustomerBatch()));
        }
        if (null != reqDto.getTransportStyle()) {
            queryVo.addEqualFilter("transportStyle", reqDto.getTransportStyle().toString());
        }
        if (Objects.nonNull(reqDto.getUseScrollId())) {
            queryVo.addRangeFilter("id", "0", String.valueOf(reqDto.getUseScrollId()));
        }
        queryVo.addSort("id", SortOrder.DESC);
        log.info("ES\u67e5\u8be2\u8ba2\u5355\u53c2\u6570\u5c01\u88c5\u540e\uff1a{}", (Object)JSONObject.toJSONString((Object)queryVo));
        return queryVo;
    }

    @Override
    protected SearchResultVo searchData(String indexName, OSSearchVo osSearchVo) {
        try {
            osSearchVo.setIndexName(indexName);
            return this.openSearchService.search(osSearchVo);
        }
        catch (Exception e) {
            log.error("\u641c\u7d22\u5f02\u5e38\uff1a", (Throwable)e);
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected PageInfo searchResultPage(SearchResultVo searchResultVo) {
        PageInfo pageInfo = new PageInfo();
        pageInfo.setTotal(searchResultVo.getTotalSize());
        pageInfo.setPageSize(searchResultVo.getPageSize());
        pageInfo.setPageNum(searchResultVo.getCurrentPage());
        pageInfo.setPages(searchResultVo.getTotalPageNum().intValue());
        return pageInfo;
    }

    private void findByStatemachineEvent(OSSearchVo queryVo, String event, String startTime, String endTime) {
        queryVo.addEqualFilter("statemachineEventExecuteList.event", event);
        queryVo.addEqualFilter("statemachineEventExecuteList.executeStatus", "1");
        String financeAuditStartTime = String.valueOf(DateUtil.parseDateTime((CharSequence)startTime).getTime());
        String financeAuditEndTime = String.valueOf(DateUtil.parseDateTime((CharSequence)endTime).getTime());
        queryVo.addRangeFilter("statemachineEventExecuteList.preEventTime", financeAuditStartTime, financeAuditEndTime);
    }

    class PerformOrderRowMapper
    implements RowMapper<DgEsPerformOrderRespDto> {
        PerformOrderRowMapper() {
        }

        public DgEsPerformOrderRespDto mapRow(Map<String, Object> docValue) {
            DgEsPerformOrderRespDto performOrderRespDto = (DgEsPerformOrderRespDto)JacksonUtil.readValue((String)JacksonUtil.toJson(docValue), DgEsPerformOrderRespDto.class);
            DgEsAddressRespDto orderAddress = new DgEsAddressRespDto();
            orderAddress.setDetailAddress(this.builderFormatStr(docValue, "receiveAddress"));
            orderAddress.setReceiveAddress(this.builderFormatStr(docValue, "receiveAddress"));
            orderAddress.setProvince(this.builderFormatStr(docValue, "province"));
            orderAddress.setProvinceCode(this.builderFormatStr(docValue, "provinceCode"));
            orderAddress.setCity(this.builderFormatStr(docValue, "city"));
            orderAddress.setCityCode(this.builderFormatStr(docValue, "cityCode"));
            orderAddress.setDistrict(this.builderFormatStr(docValue, "district"));
            orderAddress.setDistrictCode(this.builderFormatStr(docValue, "districtCode"));
            orderAddress.setStreet(this.builderFormatStr(docValue, "street"));
            orderAddress.setStreetCode(this.builderFormatStr(docValue, "streetCode"));
            orderAddress.setCounty(this.builderFormatStr(docValue, "county"));
            orderAddress.setCountyCode(this.builderFormatStr(docValue, "countyCode"));
            orderAddress.setId(this.builderFormatLong(docValue, "addressId"));
            performOrderRespDto.setOrderAddress(orderAddress);
            performOrderRespDto.setShippingNos(CollectionUtils.isNotEmpty((Collection)performOrderRespDto.getShippingNoList()) ? String.join((CharSequence)",", performOrderRespDto.getShippingNoList()) : null);
            return performOrderRespDto;
        }

        private String builderFormatStr(Map<String, Object> docValue, String reqParam) {
            if (docValue.get(reqParam) != null) {
                return docValue.get(reqParam).toString();
            }
            return null;
        }

        private Long builderFormatLong(Map<String, Object> docValue, String reqParam) {
            if (docValue.get(reqParam) != null) {
                return (Long)docValue.get(reqParam);
            }
            return null;
        }
    }
}

