/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.domain.entity.impl;

import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.dao.das.IBizTagRecordDas;
import com.yunxi.dg.base.center.report.domain.entity.IBizTagRecordDomain;
import com.yunxi.dg.base.center.report.dto.tag.ReBizTagRecordDelReqDto;
import com.yunxi.dg.base.center.report.dto.tag.ReBizTagRecordPageReqDto;
import com.yunxi.dg.base.center.report.dto.tag.ReBizTagRecordRespDto;
import com.yunxi.dg.base.center.report.dto.tag.SearchTagRecordLinkDto;
import com.yunxi.dg.base.center.report.eo.BizTagRecordEo;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class BizTagRecordDomainImpl
extends BaseDomainImpl<BizTagRecordEo>
implements IBizTagRecordDomain {
    @Resource
    private IBizTagRecordDas das;

    public ICommonDas<BizTagRecordEo> commonDas() {
        return this.das;
    }

    @Override
    public List<ReBizTagRecordRespDto> queryList(ReBizTagRecordPageReqDto pageDto) {
        return this.das.queryList(pageDto);
    }

    @Override
    public void logicDel(ReBizTagRecordDelReqDto param) {
        this.das.logicDel(param);
    }

    @Override
    public List<BizTagRecordEo> listByTagCodesLinkIds(Set<String> tagCodes, Set<Long> linkIds, Set<Long> recordLinkParentId) {
        return this.das.listByTagCodesLinkIds(tagCodes, linkIds, recordLinkParentId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchInsert(List<BizTagRecordEo> dtoList) {
        Lists.partition(dtoList, (int)1000).forEach(en -> this.das.batchInsert(dtoList));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchReplace(List<BizTagRecordEo> dtoList, List<Long> delIds) {
        if (!CollectionUtils.isEmpty(dtoList)) {
            Lists.partition(dtoList, (int)1000).forEach(en -> this.das.batchInsert(dtoList));
        }
        if (!CollectionUtils.isEmpty(delIds)) {
            Lists.partition(delIds, (int)1000).forEach(en -> {
                ReBizTagRecordDelReqDto delParam = new ReBizTagRecordDelReqDto();
                delParam.setIdList(en);
                this.das.logicDel(delParam);
            });
        }
    }

    @Override
    public List<BizTagRecordEo> findParams(SearchTagRecordLinkDto reqDto) {
        return this.das.findParams(reqDto);
    }
}

