/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.domain.entity.impl;

import cn.hutool.core.date.DateUtil;
import com.yunxi.dg.base.center.report.dao.das.IActualCostAllocRuleDas;
import com.yunxi.dg.base.center.report.dao.das.IActualCostAllocRuleFixedDas;
import com.yunxi.dg.base.center.report.dao.das.IActualCostAllocRuleScopeDas;
import com.yunxi.dg.base.center.report.domain.entity.IActualCostAllocRuleDomain;
import com.yunxi.dg.base.center.report.dto.entity.CostAllocRuleDto;
import com.yunxi.dg.base.center.report.eo.ActualCostAllocRuleEo;
import com.yunxi.dg.base.center.report.eo.ActualCostAllocRuleFixedEo;
import com.yunxi.dg.base.center.report.eo.ActualCostAllocRuleScopeEo;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ActualCostAllocRuleDomainImpl
extends BaseDomainImpl<ActualCostAllocRuleEo>
implements IActualCostAllocRuleDomain {
    @Resource
    private IActualCostAllocRuleDas das;
    @Resource
    private IActualCostAllocRuleFixedDas actualCostAllocRuleFixedDas;
    @Resource
    private IActualCostAllocRuleScopeDas actualCostAllocRuleScopeDas;

    public ICommonDas<ActualCostAllocRuleEo> commonDas() {
        return this.das;
    }

    @Override
    public List<CostAllocRuleDto> getRules(List<String> statusList) {
        List rules = this.das.getRules(statusList);
        if (rules.isEmpty()) {
            return rules;
        }
        Set ruleIds = rules.stream().map(CostAllocRuleDto::getRuleId).collect(Collectors.toSet());
        List fixedList = this.actualCostAllocRuleFixedDas.findByRuleIds(ruleIds);
        Map<Long, Map<LocalDate, BigDecimal>> fixedMapGroup = fixedList.stream().collect(Collectors.groupingBy(ActualCostAllocRuleFixedEo::getRuleId, Collectors.toMap(v -> DateUtil.toLocalDateTime((Date)v.getBizDate()).toLocalDate(), ActualCostAllocRuleFixedEo::getTotalCostAmount)));
        List scopeList = this.actualCostAllocRuleScopeDas.findByRuleIds(ruleIds);
        Map scopeKeysMap = scopeList.stream().collect(Collectors.groupingBy(ActualCostAllocRuleScopeEo::getRuleId, Collectors.mapping(ActualCostAllocRuleScopeEo::getShopCode, Collectors.toSet())));
        rules.forEach(rule -> {
            if (rule.getProportion() != null) {
                rule.setProportion(rule.getProportion().divide(new BigDecimal("100"), 6, RoundingMode.UP));
            }
            Map fixedMap = fixedMapGroup.getOrDefault(rule.getRuleId(), Collections.emptyMap());
            rule.setActualFixedCostMap(fixedMap);
            Set scopeKeys = scopeKeysMap.getOrDefault(rule.getRuleId(), Collections.emptySet());
            rule.setEffectiveScopeKeys(scopeKeys);
        });
        return rules;
    }
}

