/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.constants;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public enum DgOrderAmountTypeEnum {
    GIFT_ORDER("GIFT_ORDER", "", "\u968f\u5355\u8d60\u54c1", "PROMOTION"),
    GIFT_ADD("GIFT_ADD", "", "\u6dfb\u52a0\u8d60\u54c1", "PROMOTION"),
    FULL_REDUCE("FULL_REDUCE", "", "\u6ee1\u51cf", "PROMOTION"),
    FULL_DISCOUNT("FULL_DISCOUNT", "", "\u6ee1\u6298", "PROMOTION"),
    COUPON("COUPON", "", "\u4f18\u60e0\u5238", "PROMOTION"),
    SPECIAL_OFFER("SPECIAL_OFFER", "", "\u7279\u4ef7\u4f18\u60e0", "PROMOTION"),
    PANIC_BUYING("PANIC_BUYING", "", "\u62a2\u8d2d", "PROMOTION"),
    REPLENISH("REPLENISH", "", "\u8865\u8d27", "COST"),
    REBATE("REBATE", "", "\u8fd4\u5229", "COST"),
    INTEGRAL("INTEGRAL", "", "\u79ef\u5206", "COST"),
    GOLD("GOLD", "", "\u91d1\u5e01", "COST"),
    KNEAD_PRICE("KNEAD_PRICE", "", "\u63c9\u4ef7\u5355\u4ef7", "KNEAD"),
    KNEAD_TOTAL("KNEAD_TOTAL", "", "\u63c9\u4ef7\u91d1\u989d", "KNEAD"),
    KNEAD_LATER_PRICE("KNEAD_LATER_PRICE", "", "\u63c9\u4ef7\u540e\u5355\u4ef7", "KNEAD"),
    KNEAD_LATER_TOTAL("KNEAD_LATER_TOTAL", "", "\u63c9\u4ef7\u540e\u91d1\u989d", "KNEAD"),
    PROMOTION_KNEAD_TOTAL("PROMOTION_KNEAD_TOTAL", "", "\u4fc3\u9500\u63c9\u4ef7\u603b\u989d", "KNEAD"),
    COST_KNEAD_TOTAL("COST_KNEAD_TOTAL", "", "\u8d39\u7528\u63c9\u4ef7\u603b\u989d", "KNEAD"),
    KNEAD_LATER_TAX("KNEAD_LATER_TAX", "", "\u63c9\u4ef7\u540e\u7a0e\u989d", "KNEAD"),
    KNEAD_LATER_TOTAL_NOT_TAX("KNEAD_LATER_TOTAL_NOT_TAX", "", "\u63c9\u4ef7\u540e\u91d1\u989d\uff08\u4e0d\u542b\u7a0e\uff09", "KNEAD"),
    SALE_TOTAL_PRICE("SALE_TOTAL_PRICE", "", "\u9500\u552e\u5355\u4ef7", "ORDER_BASE"),
    SALE_TOTAL("SALE_TOTAL", "", "\u9500\u552e\u91d1\u989d", "ORDER_BASE"),
    SUPPLY_TOTAL_PRICE("SUPPLY_TOTAL_PRICE", "", "\u4f9b\u8d27\u5355\u4ef7", "ORDER_BASE"),
    SUPPLY_TOTAL("SUPPLY_TOTAL", "", "\u4f9b\u8d27\u91d1\u989d", "ORDER_BASE");

    private final String code;
    private final String relCode;
    private final String desc;
    private final String belong;
    public static final Map<String, DgOrderAmountTypeEnum> CODE_LOOKUP;

    private DgOrderAmountTypeEnum(String code, String relCode, String desc, String belong) {
        this.code = code;
        this.relCode = relCode;
        this.desc = desc;
        this.belong = belong;
    }

    public String getCode() {
        return this.code;
    }

    public String getRelCode() {
        return this.relCode;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getBelong() {
        return this.belong;
    }

    public static List<String> kneadTypes() {
        return Lists.newArrayList((Object[])new String[]{GIFT_ORDER.getCode(), GIFT_ADD.getCode(), FULL_REDUCE.getCode(), FULL_DISCOUNT.getCode(), COUPON.getCode(), SPECIAL_OFFER.getCode(), PANIC_BUYING.getCode(), REPLENISH.getCode(), REBATE.getCode(), INTEGRAL.getCode(), GOLD.getCode()});
    }

    public static List<String> getForBelong(String belong) {
        return Arrays.stream(DgOrderAmountTypeEnum.values()).filter(f -> f.getBelong().equals(belong)).map(DgOrderAmountTypeEnum::getCode).collect(Collectors.toList());
    }

    public static DgOrderAmountTypeEnum getForCode(String code) {
        return CODE_LOOKUP.get(code);
    }

    static {
        CODE_LOOKUP = Arrays.stream(DgOrderAmountTypeEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
    }
}

