/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.dto.entity;

import com.yunxi.dg.base.center.report.dto.entity.CustomerRebateDetailReportDto;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Optional;

public class CustomerRebatePeriodDto {
    private Date begin = null;
    private Long beginId;
    private BigDecimal beginBalance = BigDecimal.ZERO;
    private Date end = null;
    private Long endId;
    private BigDecimal endBalance = BigDecimal.ZERO;
    private BigDecimal tradeAmount = BigDecimal.ZERO;
    private BigDecimal changeInAmount = BigDecimal.ZERO;
    private BigDecimal changeOutAmount = BigDecimal.ZERO;

    public void compare(CustomerRebateDetailReportDto dto) {
        this.tradeAmount = this.tradeAmount.add(dto.getTradeAmount());
        if (dto.getType().equals(0)) {
            this.changeInAmount = this.changeInAmount.add(dto.getTradeAmount());
        } else {
            this.changeOutAmount = this.changeOutAmount.add(dto.getTradeAmount());
        }
        if (this.begin == null || this.begin.after(dto.getChangeTime()) || this.begin.equals(dto.getChangeTime()) && dto.getFlowId() < this.beginId) {
            this.begin = dto.getChangeTime();
            this.beginId = dto.getFlowId();
            this.beginBalance = Optional.ofNullable(dto.getBeforeBalance()).orElse(BigDecimal.ZERO);
        }
        if (this.end == null || this.end.before(dto.getChangeTime()) || this.end.equals(dto.getChangeTime()) && dto.getFlowId() > this.endId) {
            this.end = dto.getChangeTime();
            this.endId = dto.getFlowId();
            this.endBalance = Optional.ofNullable(dto.getBalance()).orElse(BigDecimal.ZERO);
        }
    }

    public Date getBegin() {
        return this.begin;
    }

    public Long getBeginId() {
        return this.beginId;
    }

    public BigDecimal getBeginBalance() {
        return this.beginBalance;
    }

    public Date getEnd() {
        return this.end;
    }

    public Long getEndId() {
        return this.endId;
    }

    public BigDecimal getEndBalance() {
        return this.endBalance;
    }

    public BigDecimal getTradeAmount() {
        return this.tradeAmount;
    }

    public BigDecimal getChangeInAmount() {
        return this.changeInAmount;
    }

    public BigDecimal getChangeOutAmount() {
        return this.changeOutAmount;
    }
}

