/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.dto.entity;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.yunxi.dg.base.center.report.dto.entity.StepConsumeDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.function.Supplier;

@ApiModel(value="OrderSkuCostAsyncResultDto", description="OrderSkuCostAsyncResultDto")
public class OrderSkuCostAsyncResultDto
implements Serializable {
    @JsonIgnore
    private transient ICacheService cacheService;
    @ApiModelProperty(value="\u4efb\u52a1ID")
    private String taskId;
    @ApiModelProperty(value="\u4efb\u52a1\u72b6\u6001\uff1ainit-\u521d\u59cb\u5316\uff0crunning-\u6267\u884c\u4e2d\uff0csuccess-\u6267\u884c\u6210\u529f\uff0cfailure-\u6267\u884c\u5931\u8d25")
    private String status;
    @ApiModelProperty(value="\u9519\u8bef\u4fe1\u606f")
    private String msg;
    @ApiModelProperty(value="\u4efb\u52a1\u5f00\u59cb\u65f6\u95f4")
    private Date startTime;
    @ApiModelProperty(value="\u4efb\u52a1\u7ed3\u675f\u65f6\u95f4")
    private Date endTime;
    @ApiModelProperty(value="\u603b\u4efb\u52a1\u8017\u65f6\uff0c\u79d2")
    private Long consumeSeconds;
    @ApiModelProperty(value="\u6bcf\u4e2a\u6b65\u9aa4\u6267\u884c\u8017\u65f6")
    private List<StepConsumeDto> stepConsumes;

    public String getCacheKey() {
        return OrderSkuCostAsyncResultDto.getCacheKey(this.taskId);
    }

    public static String getCacheKey(String taskId) {
        return "OrderSkuCostAsyncResultDto:" + taskId;
    }

    public OrderSkuCostAsyncResultDto cache() {
        this.cacheService.setCache(this.getCacheKey(), (Object)this, 86400);
        return this;
    }

    public void runStep(String stepName, Runnable runnable) {
        this.runStep(stepName, () -> {
            runnable.run();
            return 0;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runStep(String stepName, Supplier<T> runnable) {
        StepConsumeDto step = this.startStep(stepName);
        try {
            T t = runnable.get();
            return t;
        }
        finally {
            step.finish();
        }
    }

    public StepConsumeDto startStep(String stepName) {
        StepConsumeDto consume = StepConsumeDto.newStep(stepName);
        this.stepConsumes.add(consume);
        this.cache();
        return consume;
    }

    public void finish() {
        this.setConsumeSeconds(OrderSkuCostAsyncResultDto.calcConsumeSeconds(this.startTime, this.endTime));
        StepConsumeDto.calcPercent(this.consumeSeconds, this.stepConsumes);
        this.cache();
    }

    private static long calcConsumeSeconds(Date startTime, Date endTime) {
        if (startTime == null || endTime == null) {
            return 0L;
        }
        return (endTime.getTime() - startTime.getTime()) / 1000L;
    }

    public static OrderSkuCostAsyncResultDtoBuilder builder() {
        return new OrderSkuCostAsyncResultDtoBuilder();
    }

    @JsonIgnore
    public void setCacheService(ICacheService cacheService) {
        this.cacheService = cacheService;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setConsumeSeconds(Long consumeSeconds) {
        this.consumeSeconds = consumeSeconds;
    }

    public void setStepConsumes(List<StepConsumeDto> stepConsumes) {
        this.stepConsumes = stepConsumes;
    }

    public ICacheService getCacheService() {
        return this.cacheService;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getStatus() {
        return this.status;
    }

    public String getMsg() {
        return this.msg;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Long getConsumeSeconds() {
        return this.consumeSeconds;
    }

    public List<StepConsumeDto> getStepConsumes() {
        return this.stepConsumes;
    }

    public OrderSkuCostAsyncResultDto() {
    }

    public OrderSkuCostAsyncResultDto(ICacheService cacheService, String taskId, String status, String msg, Date startTime, Date endTime, Long consumeSeconds, List<StepConsumeDto> stepConsumes) {
        this.cacheService = cacheService;
        this.taskId = taskId;
        this.status = status;
        this.msg = msg;
        this.startTime = startTime;
        this.endTime = endTime;
        this.consumeSeconds = consumeSeconds;
        this.stepConsumes = stepConsumes;
    }

    public static class OrderSkuCostAsyncResultDtoBuilder {
        private ICacheService cacheService;
        private String taskId;
        private String status;
        private String msg;
        private Date startTime;
        private Date endTime;
        private Long consumeSeconds;
        private List<StepConsumeDto> stepConsumes;

        OrderSkuCostAsyncResultDtoBuilder() {
        }

        @JsonIgnore
        public OrderSkuCostAsyncResultDtoBuilder cacheService(ICacheService cacheService) {
            this.cacheService = cacheService;
            return this;
        }

        public OrderSkuCostAsyncResultDtoBuilder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public OrderSkuCostAsyncResultDtoBuilder status(String status) {
            this.status = status;
            return this;
        }

        public OrderSkuCostAsyncResultDtoBuilder msg(String msg) {
            this.msg = msg;
            return this;
        }

        public OrderSkuCostAsyncResultDtoBuilder startTime(Date startTime) {
            this.startTime = startTime;
            return this;
        }

        public OrderSkuCostAsyncResultDtoBuilder endTime(Date endTime) {
            this.endTime = endTime;
            return this;
        }

        public OrderSkuCostAsyncResultDtoBuilder consumeSeconds(Long consumeSeconds) {
            this.consumeSeconds = consumeSeconds;
            return this;
        }

        public OrderSkuCostAsyncResultDtoBuilder stepConsumes(List<StepConsumeDto> stepConsumes) {
            this.stepConsumes = stepConsumes;
            return this;
        }

        public OrderSkuCostAsyncResultDto build() {
            return new OrderSkuCostAsyncResultDto(this.cacheService, this.taskId, this.status, this.msg, this.startTime, this.endTime, this.consumeSeconds, this.stepConsumes);
        }

        public String toString() {
            return "OrderSkuCostAsyncResultDto.OrderSkuCostAsyncResultDtoBuilder(cacheService=" + this.cacheService + ", taskId=" + this.taskId + ", status=" + this.status + ", msg=" + this.msg + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", consumeSeconds=" + this.consumeSeconds + ", stepConsumes=" + this.stepConsumes + ")";
        }
    }
}

