/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.dto.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;

@ApiModel(value="ReportSyncReqDto", description="\u62a5\u8868\u540c\u6b65\u5bf9\u8c61")
public class ReportSyncReqDto {
    private static final Logger log = LoggerFactory.getLogger(ReportSyncReqDto.class);
    @ApiModelProperty(value="\u66f4\u65b0\u65f6\u95f4 - \u5f00\u59cb\uff0c\u4e3a\u7a7a\u65f6\u53d6\u6700\u65e7\u7684\u65f6\u95f4")
    private LocalDateTime startTime;
    @ApiModelProperty(value="\u66f4\u65b0\u65f6\u95f4 - \u7ed3\u675f\uff0c\u4e3a\u7a7a\u65f6\u53d6\u6700\u65b0\u7684\u65f6\u95f4")
    private LocalDateTime endTime;
    @ApiModelProperty(value="\u6b65\u957f\uff0c\u5355\u4f4d\uff1a\u5929/\u6708")
    private Integer step = 1;

    public void paramsCheck(Supplier<LocalDateTime> minStartTime) {
        if (this.startTime == null) {
            this.startTime = minStartTime.get();
        }
        if (this.endTime == null) {
            this.endTime = LocalDateTime.now();
        }
        if (this.step == null) {
            this.step = 1;
        }
    }

    public void syncByStep(String reportName, BiConsumer<LocalDateTime, LocalDateTime> syncStep) {
        LocalDateTime stepEndTime;
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        log.info("{}\u540c\u6b65: \u5f00\u59cb\u540c\u6b65\uff1a{} - {}", new Object[]{reportName, this.startTime.format(formatter), this.endTime.format(formatter)});
        StopWatch sw = new StopWatch();
        sw.start();
        LocalDateTime stepStartTime = this.startTime;
        do {
            stepEndTime = (stepEndTime = stepStartTime.withHour(0).withMinute(0).withSecond(0).withNano(0).plusDays(this.step.intValue())).isBefore(this.endTime) ? stepEndTime : this.endTime;
            log.info("{}\u540c\u6b65: \u6309\u6b65\u957f {} \u5929\u540c\u6b65\u5f00\u59cb\uff1a{} - {}", new Object[]{reportName, this.step, stepStartTime.format(formatter), stepEndTime.format(formatter)});
            syncStep.accept(stepStartTime, stepEndTime);
            log.info("{}\u540c\u6b65: \u6309\u6b65\u957f {} \u5929\u540c\u6b65\u5b8c\u6210\uff1a{} - {}", new Object[]{reportName, this.step, stepStartTime.format(formatter), stepEndTime.format(formatter)});
        } while ((stepStartTime = stepEndTime).isBefore(this.endTime));
        sw.stop();
        log.info("{}\u540c\u6b65: \u540c\u6b65\u5b8c\u6210\uff1a{} - {}\uff0c\u8017\u65f6 {} \u6beb\u79d2", new Object[]{reportName, this.startTime.format(formatter), this.endTime.format(formatter), sw.getLastTaskTimeMillis()});
    }

    public void syncByMonth(String reportName, BiConsumer<LocalDateTime, LocalDateTime> syncStep) {
        LocalDateTime stepEndTime;
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        log.info("{}\u540c\u6b65: \u5f00\u59cb\u540c\u6b65\uff1a{} - {}", new Object[]{reportName, this.startTime.format(formatter), this.endTime.format(formatter)});
        StopWatch sw = new StopWatch();
        sw.start();
        LocalDateTime stepStartTime = this.startTime;
        do {
            stepEndTime = (stepEndTime = stepStartTime.plusMonths(this.step.intValue())).isBefore(this.endTime) ? stepEndTime : this.endTime;
            log.info("{}\u540c\u6b65: {} - {}", new Object[]{reportName, stepStartTime.format(formatter), stepEndTime.format(formatter)});
            syncStep.accept(stepStartTime, stepEndTime);
            log.info("{}\u540c\u6b65: {} - {}", new Object[]{reportName, stepStartTime.format(formatter), stepEndTime.format(formatter)});
        } while ((stepStartTime = stepEndTime).isBefore(this.endTime));
        sw.stop();
        log.info("{}\u540c\u6b65: \u540c\u6b65\u5b8c\u6210\uff1a{} - {}\uff0c\u8017\u65f6 {} \u6beb\u79d2", new Object[]{reportName, this.startTime.format(formatter), this.endTime.format(formatter), sw.getLastTaskTimeMillis()});
    }

    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime;
    }

    public void setStep(Integer step) {
        this.step = step;
    }

    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    public LocalDateTime getEndTime() {
        return this.endTime;
    }

    public Integer getStep() {
        return this.step;
    }

    public ReportSyncReqDto() {
    }

    public ReportSyncReqDto(LocalDateTime startTime, LocalDateTime endTime, Integer step) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.step = step;
    }
}

