/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.dto.entity;

import com.dtyunxi.cube.commons.exceptions.BizException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class StepConsumeDto {
    @ApiModelProperty(value="\u6b65\u9aa4\u540d\u79f0")
    private String stepName;
    @ApiModelProperty(value="\u6b65\u9aa4\u5f00\u59cb\u65f6\u95f4")
    private Date startTime;
    @ApiModelProperty(value="\u6b65\u9aa4\u7ed3\u675f\u65f6\u95f4")
    private Date endTime;
    @ApiModelProperty(value="\u6b65\u9aa4\u8017\u65f6\uff0c\u79d2")
    private Long consumeSeconds;
    @ApiModelProperty(value="\u8017\u65f6\u5360\u6bd4")
    private Double percent;
    private List<StepConsumeDto> children;

    public static StepConsumeDto newStep(String stepName) {
        return StepConsumeDto.builder().stepName(stepName).startTime(new Date()).children(new ArrayList<StepConsumeDto>()).build();
    }

    public void finish() {
        if (this.getEndTime() != null) {
            throw new BizException("\u6b65\u9aa4 " + this.getStepName() + "\u5df2\u7ed3\u675f");
        }
        this.endTime = new Date();
        this.consumeSeconds = StepConsumeDto.calcConsumeSeconds(this.getStartTime(), this.getEndTime());
        StepConsumeDto.calcPercent(this.consumeSeconds, this.children);
    }

    private static long calcConsumeSeconds(Date startTime, Date endTime) {
        if (startTime == null || endTime == null) {
            return 0L;
        }
        return (endTime.getTime() - startTime.getTime()) / 1000L;
    }

    public static void calcPercent(Long totalSeconds, List<StepConsumeDto> children) {
        if (totalSeconds == null || totalSeconds == 0L) {
            return;
        }
        for (StepConsumeDto child : children) {
            if (child.consumeSeconds == null) continue;
            child.percent = (double)child.consumeSeconds.longValue() / (double)totalSeconds.longValue();
        }
    }

    public StepConsumeDto newChildStep(String stepName) {
        StepConsumeDto step = StepConsumeDto.newStep(this.stepName + "-" + stepName);
        this.getChildren().add(step);
        return step;
    }

    public static StepConsumeDtoBuilder builder() {
        return new StepConsumeDtoBuilder();
    }

    public String getStepName() {
        return this.stepName;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Long getConsumeSeconds() {
        return this.consumeSeconds;
    }

    public Double getPercent() {
        return this.percent;
    }

    public List<StepConsumeDto> getChildren() {
        return this.children;
    }

    public void setStepName(String stepName) {
        this.stepName = stepName;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setConsumeSeconds(Long consumeSeconds) {
        this.consumeSeconds = consumeSeconds;
    }

    public void setPercent(Double percent) {
        this.percent = percent;
    }

    public void setChildren(List<StepConsumeDto> children) {
        this.children = children;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StepConsumeDto)) {
            return false;
        }
        StepConsumeDto other = (StepConsumeDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$consumeSeconds = this.getConsumeSeconds();
        Long other$consumeSeconds = other.getConsumeSeconds();
        if (this$consumeSeconds == null ? other$consumeSeconds != null : !((Object)this$consumeSeconds).equals(other$consumeSeconds)) {
            return false;
        }
        Double this$percent = this.getPercent();
        Double other$percent = other.getPercent();
        if (this$percent == null ? other$percent != null : !((Object)this$percent).equals(other$percent)) {
            return false;
        }
        String this$stepName = this.getStepName();
        String other$stepName = other.getStepName();
        if (this$stepName == null ? other$stepName != null : !this$stepName.equals(other$stepName)) {
            return false;
        }
        Date this$startTime = this.getStartTime();
        Date other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        List<StepConsumeDto> this$children = this.getChildren();
        List<StepConsumeDto> other$children = other.getChildren();
        return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StepConsumeDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $consumeSeconds = this.getConsumeSeconds();
        result = result * 59 + ($consumeSeconds == null ? 43 : ((Object)$consumeSeconds).hashCode());
        Double $percent = this.getPercent();
        result = result * 59 + ($percent == null ? 43 : ((Object)$percent).hashCode());
        String $stepName = this.getStepName();
        result = result * 59 + ($stepName == null ? 43 : $stepName.hashCode());
        Date $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        List<StepConsumeDto> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        return result;
    }

    public String toString() {
        return "StepConsumeDto(stepName=" + this.getStepName() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", consumeSeconds=" + this.getConsumeSeconds() + ", percent=" + this.getPercent() + ", children=" + this.getChildren() + ")";
    }

    public StepConsumeDto() {
    }

    public StepConsumeDto(String stepName, Date startTime, Date endTime, Long consumeSeconds, Double percent, List<StepConsumeDto> children) {
        this.stepName = stepName;
        this.startTime = startTime;
        this.endTime = endTime;
        this.consumeSeconds = consumeSeconds;
        this.percent = percent;
        this.children = children;
    }

    public static class StepConsumeDtoBuilder {
        private String stepName;
        private Date startTime;
        private Date endTime;
        private Long consumeSeconds;
        private Double percent;
        private List<StepConsumeDto> children;

        StepConsumeDtoBuilder() {
        }

        public StepConsumeDtoBuilder stepName(String stepName) {
            this.stepName = stepName;
            return this;
        }

        public StepConsumeDtoBuilder startTime(Date startTime) {
            this.startTime = startTime;
            return this;
        }

        public StepConsumeDtoBuilder endTime(Date endTime) {
            this.endTime = endTime;
            return this;
        }

        public StepConsumeDtoBuilder consumeSeconds(Long consumeSeconds) {
            this.consumeSeconds = consumeSeconds;
            return this;
        }

        public StepConsumeDtoBuilder percent(Double percent) {
            this.percent = percent;
            return this;
        }

        public StepConsumeDtoBuilder children(List<StepConsumeDto> children) {
            this.children = children;
            return this;
        }

        public StepConsumeDto build() {
            return new StepConsumeDto(this.stepName, this.startTime, this.endTime, this.consumeSeconds, this.percent, this.children);
        }

        public String toString() {
            return "StepConsumeDto.StepConsumeDtoBuilder(stepName=" + this.stepName + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", consumeSeconds=" + this.consumeSeconds + ", percent=" + this.percent + ", children=" + this.children + ")";
        }
    }
}

