/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.constants;

import com.yunxi.dg.base.center.report.enums.DgLogicWarehouseQualityEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public enum ErpInventoryTypeEnum {
    CC("CC", "\u6b8b\u54c1", DgLogicWarehouseQualityEnum.UN_QUALIFIED),
    ZP("ZP", "\u53ef\u7528", DgLogicWarehouseQualityEnum.QUALIFIED),
    QC("QC", "\u5f85\u68c0", DgLogicWarehouseQualityEnum.WAIT_INSPECTION),
    DJ("DJ", "\u51bb\u7ed3", DgLogicWarehouseQualityEnum.FREEZE),
    KCZT01_SYS("KCZT01_SYS", "\u53ef\u7528", DgLogicWarehouseQualityEnum.QUALIFIED),
    KCZT05_SYS("KCZT05_SYS", "\u5728\u9014", null),
    KCZT002("KCZT002", "\u53ef\u7528", DgLogicWarehouseQualityEnum.QUALIFIED),
    KCZT001("KCZT001", "\u53ef\u7528", DgLogicWarehouseQualityEnum.QUALIFIED);

    private String code;
    private String desc;
    private DgLogicWarehouseQualityEnum qualityEnum;
    public static final Map<String, ErpInventoryTypeEnum> CODE_LOOKUP;
    public static final Map<String, String> CODE_DESC_MAP;

    private ErpInventoryTypeEnum(String code, String desc, DgLogicWarehouseQualityEnum qualityEnum) {
        this.code = code;
        this.desc = desc;
        this.qualityEnum = qualityEnum;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static ErpInventoryTypeEnum forCode(String code) {
        return CODE_LOOKUP.get(code);
    }

    public static String getDesc(String index) {
        for (ErpInventoryTypeEnum inventoryTypeEnum : ErpInventoryTypeEnum.values()) {
            if (!inventoryTypeEnum.getCode().equals(index)) continue;
            return inventoryTypeEnum.getDesc();
        }
        return null;
    }

    public static String getCode(String index) {
        for (ErpInventoryTypeEnum inventoryTypeEnum : ErpInventoryTypeEnum.values()) {
            if (!inventoryTypeEnum.getDesc().equals(index)) continue;
            return inventoryTypeEnum.getCode();
        }
        return null;
    }

    public static ErpInventoryTypeEnum getByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return Arrays.asList(ErpInventoryTypeEnum.values()).stream().filter(eo -> code.equals(eo.getCode())).findAny().orElse(null);
    }

    public static List<String> getByInventoryProperties(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return new ArrayList<String>();
        }
        ArrayList<String> codes = new ArrayList<String>();
        for (ErpInventoryTypeEnum inventoryTypeEnum : ErpInventoryTypeEnum.values()) {
            if (inventoryTypeEnum.qualityEnum == null || !inventoryTypeEnum.qualityEnum.getCode().equals(code)) continue;
            codes.add(inventoryTypeEnum.code);
        }
        return codes;
    }

    static {
        CODE_LOOKUP = Arrays.stream(ErpInventoryTypeEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
        CODE_DESC_MAP = Arrays.stream(ErpInventoryTypeEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum.desc));
    }
}

