/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.constants;

import com.yunxi.dg.base.commons.enums.IBaseEnum;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum ShopWarehouseEnum implements IBaseEnum
{
    SHOP("shop", "\u5e97\u94fa\u4ed3"),
    AREA("area", "\u7701\u533a\u4ed3"),
    CUSTOMER("customer", "\u5ba2\u6237\u4ed3");

    private final String code;
    private final String name;
    private static final Map<String, ShopWarehouseEnum> ENUMS_MAP;

    private ShopWarehouseEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public ShopWarehouseEnum forEnum(String code) {
        return ENUMS_MAP.get(code);
    }

    public String forName(String code) {
        return this.forEnum(code).getName();
    }

    public static ShopWarehouseEnum fromCode(String code) {
        return ENUMS_MAP.get(code);
    }

    public static String getNameByCode(String code) {
        return ShopWarehouseEnum.fromCode(code).getName();
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    static {
        ENUMS_MAP = Arrays.stream(ShopWarehouseEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
    }
}

