/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.dto.entity;

import com.yunxi.dg.base.center.report.constants.CostAllocRuleAllocTypeEnum;
import com.yunxi.dg.base.center.report.constants.CostAllocRuleEffectiveScopeEnum;
import com.yunxi.dg.base.center.report.constants.CostAllocRuleStatusEnum;
import com.yunxi.dg.base.center.report.constants.CostAllocRuleTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CostAllocRuleDto
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(CostAllocRuleDto.class);
    private static final long serialVersionUID = -5652538033792847324L;
    @ApiModelProperty(value="\u8d39\u7528\u6863\u6848\u7f16\u7801")
    private String archiveCode;
    @ApiModelProperty(value="\u8d39\u7528\u6863\u6848\u540d\u79f0")
    private String archiveName;
    @ApiModelProperty(value="\u8d39\u7528\u5206\u7c7b\u7f16\u7801")
    private String categoryCode;
    @ApiModelProperty(value="\u8d39\u7528\u5206\u7c7b\u540d\u79f0")
    private String categoryName;
    @ApiModelProperty(value="\u89c4\u5219\u7c7b\u578b\uff0c1-\u5b9e\u9645\u8d39\u7528\u5206\u644a\u89c4\u5219\uff0c2-\u9884\u7b97\u8d39\u7528\u5206\u644a\u89c4\u5219")
    private Integer ruleType;
    @ApiModelProperty(value="\u89c4\u5219ID")
    private Long ruleId;
    @ApiModelProperty(value="\u89c4\u5219\u7f16\u7801")
    private String ruleCode;
    @ApiModelProperty(value="\u89c4\u5219\u540d\u79f0")
    private String ruleName;
    @ApiModelProperty(name="status", value="\u72b6\u6001\uff0c\u6570\u636e\u5b57\u5178\uff1agroupCode=yunxi-dg-base-center-report, code=cost_alloc_status")
    private String status;
    @ApiModelProperty(name="startTime", value="\u6267\u884c\u5f00\u59cb\u65f6\u95f4")
    private Date startTime;
    @ApiModelProperty(name="endTime", value="\u6267\u884c\u7ed3\u675f\u65f6\u95f4")
    private Date endTime;
    @ApiModelProperty(name="allocType", value="\u5206\u644a\u7c7b\u578b\uff0c\u6570\u636e\u5b57\u5178\uff1agroupCode=yunxi-dg-base-center-report, code=actual_cost_alloc_type")
    private String allocType;
    @ApiModelProperty(name="afterSaleDeductCost", value="\u8ba2\u5355\u4ea7\u751f\u552e\u540e\u5355\uff0c\u62b5\u5145\u8d39\u7528\uff0c0-\u4e0d\u52fe\u9009\uff0c1-\u52fe\u9009")
    private Integer afterSaleDeductCost;
    @ApiModelProperty(name="proportion", value="\u6bd4\u4f8b")
    private BigDecimal proportion;
    @ApiModelProperty(name="effectiveScope", value="\u5206\u644a\u89c4\u5219\u751f\u6548\u8303\u56f4\uff0c\u6570\u636e\u5b57\u5178\uff1agroupCode=yunxi-dg-base-center-report, code=cost_alloc_effective_scope")
    private String effectiveScope;
    @ApiModelProperty(value="\u5b9e\u9645\u8d39\u7528\u5206\u644a\u89c4\u5219\u6309\u56fa\u5b9a\u91d1\u989d\u5206\u644a")
    private Map<LocalDate, BigDecimal> actualFixedCostMap;
    @ApiModelProperty(value="\u751f\u6548\u8303\u56f4")
    private Set<String> effectiveScopeKeys;
    @ApiModelProperty(value="\u6309\u6bd4\u4f8b")
    private Map<String, BigDecimal> budgetProportionCostMap;
    @ApiModelProperty(value="\u6309\u56fa\u5b9a\u91d1\u989d")
    private Map<String, BigDecimal> budgetFixedCostMap;

    public boolean match(String shopCode, Date time) {
        if (!CostAllocRuleStatusEnum.RUNNING.getCode().equals(this.status) && !CostAllocRuleStatusEnum.END.getCode().equals(this.status)) {
            return false;
        }
        if (time == null) {
            return false;
        }
        if (time.before(this.startTime) || time.after(this.endTime)) {
            return false;
        }
        if (this.isActualRule()) {
            CostAllocRuleEffectiveScopeEnum scope = CostAllocRuleEffectiveScopeEnum.fromCode(this.effectiveScope);
            switch (scope) {
                case ALL: {
                    return true;
                }
                case APPOINT: {
                    return this.effectiveScopeKeys.contains(shopCode);
                }
                case EXCLUDE: {
                    return !this.effectiveScopeKeys.contains(shopCode);
                }
            }
        } else {
            CostAllocRuleAllocTypeEnum alloc = CostAllocRuleAllocTypeEnum.fromCode(this.ruleType, this.allocType);
            switch (alloc) {
                case BY_RATIO: {
                    return this.budgetProportionCostMap.containsKey(shopCode);
                }
                case BY_FIXED: {
                    return this.budgetFixedCostMap.containsKey(shopCode);
                }
            }
            return false;
        }
        return false;
    }

    public boolean isActualRule() {
        return CostAllocRuleTypeEnum.ACTUAL.getCode().equals(this.ruleType);
    }

    public String getArchiveCode() {
        return this.archiveCode;
    }

    public String getArchiveName() {
        return this.archiveName;
    }

    public String getCategoryCode() {
        return this.categoryCode;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public Integer getRuleType() {
        return this.ruleType;
    }

    public Long getRuleId() {
        return this.ruleId;
    }

    public String getRuleCode() {
        return this.ruleCode;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public String getStatus() {
        return this.status;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getAllocType() {
        return this.allocType;
    }

    public Integer getAfterSaleDeductCost() {
        return this.afterSaleDeductCost;
    }

    public BigDecimal getProportion() {
        return this.proportion;
    }

    public String getEffectiveScope() {
        return this.effectiveScope;
    }

    public Map<LocalDate, BigDecimal> getActualFixedCostMap() {
        return this.actualFixedCostMap;
    }

    public Set<String> getEffectiveScopeKeys() {
        return this.effectiveScopeKeys;
    }

    public Map<String, BigDecimal> getBudgetProportionCostMap() {
        return this.budgetProportionCostMap;
    }

    public Map<String, BigDecimal> getBudgetFixedCostMap() {
        return this.budgetFixedCostMap;
    }

    public void setArchiveCode(String archiveCode) {
        this.archiveCode = archiveCode;
    }

    public void setArchiveName(String archiveName) {
        this.archiveName = archiveName;
    }

    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public void setRuleType(Integer ruleType) {
        this.ruleType = ruleType;
    }

    public void setRuleId(Long ruleId) {
        this.ruleId = ruleId;
    }

    public void setRuleCode(String ruleCode) {
        this.ruleCode = ruleCode;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setAllocType(String allocType) {
        this.allocType = allocType;
    }

    public void setAfterSaleDeductCost(Integer afterSaleDeductCost) {
        this.afterSaleDeductCost = afterSaleDeductCost;
    }

    public void setProportion(BigDecimal proportion) {
        this.proportion = proportion;
    }

    public void setEffectiveScope(String effectiveScope) {
        this.effectiveScope = effectiveScope;
    }

    public void setActualFixedCostMap(Map<LocalDate, BigDecimal> actualFixedCostMap) {
        this.actualFixedCostMap = actualFixedCostMap;
    }

    public void setEffectiveScopeKeys(Set<String> effectiveScopeKeys) {
        this.effectiveScopeKeys = effectiveScopeKeys;
    }

    public void setBudgetProportionCostMap(Map<String, BigDecimal> budgetProportionCostMap) {
        this.budgetProportionCostMap = budgetProportionCostMap;
    }

    public void setBudgetFixedCostMap(Map<String, BigDecimal> budgetFixedCostMap) {
        this.budgetFixedCostMap = budgetFixedCostMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CostAllocRuleDto)) {
            return false;
        }
        CostAllocRuleDto other = (CostAllocRuleDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$ruleType = this.getRuleType();
        Integer other$ruleType = other.getRuleType();
        if (this$ruleType == null ? other$ruleType != null : !((Object)this$ruleType).equals(other$ruleType)) {
            return false;
        }
        Long this$ruleId = this.getRuleId();
        Long other$ruleId = other.getRuleId();
        if (this$ruleId == null ? other$ruleId != null : !((Object)this$ruleId).equals(other$ruleId)) {
            return false;
        }
        Integer this$afterSaleDeductCost = this.getAfterSaleDeductCost();
        Integer other$afterSaleDeductCost = other.getAfterSaleDeductCost();
        if (this$afterSaleDeductCost == null ? other$afterSaleDeductCost != null : !((Object)this$afterSaleDeductCost).equals(other$afterSaleDeductCost)) {
            return false;
        }
        String this$archiveCode = this.getArchiveCode();
        String other$archiveCode = other.getArchiveCode();
        if (this$archiveCode == null ? other$archiveCode != null : !this$archiveCode.equals(other$archiveCode)) {
            return false;
        }
        String this$archiveName = this.getArchiveName();
        String other$archiveName = other.getArchiveName();
        if (this$archiveName == null ? other$archiveName != null : !this$archiveName.equals(other$archiveName)) {
            return false;
        }
        String this$categoryCode = this.getCategoryCode();
        String other$categoryCode = other.getCategoryCode();
        if (this$categoryCode == null ? other$categoryCode != null : !this$categoryCode.equals(other$categoryCode)) {
            return false;
        }
        String this$categoryName = this.getCategoryName();
        String other$categoryName = other.getCategoryName();
        if (this$categoryName == null ? other$categoryName != null : !this$categoryName.equals(other$categoryName)) {
            return false;
        }
        String this$ruleCode = this.getRuleCode();
        String other$ruleCode = other.getRuleCode();
        if (this$ruleCode == null ? other$ruleCode != null : !this$ruleCode.equals(other$ruleCode)) {
            return false;
        }
        String this$ruleName = this.getRuleName();
        String other$ruleName = other.getRuleName();
        if (this$ruleName == null ? other$ruleName != null : !this$ruleName.equals(other$ruleName)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        Date this$startTime = this.getStartTime();
        Date other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        String this$allocType = this.getAllocType();
        String other$allocType = other.getAllocType();
        if (this$allocType == null ? other$allocType != null : !this$allocType.equals(other$allocType)) {
            return false;
        }
        BigDecimal this$proportion = this.getProportion();
        BigDecimal other$proportion = other.getProportion();
        if (this$proportion == null ? other$proportion != null : !((Object)this$proportion).equals(other$proportion)) {
            return false;
        }
        String this$effectiveScope = this.getEffectiveScope();
        String other$effectiveScope = other.getEffectiveScope();
        if (this$effectiveScope == null ? other$effectiveScope != null : !this$effectiveScope.equals(other$effectiveScope)) {
            return false;
        }
        Map<LocalDate, BigDecimal> this$actualFixedCostMap = this.getActualFixedCostMap();
        Map<LocalDate, BigDecimal> other$actualFixedCostMap = other.getActualFixedCostMap();
        if (this$actualFixedCostMap == null ? other$actualFixedCostMap != null : !((Object)this$actualFixedCostMap).equals(other$actualFixedCostMap)) {
            return false;
        }
        Set<String> this$effectiveScopeKeys = this.getEffectiveScopeKeys();
        Set<String> other$effectiveScopeKeys = other.getEffectiveScopeKeys();
        if (this$effectiveScopeKeys == null ? other$effectiveScopeKeys != null : !((Object)this$effectiveScopeKeys).equals(other$effectiveScopeKeys)) {
            return false;
        }
        Map<String, BigDecimal> this$budgetProportionCostMap = this.getBudgetProportionCostMap();
        Map<String, BigDecimal> other$budgetProportionCostMap = other.getBudgetProportionCostMap();
        if (this$budgetProportionCostMap == null ? other$budgetProportionCostMap != null : !((Object)this$budgetProportionCostMap).equals(other$budgetProportionCostMap)) {
            return false;
        }
        Map<String, BigDecimal> this$budgetFixedCostMap = this.getBudgetFixedCostMap();
        Map<String, BigDecimal> other$budgetFixedCostMap = other.getBudgetFixedCostMap();
        return !(this$budgetFixedCostMap == null ? other$budgetFixedCostMap != null : !((Object)this$budgetFixedCostMap).equals(other$budgetFixedCostMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CostAllocRuleDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $ruleType = this.getRuleType();
        result = result * 59 + ($ruleType == null ? 43 : ((Object)$ruleType).hashCode());
        Long $ruleId = this.getRuleId();
        result = result * 59 + ($ruleId == null ? 43 : ((Object)$ruleId).hashCode());
        Integer $afterSaleDeductCost = this.getAfterSaleDeductCost();
        result = result * 59 + ($afterSaleDeductCost == null ? 43 : ((Object)$afterSaleDeductCost).hashCode());
        String $archiveCode = this.getArchiveCode();
        result = result * 59 + ($archiveCode == null ? 43 : $archiveCode.hashCode());
        String $archiveName = this.getArchiveName();
        result = result * 59 + ($archiveName == null ? 43 : $archiveName.hashCode());
        String $categoryCode = this.getCategoryCode();
        result = result * 59 + ($categoryCode == null ? 43 : $categoryCode.hashCode());
        String $categoryName = this.getCategoryName();
        result = result * 59 + ($categoryName == null ? 43 : $categoryName.hashCode());
        String $ruleCode = this.getRuleCode();
        result = result * 59 + ($ruleCode == null ? 43 : $ruleCode.hashCode());
        String $ruleName = this.getRuleName();
        result = result * 59 + ($ruleName == null ? 43 : $ruleName.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        Date $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        String $allocType = this.getAllocType();
        result = result * 59 + ($allocType == null ? 43 : $allocType.hashCode());
        BigDecimal $proportion = this.getProportion();
        result = result * 59 + ($proportion == null ? 43 : ((Object)$proportion).hashCode());
        String $effectiveScope = this.getEffectiveScope();
        result = result * 59 + ($effectiveScope == null ? 43 : $effectiveScope.hashCode());
        Map<LocalDate, BigDecimal> $actualFixedCostMap = this.getActualFixedCostMap();
        result = result * 59 + ($actualFixedCostMap == null ? 43 : ((Object)$actualFixedCostMap).hashCode());
        Set<String> $effectiveScopeKeys = this.getEffectiveScopeKeys();
        result = result * 59 + ($effectiveScopeKeys == null ? 43 : ((Object)$effectiveScopeKeys).hashCode());
        Map<String, BigDecimal> $budgetProportionCostMap = this.getBudgetProportionCostMap();
        result = result * 59 + ($budgetProportionCostMap == null ? 43 : ((Object)$budgetProportionCostMap).hashCode());
        Map<String, BigDecimal> $budgetFixedCostMap = this.getBudgetFixedCostMap();
        result = result * 59 + ($budgetFixedCostMap == null ? 43 : ((Object)$budgetFixedCostMap).hashCode());
        return result;
    }

    public String toString() {
        return "CostAllocRuleDto(archiveCode=" + this.getArchiveCode() + ", archiveName=" + this.getArchiveName() + ", categoryCode=" + this.getCategoryCode() + ", categoryName=" + this.getCategoryName() + ", ruleType=" + this.getRuleType() + ", ruleId=" + this.getRuleId() + ", ruleCode=" + this.getRuleCode() + ", ruleName=" + this.getRuleName() + ", status=" + this.getStatus() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", allocType=" + this.getAllocType() + ", afterSaleDeductCost=" + this.getAfterSaleDeductCost() + ", proportion=" + this.getProportion() + ", effectiveScope=" + this.getEffectiveScope() + ", actualFixedCostMap=" + this.getActualFixedCostMap() + ", effectiveScopeKeys=" + this.getEffectiveScopeKeys() + ", budgetProportionCostMap=" + this.getBudgetProportionCostMap() + ", budgetFixedCostMap=" + this.getBudgetFixedCostMap() + ")";
    }
}

