/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.constants;

import com.yunxi.dg.base.center.report.constants.CostStatisticalFormatter;
import com.yunxi.dg.base.center.report.function.CostDoSync;
import com.yunxi.dg.base.center.report.function.CostDoSyncAndReturn;
import com.yunxi.dg.base.commons.enums.IBaseEnum;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum CostStatisticalTypeEnum implements IBaseEnum
{
    DATE(null, "date", "\u6309\u5929", CostStatisticalFormatter.DAY_FORMATTER, date -> {
        LocalDate d = LocalDate.parse(date.toString(), CostStatisticalFormatter.DAY_FORMATTER);
        return new DateRange(d, d);
    }, date -> date.plusDays(-1L), date -> date.plusYears(-1L)),
    MONTH(DATE, "month", "\u6309\u6708", CostStatisticalFormatter.MONTH_FORMATTER, month -> {
        LocalDate startDate = LocalDate.parse(month + "01", CostStatisticalTypeEnum.DATE.formatter);
        LocalDate endDate = startDate.plusMonths(1L).plusDays(-1L);
        return new DateRange(startDate, endDate);
    }, date -> {
        LocalDate monthEndDate = LocalDate.of(date.getYear(), date.getMonth(), 1).plusMonths(1L).plusDays(-1L);
        return !monthEndDate.equals(date) ? date.plusMonths(-1L) : LocalDate.of(date.getYear(), date.getMonth(), 1).plusDays(-1L);
    }, date -> {
        LocalDate monthEndDate = LocalDate.of(date.getYear(), date.getMonth(), 1).plusMonths(1L).plusDays(-1L);
        return !monthEndDate.equals(date) ? date.plusYears(-1L) : LocalDate.of(date.getYear() - 1, date.getMonth(), 1).plusMonths(1L).plusDays(-1L);
    }),
    QUARTER(MONTH, "quarter", "\u6309\u5b63\u5ea6", CostStatisticalFormatter.QUARTER_FORMATTER, quarter -> {
        int year = Integer.parseInt(quarter.toString().substring(0, 4));
        int month = (Integer.parseInt(quarter.toString().substring(4)) - 1) * 3 + 1;
        LocalDate startDate = LocalDate.of(year, month, 1);
        LocalDate endDate = startDate.plusMonths(3L).plusDays(-1L);
        return new DateRange(startDate, endDate);
    }, date -> {
        int quarter = Integer.parseInt(date.format(DateTimeFormatter.ofPattern("q")));
        int month = (quarter - 1) * 3 + 1;
        LocalDate quarterEndDate = LocalDate.of(date.getYear(), month, 1).plusMonths(3L).plusDays(-1L);
        if (!quarterEndDate.equals(date)) {
            return date.plusMonths(-3L);
        }
        return LocalDate.of(date.getYear(), date.getMonth(), 1).plusMonths(-2L).plusDays(-1L);
    }, date -> {
        int quarter = Integer.parseInt(date.format(DateTimeFormatter.ofPattern("q")));
        int month = (quarter - 1) * 3 + 1;
        LocalDate quarterEndDate = LocalDate.of(date.getYear(), month, 1).plusMonths(3L).plusDays(-1L);
        if (!quarterEndDate.equals(date)) {
            return date.plusYears(-1L);
        }
        return LocalDate.of(date.getYear(), date.getMonth(), 1).plusYears(-1L).plusMonths(1L).plusDays(-1L);
    }),
    YEAR(QUARTER, "year", "\u6309\u5e74", CostStatisticalFormatter.YEAR_FORMATTER, year -> {
        LocalDate startDate = LocalDate.parse(year + "0101", CostStatisticalTypeEnum.DATE.formatter);
        LocalDate endDate = startDate.plusYears(1L).plusDays(-1L);
        return new DateRange(startDate, endDate);
    }, date -> date.plusYears(-1L), null);

    private static final Logger log;
    private final CostStatisticalTypeEnum prev;
    private final String code;
    private final String name;
    private final DateTimeFormatter formatter;
    private final Function<Integer, DateRange> dateRangeMapper;
    private final Function<LocalDate, LocalDate> momMapper;
    private final Function<LocalDate, LocalDate> yoyMapper;
    private static final Map<String, CostStatisticalTypeEnum> ENUMS_MAP;

    public CostStatisticalTypeEnum forEnum(String code) {
        return ENUMS_MAP.get(code);
    }

    public String forName(String code) {
        return this.forEnum(code).getName();
    }

    public static CostStatisticalTypeEnum fromCode(String code) {
        return ENUMS_MAP.get(code);
    }

    public static String getNameByCode(String code) {
        return CostStatisticalTypeEnum.fromCode(code).getName();
    }

    public List<SplitRange> splitRange(LocalDate startDate, LocalDate endDate) {
        ArrayList<SplitRange> list = new ArrayList<SplitRange>();
        DateRange range1 = this.dateRangeMapper.apply(this.format(startDate));
        DateRange range2 = this.dateRangeMapper.apply(this.format(endDate));
        if (startDate.equals(range1.getStartDate()) && endDate.equals(range2.getEndDate())) {
            list.add(new SplitRange(this, startDate, endDate));
            return list;
        }
        if (this.prev == null) {
            return list;
        }
        if (!this.prev.equals((Object)DATE)) {
            DateRange range3 = this.prev.dateRangeMapper.apply(this.prev.format(endDate));
            list.add(new SplitRange(this.prev, startDate, range3.getStartDate().plusDays(-1L)));
            list.addAll(this.prev.splitRange(range3.getStartDate(), endDate));
        } else {
            list.add(new SplitRange(this.prev, startDate, endDate));
        }
        return list;
    }

    public Integer format(LocalDate date) {
        return Integer.parseInt(date.format(this.getFormatter()));
    }

    public void doSync(String reportName, List<LocalDate> dates, CostDoSync ds) {
        this.doSyncAndReturn(reportName, dates, (type, currentDate, startDate, endDate) -> {
            ds.doSync(type, currentDate, startDate, endDate);
            return 0;
        });
    }

    public <T> List<T> doSyncAndReturn(String reportName, List<LocalDate> dates, CostDoSyncAndReturn<T> ds) {
        List currentDates = dates.stream().map(date -> Integer.parseInt(date.format(this.formatter))).distinct().sorted().collect(Collectors.toList());
        return currentDates.stream().map(currentDate -> {
            DateRange range = this.dateRangeMapper.apply((Integer)currentDate);
            Integer startDate = this.prev.format(range.getStartDate());
            Integer endDate = this.prev.format(range.getEndDate());
            try {
                log.info("{} \u540c\u6b65 {} \u5f00\u59cb: {}={}, startDate={}, endDate={}", new Object[]{this.name, reportName, this.code, currentDate, startDate, endDate});
                Object result = ds.doSync(this, (Integer)currentDate, startDate, endDate);
                log.info("{} \u540c\u6b65 {} \u5b8c\u6210: {}={}, startDate={}, endDate={}", new Object[]{this.name, reportName, this.code, currentDate, startDate, endDate});
                return result;
            }
            catch (Exception e) {
                log.error("{} \u540c\u6b65 {} \u5931\u8d25: {}={}, startDate={}, endDate={}", new Object[]{this.name, reportName, this.code, currentDate, startDate, endDate, e});
                return null;
            }
        }).collect(Collectors.toList());
    }

    private CostStatisticalTypeEnum(CostStatisticalTypeEnum prev, String code, String name, DateTimeFormatter formatter, Function<Integer, DateRange> dateRangeMapper, Function<LocalDate, LocalDate> momMapper, Function<LocalDate, LocalDate> yoyMapper) {
        this.prev = prev;
        this.code = code;
        this.name = name;
        this.formatter = formatter;
        this.dateRangeMapper = dateRangeMapper;
        this.momMapper = momMapper;
        this.yoyMapper = yoyMapper;
    }

    public CostStatisticalTypeEnum getPrev() {
        return this.prev;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public DateTimeFormatter getFormatter() {
        return this.formatter;
    }

    public Function<Integer, DateRange> getDateRangeMapper() {
        return this.dateRangeMapper;
    }

    public Function<LocalDate, LocalDate> getMomMapper() {
        return this.momMapper;
    }

    public Function<LocalDate, LocalDate> getYoyMapper() {
        return this.yoyMapper;
    }

    static {
        log = LoggerFactory.getLogger(CostStatisticalTypeEnum.class);
        ENUMS_MAP = Arrays.stream(CostStatisticalTypeEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
    }

    public static class SplitRange {
        protected final CostStatisticalTypeEnum type;
        protected final LocalDate startDate;
        protected final LocalDate endDate;

        public CostStatisticalTypeEnum getType() {
            return this.type;
        }

        public LocalDate getStartDate() {
            return this.startDate;
        }

        public LocalDate getEndDate() {
            return this.endDate;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SplitRange)) {
                return false;
            }
            SplitRange other = (SplitRange)o;
            if (!other.canEqual(this)) {
                return false;
            }
            CostStatisticalTypeEnum this$type = this.getType();
            CostStatisticalTypeEnum other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            LocalDate this$startDate = this.getStartDate();
            LocalDate other$startDate = other.getStartDate();
            if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
                return false;
            }
            LocalDate this$endDate = this.getEndDate();
            LocalDate other$endDate = other.getEndDate();
            return !(this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SplitRange;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CostStatisticalTypeEnum $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            LocalDate $startDate = this.getStartDate();
            result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
            LocalDate $endDate = this.getEndDate();
            result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
            return result;
        }

        public String toString() {
            return "CostStatisticalTypeEnum.SplitRange(type=" + (Object)((Object)this.getType()) + ", startDate=" + this.getStartDate() + ", endDate=" + this.getEndDate() + ")";
        }

        public SplitRange(CostStatisticalTypeEnum type, LocalDate startDate, LocalDate endDate) {
            this.type = type;
            this.startDate = startDate;
            this.endDate = endDate;
        }
    }

    public static class DateRange {
        protected final LocalDate startDate;
        protected final LocalDate endDate;

        public LocalDate getStartDate() {
            return this.startDate;
        }

        public LocalDate getEndDate() {
            return this.endDate;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DateRange)) {
                return false;
            }
            DateRange other = (DateRange)o;
            if (!other.canEqual(this)) {
                return false;
            }
            LocalDate this$startDate = this.getStartDate();
            LocalDate other$startDate = other.getStartDate();
            if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
                return false;
            }
            LocalDate this$endDate = this.getEndDate();
            LocalDate other$endDate = other.getEndDate();
            return !(this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DateRange;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LocalDate $startDate = this.getStartDate();
            result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
            LocalDate $endDate = this.getEndDate();
            result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
            return result;
        }

        public String toString() {
            return "CostStatisticalTypeEnum.DateRange(startDate=" + this.getStartDate() + ", endDate=" + this.getEndDate() + ")";
        }

        public DateRange(LocalDate startDate, LocalDate endDate) {
            this.startDate = startDate;
            this.endDate = endDate;
        }
    }
}

