/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.mqc;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.yunxi.dg.base.center.report.domain.reconciliation.IReconciliationDispositionDomain;
import com.yunxi.dg.base.center.report.dto.reconciliation.ThirdReconciliationMessageDto;
import com.yunxi.dg.base.center.report.eo.reconciliation.ReconciliationDispositionEo;
import com.yunxi.dg.base.center.report.service.reconciliation.IReportReconciliationDifferenceService;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="RECONCILIATION_DIFFERENCE_TAG")
public class ReconciliationDifferenceRecreateProcess
implements IMessageProcessor<String> {
    private static final Logger log = LoggerFactory.getLogger(ReconciliationDifferenceRecreateProcess.class);
    @Resource
    private IReconciliationDispositionDomain domain;
    @Resource
    private IReportReconciliationDifferenceService reportReconciliationDifferenceService;

    public MessageResponse process(String message) {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        log.info("ReconciliationDifferenceRecreateProcess mq\u76d1\u542c\u751f\u6210\u5e93\u5b58\u5355\u636e\u6d41\u6c34\u5bf9\u8d26\u4fe1\u606f\uff1a{}", (Object)message);
        try {
            if (StringUtils.isEmpty((CharSequence)message)) {
                log.info("\u751f\u6210\u5355\u636e\u5bf9\u8d26\u6570\u636e\u4e3a\u7a7a");
                return MessageResponse.SUCCESS;
            }
            JSONObject jsonObject = JSONObject.parseObject((String)message);
            ThirdReconciliationMessageDto thirdReconciliationMessageDto = (ThirdReconciliationMessageDto)jsonObject.toJavaObject(ThirdReconciliationMessageDto.class);
            ReconciliationDispositionEo dispositionEo = (ReconciliationDispositionEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.domain.filter().eq((Object)"reconciliation_object", (Object)thirdReconciliationMessageDto.getSource())).last(" limit 1")).one();
            if (dispositionEo == null) {
                log.info("[\u62c9\u53d6\u5e76\u4e0e\u4e09\u65b9\u5dee\u5f02\u5904\u7406]\uff0c\u89c4\u5219\u4e3a\u7a7a");
                return MessageResponse.SUCCESS;
            }
            this.reportReconciliationDifferenceService.pullAndExtract(dispositionEo.getId(), thirdReconciliationMessageDto.getReconciliationTime());
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u5e93\u5b58\u5355\u636e\u6d41\u6c34\u5bf9\u8d26error->{},{}", (Object)JSONUtil.toJsonStr((Object)message), (Object)e);
            return MessageResponse.ERROR;
        }
        return MessageResponse.SUCCESS;
    }
}

