/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.rest.share;

import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.api.share.IDgShopInventoryApi;
import com.yunxi.dg.base.center.report.constants.ShopWarehouseEnum;
import com.yunxi.dg.base.center.report.dto.share.DgShopInventoryDto;
import com.yunxi.dg.base.center.report.dto.share.DgShopInventoryPageReqDto;
import com.yunxi.dg.base.center.report.service.share.IDgShopInventoryService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import io.swagger.annotations.Api;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u57fa\u7ebf-\u62a5\u8868\u4e2d\u5fc3-\u5e97\u94fa\u5e93\u5b58\u8868\u670d\u52a1\u63a5\u53e3"})
public class DgShopInventoryController
implements IDgShopInventoryApi {
    @Resource
    private IDgShopInventoryService service;

    public RestResponse<PageInfo<DgShopInventoryDto>> page(@RequestBody DgShopInventoryPageReqDto dto) {
        AssertUtils.notEmpty((String)dto.getShopClassify(), (String)"\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (ShopWarehouseEnum.SHOP.getCode().equals(dto.getShopClassify())) {
            return new RestResponse((Object)this.service.queryPage(dto));
        }
        if (ShopWarehouseEnum.CUSTOMER.getCode().equals(dto.getShopClassify())) {
            return new RestResponse((Object)this.service.queryTotalPage(dto));
        }
        return new RestResponse((Object)new PageInfo());
    }

    public RestResponse<List<DgShopInventoryDto>> queryList(@RequestBody DgShopInventoryPageReqDto dto) {
        AssertUtils.notEmpty((String)dto.getShopClassify(), (String)"\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (ShopWarehouseEnum.SHOP.getCode().equals(dto.getShopClassify())) {
            return new RestResponse((Object)this.service.queryList(dto));
        }
        if (ShopWarehouseEnum.CUSTOMER.getCode().equals(dto.getShopClassify())) {
            return new RestResponse((Object)this.service.queryTotalList(dto));
        }
        return new RestResponse((Object)Lists.newArrayList());
    }
}

