/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.scheduler.job;

import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.yunxi.dg.base.center.report.dao.mapper.SaleCountReportMapper;
import com.yunxi.dg.base.center.report.domain.entity.impl.SaleCountReportDomainImpl;
import com.yunxi.dg.base.center.report.dto.constants.SaleBusinessTypeEnum;
import com.yunxi.dg.base.center.report.dto.report.SaleCountReportPageReqDto;
import com.yunxi.dg.base.center.report.eo.SaleCountReportEo;
import com.yunxi.dg.base.center.report.result.SaleCountReportResultDto;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="SalePlanQuantityStatisticsJob")
@Scope(value="prototype")
public class SalePlanQuantityStatisticsJob
extends SingleTupleScheduleEvent {
    private static final Logger logger = LoggerFactory.getLogger(SalePlanQuantityStatisticsJob.class);
    @Resource
    private SaleCountReportMapper saleCountReportMapper;
    @Resource
    private SaleCountReportDomainImpl saleCountReportDomainImpl;

    public void before(TaskMsg taskMsg) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        logger.info("\u5f00\u59cb\u9500\u552e\u6570\u636e\u7edf\u8ba1\u6570\u636e");
    }

    public boolean execute(TaskMsg taskMsg) {
        try {
            String currentTime = DateUtil.getCurrenDate();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Date parse = simpleDateFormat.parse(currentTime);
            Calendar cal = Calendar.getInstance();
            cal.setTime(parse);
            cal.add(5, -1);
            String startTime = simpleDateFormat.format(cal.getTime());
            SaleCountReportPageReqDto saleCountReportPageReqDto = new SaleCountReportPageReqDto();
            saleCountReportPageReqDto.setStartTime(startTime);
            saleCountReportPageReqDto.setEndTime(currentTime);
            ArrayList businessTypeList = Lists.newArrayList();
            for (SaleBusinessTypeEnum value : SaleBusinessTypeEnum.values()) {
                businessTypeList.add(value.getType());
            }
            saleCountReportPageReqDto.setBusinessTypeList((List)businessTypeList);
            List saleCountReportEos = this.saleCountReportMapper.querySaleCountByTime(saleCountReportPageReqDto);
            ArrayList<SaleCountReportEo> reportEos = new ArrayList<SaleCountReportEo>();
            for (SaleCountReportResultDto resultDto : saleCountReportEos) {
                SaleCountReportEo eo = new SaleCountReportEo();
                BeanUtils.copyProperties((Object)resultDto, (Object)eo);
                eo.setId(null);
                eo.setCargoCode(resultDto.getLongCode());
                eo.setPlanNum(resultDto.getQuantity());
                eo.setSalesOrganizationId(resultDto.getOrganizationId());
                eo.setSalesOrganization(resultDto.getOrganizationName());
                eo.setSalesOrganizationCode(resultDto.getOrganizationCode());
                eo.setCreateTime(resultDto.getCreateTime());
                reportEos.add(eo);
            }
            if (CollectionUtils.isNotEmpty((Collection)saleCountReportEos)) {
                this.saleCountReportDomainImpl.insertBatch(reportEos);
            }
        }
        catch (Exception e) {
            logger.error("--------LogException-------->:", (Object)e.getMessage());
            logger.error("\u9500\u552e\u6570\u636e\u7edf\u8ba1\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        return true;
    }

    public void after(TaskMsg taskMsg) {
        logger.info("\u7ed3\u675f\u9500\u552e\u6570\u636e\u7edf\u8ba1\u6570\u636e");
    }
}

