/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.scheduler.config;

import cn.hutool.core.collection.CollUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskAndBizCreateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.ITaskQueryApi;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.scheduler.TaskEnum;
import com.yunxi.dg.base.center.report.scheduler.service.ISchedulerService;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

@Component
public class SchedulerApplicationRunner
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(SchedulerApplicationRunner.class);
    @Autowired
    private ISchedulerService schedulerService;
    @Autowired
    private ITaskQueryApi taskQueryApiApi;
    @Autowired
    private ITaskApi taskApi;
    @Value(value="${scheduler.client.app_code:yunxi-dg-base-center-report}")
    private String appCode;
    private static final Long INSTANCEID = 1694195275012247553L;
    private static final Long TENANTID = 1L;

    public void run(ApplicationArguments args) throws Exception {
        try {
            this.schedulerService.initScheduler();
            this.task1();
            this.task2();
            this.initWithTaskEnums();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void task1() {
        TaskQueryReqDto taskQueryReqDto = new TaskQueryReqDto();
        taskQueryReqDto.setAppCode(this.appCode);
        taskQueryReqDto.setTaskName("shopSkuBestSellingProductAddTagTask");
        PageInfo taskQueryRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.taskQueryApiApi.queryByPage(JacksonUtil.toJson((Object)taskQueryReqDto), Integer.valueOf(1), Integer.valueOf(1)));
        if (taskQueryRespDtoPageInfo != null && CollUtil.isNotEmpty((Collection)taskQueryRespDtoPageInfo.getList())) {
            log.info("======\u5df2\u521b\u5efa\u8c03\u5ea6\u4efb\u52a1========");
            return;
        }
        TaskAndBizCreateReqDto dto = new TaskAndBizCreateReqDto();
        dto.setAppCode(this.appCode);
        dto.setBizCode("shopSkuBestSellingProductAddTagTask");
        dto.setBizName("\u65b0\u589e\u7545\u9500\u54c1\u6807\u7b7ejob\u4efb\u52a1");
        dto.setScheduleExpression("0 30 0 * * ?");
        dto.setShardType("SINGLE");
        dto.setTaskBatchId(null);
        dto.setTaskDesc("\u65b0\u589e\u7545\u9500\u54c1\u6807\u7b7ejob\u4efb\u52a1");
        dto.setTaskName("shopSkuBestSellingProductAddTagTask");
        dto.setInstanceId(INSTANCEID);
        dto.setTenantId(TENANTID);
        RestResponse addResult = this.taskApi.addWithBiz(dto);
        this.taskApi.enableById((Long)addResult.getData(), "{}");
    }

    private void task2() {
        TaskQueryReqDto taskQueryReqDto = new TaskQueryReqDto();
        taskQueryReqDto.setAppCode(this.appCode);
        taskQueryReqDto.setTaskName("skuSaleStatisticsTask");
        PageInfo taskQueryRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.taskQueryApiApi.queryByPage(JacksonUtil.toJson((Object)taskQueryReqDto), Integer.valueOf(1), Integer.valueOf(1)));
        if (taskQueryRespDtoPageInfo != null && CollUtil.isNotEmpty((Collection)taskQueryRespDtoPageInfo.getList())) {
            log.info("======\u5df2\u521b\u5efa\u8c03\u5ea6\u4efb\u52a1========");
            return;
        }
        TaskAndBizCreateReqDto dto = new TaskAndBizCreateReqDto();
        dto.setAppCode(this.appCode);
        dto.setBizCode("skuSaleStatisticsTask");
        dto.setBizName("sku\u9500\u91cf\u7edf\u8ba1\u4efb\u52a1");
        dto.setScheduleExpression("0 30 0 * * ?");
        dto.setShardType("SINGLE");
        dto.setTaskBatchId(null);
        dto.setTaskDesc("sku\u9500\u91cf\u7edf\u8ba1\u4efb\u52a1");
        dto.setTaskName("skuSaleStatisticsTask");
        dto.setInstanceId(INSTANCEID);
        dto.setTenantId(TENANTID);
        RestResponse addResult = this.taskApi.addWithBiz(dto);
        this.taskApi.enableById((Long)addResult.getData(), "{}");
    }

    private void initWithTaskEnums() {
        for (TaskEnum value : TaskEnum.values()) {
            try {
                TaskQueryReqDto taskQueryReqDto = new TaskQueryReqDto();
                taskQueryReqDto.setAppCode(this.appCode);
                taskQueryReqDto.setTaskName(value.getName());
                PageInfo taskQueryRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.taskQueryApiApi.queryByPage(JacksonUtil.toJson((Object)taskQueryReqDto), Integer.valueOf(1), Integer.valueOf(1)));
                if (taskQueryRespDtoPageInfo != null && CollUtil.isNotEmpty((Collection)taskQueryRespDtoPageInfo.getList())) {
                    log.info("======\u5df2\u521b\u5efa\u8c03\u5ea6\u4efb\u52a1{}========", (Object)value.getName());
                    continue;
                }
                TaskAndBizCreateReqDto dto = new TaskAndBizCreateReqDto();
                dto.setAppCode(this.appCode);
                dto.setBizCode(value.getCode());
                dto.setBizName(value.getName());
                dto.setScheduleExpression(value.getCron());
                dto.setShardType("SINGLE");
                dto.setTaskBatchId(null);
                dto.setTaskDesc(value.getName());
                dto.setTaskName(value.getName());
                dto.setInstanceId(Long.valueOf(1L));
                dto.setTenantId(Long.valueOf(1L));
                RestResponse addResult = this.taskApi.addWithBiz(dto);
                this.taskApi.enableById((Long)addResult.getData(), "{}");
            }
            catch (Exception e) {
                log.error("\u521b\u5efa\u8c03\u5ea6\u4efb\u52a1{}\u62a5\u9519", (Object)value.getName(), (Object)e);
            }
        }
    }
}

