/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.scheduler.task;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.AbstractSingleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.report.dao.vo.DgItemSkuRespVo;
import com.yunxi.dg.base.center.report.domain.entity.IDgShopDomain;
import com.yunxi.dg.base.center.report.domain.entity.IDictDomain;
import com.yunxi.dg.base.center.report.domain.item.IItemSkuDgDomain;
import com.yunxi.dg.base.center.report.domain.trade.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.report.dto.entity.BizTagRecordDto;
import com.yunxi.dg.base.center.report.dto.entity.DgOrderDetailReportDto;
import com.yunxi.dg.base.center.report.dto.entity.DgOrderDetailReportPageReqDto;
import com.yunxi.dg.base.center.report.dto.entity.DictDto;
import com.yunxi.dg.base.center.report.dto.item.ItemQueryDgReqDto;
import com.yunxi.dg.base.center.report.dto.tag.SearchTagRecordLinkDto;
import com.yunxi.dg.base.center.report.dto.tag.TagRecordLinkInfoDto;
import com.yunxi.dg.base.center.report.dto.tag.TagRecordLinkReqExtDto;
import com.yunxi.dg.base.center.report.service.entity.IBizTagRecordService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="shopSkuBestSellingProductAddTagTask")
@Scope(value="prototype")
public class ShopSkuBestSellingProductAddTagTask
extends AbstractSingleScheduleEvent {
    private static final Logger log = LoggerFactory.getLogger(ShopSkuBestSellingProductAddTagTask.class);
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;
    @Resource
    private IDgShopDomain shopDomain;
    @Resource
    private IItemSkuDgDomain itemSkuDgDomain;
    @Resource
    private IBizTagRecordService bizTagRecordService;
    @Resource
    private IDictDomain dictDomain;
    public static final Integer pageSize = 1000;

    public void before(TaskMsg taskMsg) {
        log.info("\u7545\u9500\u54c1\u6807\u7b7ejob\u4efb\u52a1\u5f00\u59cb");
    }

    public boolean execute(TaskMsg taskMsg) {
        log.info("\u5f00\u59cb\u7545\u9500\u54c1\u6807\u7b7e\u4efb\u52a1\u5f00\u59cb");
        try {
            List dictDtoList = this.dictDomain.queryDictByCodeAndGroupCode("yunxi-dg-base-center-item", "bestSellingProductTagDate");
            if (CollectionUtil.isEmpty((Collection)dictDtoList)) {
                log.info("\u7545\u9500\u54c1\u6807\u7b7e\u65e5\u671f\u5929\u6570\u6570\u636e\u5b57\u5178\u672a\u8bbe\u7f6e\u503c");
                return Boolean.TRUE;
            }
            List dictTopDtoList = this.dictDomain.queryDictByCodeAndGroupCode("yunxi-dg-base-center-item", "bestSellingProductTagTop");
            if (CollectionUtil.isEmpty((Collection)dictTopDtoList)) {
                log.info("\u7545\u9500\u54c1\u6807top\u6570\u7b7e\u6570\u636e\u5b57\u5178\u672a\u8bbe\u7f6e\u503c");
                return Boolean.TRUE;
            }
            String topNumber = ((DictDto)dictTopDtoList.get(0)).getDictValue();
            DgOrderDetailReportPageReqDto dto = new DgOrderDetailReportPageReqDto();
            dto.setOrderTypeList((List)Lists.newArrayList((Object[])new String[]{"standard_order", "change_delivery_order", "stock_reform_order", "overseas_order"}));
            String dictValue = ((DictDto)dictDtoList.get(0)).getDictValue();
            LocalDate deliveryStartTime = LocalDate.now().minusDays(Long.valueOf(dictValue));
            dto.setDeliveryStartTime(deliveryStartTime.toString());
            dto.setDeliveryEndTime(LocalDate.now() + " 23:59:59");
            List dgOrderDetailReportDtoList = this.dgPerformOrderInfoDomain.totalOrderItemLine(dto);
            List<BizTagRecordDto> bizTagRecordEoList = this.getBizTagRecord();
            TagRecordLinkInfoDto linkInfoDto = new TagRecordLinkInfoDto();
            if (CollectionUtil.isNotEmpty((Collection)dgOrderDetailReportDtoList)) {
                List detailReportDtoList = dgOrderDetailReportDtoList.stream().limit(Integer.valueOf(topNumber).intValue()).collect(Collectors.toList());
                HashSet skuCodeList = Sets.newHashSet();
                for (DgOrderDetailReportDto dgOrderDetailReportDto : detailReportDtoList) {
                    skuCodeList.add(dgOrderDetailReportDto.getSkuCode());
                }
                ItemQueryDgReqDto itemDgReqDto = new ItemQueryDgReqDto();
                itemDgReqDto.setSkuCodes((List)Lists.newArrayList((Iterable)skuCodeList));
                List dgItemSkuRespVos = this.itemSkuDgDomain.queryItemSkuList(itemDgReqDto);
                Map dgItemSkuRespVoMap = dgItemSkuRespVos.stream().collect(Collectors.toMap(DgItemSkuRespVo::getSkuCode, Function.identity(), (v1, v2) -> v1));
                Map listMap = detailReportDtoList.stream().collect(Collectors.groupingBy(DgOrderDetailReportDto::getSkuCode, Collectors.toList()));
                ArrayList<TagRecordLinkReqExtDto> batchAddTagRecordLink = new ArrayList<TagRecordLinkReqExtDto>();
                for (Map.Entry entry : listMap.entrySet()) {
                    if (!dgItemSkuRespVoMap.containsKey(entry.getKey())) continue;
                    DgItemSkuRespVo dgItemSkuRespVo = (DgItemSkuRespVo)dgItemSkuRespVoMap.get(entry.getKey());
                    for (DgOrderDetailReportDto dgOrderDetailReportDto : entry.getValue()) {
                        TagRecordLinkReqExtDto tagRecordLinkReqExtDto = this.fillTagRecordLinkReqExtDto(dgItemSkuRespVo.getId(), dgOrderDetailReportDto.getShopId());
                        batchAddTagRecordLink.add(tagRecordLinkReqExtDto);
                    }
                }
                linkInfoDto.setBatchAddTagRecordLink(batchAddTagRecordLink);
            } else {
                log.info("\u7edf\u8ba1\u5546\u54c1\u884c\u6570\u636e\u4e3a\u7a7a");
            }
            if (CollectionUtil.isNotEmpty(bizTagRecordEoList)) {
                Set recordIds = bizTagRecordEoList.stream().map(BaseDto::getId).collect(Collectors.toSet());
                linkInfoDto.setBatchDeleteIds((List)Lists.newArrayList(recordIds));
            }
            this.bizTagRecordService.batchAddBizTagRecord(linkInfoDto);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u7545\u9500\u54c1\u6807\u7b7e\u4efb\u52a1\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        return Boolean.TRUE;
    }

    private List<BizTagRecordDto> getBizTagRecord() {
        Integer pageNum = 1;
        ArrayList bizTagRecordEoList = Lists.newArrayList();
        SearchTagRecordLinkDto reqDto = new SearchTagRecordLinkDto();
        reqDto.setTagCodeList((List)Lists.newArrayList((Object[])new String[]{"Best_selling_product"}));
        reqDto.setRecordSourceModel("SHOP_ITEM");
        reqDto.setPageSize(pageSize);
        while (true) {
            reqDto.setPageNum(pageNum);
            PageInfo recordEoPageInfo = this.bizTagRecordService.findParams(reqDto);
            if (null == recordEoPageInfo || CollUtil.isEmpty((Collection)recordEoPageInfo.getList())) break;
            bizTagRecordEoList.addAll(recordEoPageInfo.getList());
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
        }
        return bizTagRecordEoList;
    }

    private TagRecordLinkReqExtDto fillTagRecordLinkReqExtDto(Long recordLinkId, Long recordLinkParentId) {
        TagRecordLinkReqExtDto tagRecordLinkReqExtDto = new TagRecordLinkReqExtDto();
        tagRecordLinkReqExtDto.setRecordSourceModel("SHOP_ITEM");
        tagRecordLinkReqExtDto.setRecordLinkOptType("MANUAL");
        tagRecordLinkReqExtDto.setTagCode("Best_selling_product");
        tagRecordLinkReqExtDto.setRecordLinkId(recordLinkId);
        tagRecordLinkReqExtDto.setRecordLinkParentId(recordLinkParentId);
        return tagRecordLinkReqExtDto;
    }

    public void after(TaskMsg taskMsg) {
        log.info("\u7545\u9500\u54c1\u6807\u7b7ejob\u4efb\u52a1\u7ed3\u675f");
    }
}

