/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.scheduler.task;

import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.AbstractSingleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.yunxi.dg.base.center.report.dto.entity.ReportSyncReqDto;
import com.yunxi.dg.base.center.report.service.entity.IDomesticInventoryReportService;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="domesticInventoryReport")
@Scope(value="prototype")
public class DomesticInventoryReportJob
extends AbstractSingleScheduleEvent {
    private static final Logger log = LoggerFactory.getLogger(DomesticInventoryReportJob.class);
    @Resource
    private IDomesticInventoryReportService service;

    public void before(TaskMsg taskMsg) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        log.info("==========\u5f00\u59cb\u6267\u884c\u56fd\u5185\u5e93\u5b58\u62a5\u8868==========");
    }

    public boolean execute(TaskMsg taskMsg) {
        try {
            long time = System.currentTimeMillis();
            String lastBizMonth = this.service.getLastBizMonth();
            LocalDateTime startTime = null;
            if (StringUtils.hasText((String)lastBizMonth)) {
                startTime = LocalDateTime.parse(lastBizMonth + "-01 00:00:00", DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            }
            ReportSyncReqDto dto = new ReportSyncReqDto(startTime, null, Integer.valueOf(1));
            this.service.syncWithParams(dto);
            log.info("[\u56fd\u5185\u5e93\u5b58\u62a5\u8868\u8017\u65f6]:{} ms", (Object)(System.currentTimeMillis() - time));
        }
        catch (Exception e) {
            log.error("[\u56fd\u5185\u5e93\u5b58\u62a5\u8868]\uff0c\u6267\u884c\u9519\u8bef\uff1a{}\uff0c\u9519\u8bef\u6808\u4fe1\u606f\uff1a", (Object)e.getMessage(), (Object)e);
            return false;
        }
        return true;
    }

    public void after(TaskMsg taskMsg) {
        log.info("==========\u6267\u884c\u56fd\u5185\u5e93\u5b58\u62a5\u8868\u5b8c\u6210==========");
    }
}

