/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.credit.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.report.constants.credit.CreditArchiveBizTypeEnum;
import com.yunxi.dg.base.center.report.constants.credit.CreditArchiveObjectTypeEnum;
import com.yunxi.dg.base.center.report.constants.credit.CreditArchiveShareQuotaEnum;
import com.yunxi.dg.base.center.report.constants.credit.CreditArchiveStatusEnum;
import com.yunxi.dg.base.center.report.convert.entity.CreditArchiveDgConverter;
import com.yunxi.dg.base.center.report.domain.credit.IApplicableCustomersOptionDgDomain;
import com.yunxi.dg.base.center.report.domain.credit.ICreditArchiveDetailDgDomain;
import com.yunxi.dg.base.center.report.domain.credit.ICreditArchiveDgDomain;
import com.yunxi.dg.base.center.report.domain.credit.ICreditQuotaDgDomain;
import com.yunxi.dg.base.center.report.domain.credit.IDemandRepaymentStrategiesDgDomain;
import com.yunxi.dg.base.center.report.dto.credit.CreditArchiveDgDto;
import com.yunxi.dg.base.center.report.dto.credit.CreditArchiveDgPageReqDto;
import com.yunxi.dg.base.center.report.dto.credit.CreditArchiveDgPageRspDto;
import com.yunxi.dg.base.center.report.dto.credit.CreditCustomerReqReport;
import com.yunxi.dg.base.center.report.dto.credit.CreditCustomerRespReport;
import com.yunxi.dg.base.center.report.dto.credit.CreditReceivableAccountReconciliationDgPageReqDto;
import com.yunxi.dg.base.center.report.dto.credit.CreditReceivableAccountReconciliationDgPageRespDto;
import com.yunxi.dg.base.center.report.dto.credit.DemandRepaymentStrategiesDgDto;
import com.yunxi.dg.base.center.report.dto.credit.DemandRepaymentStrategiesDgPageReqDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.CsOrgCustomerRelationExtDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.DgBusinessAreaLevelDto;
import com.yunxi.dg.base.center.report.eo.credit.ApplicableCustomersOptionDgEo;
import com.yunxi.dg.base.center.report.eo.credit.CreditArchiveDetailDgEo;
import com.yunxi.dg.base.center.report.eo.credit.CreditArchiveDgEo;
import com.yunxi.dg.base.center.report.eo.credit.CreditQuotaDgEo;
import com.yunxi.dg.base.center.report.eo.credit.DemandRepaymentStrategiesDgEo;
import com.yunxi.dg.base.center.report.service.credit.ICreditArchiveDgService;
import com.yunxi.dg.base.center.report.service.credit.impl.CustomerRelationHelper;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Sets;
import org.springframework.stereotype.Service;

@Service
public class CreditArchiveDgServiceImpl
extends BaseServiceImpl<CreditArchiveDgDto, CreditArchiveDgEo, ICreditArchiveDgDomain>
implements ICreditArchiveDgService {
    @Resource
    private ICreditArchiveDetailDgDomain creditArchiveDetailDgDomain;
    @Resource
    private ICreditQuotaDgDomain creditQuotaDgDomain;
    @Resource
    private IDemandRepaymentStrategiesDgDomain demandRepaymentStrategiesDgDomain;
    @Resource
    private IApplicableCustomersOptionDgDomain applicableCustomersOptionDgDomain;
    @Resource
    private CustomerRelationHelper customerRelationHelper;

    public CreditArchiveDgServiceImpl(ICreditArchiveDgDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<CreditArchiveDgDto, CreditArchiveDgEo> converter() {
        return CreditArchiveDgConverter.INSTANCE;
    }

    @Override
    public PageInfo<CreditArchiveDgPageRspDto> page(CreditArchiveDgPageReqDto dto) {
        List creditArchiveDgPageRspDtos;
        List<CsOrgCustomerRelationExtDto> relationExtDtoList;
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        if (CollectionUtil.isNotEmpty((Collection)dto.getRegionIdList()) && CollectionUtil.isNotEmpty(relationExtDtoList = this.customerRelationHelper.getBusinessAreaList(dto.getRegionIdList()))) {
            HashSet shopIds = Sets.newHashSet();
            HashSet customerIds = Sets.newHashSet();
            for (CsOrgCustomerRelationExtDto csOrgCustomerRelationExtDto : relationExtDtoList) {
                customerIds.add(csOrgCustomerRelationExtDto.getCustomerId());
                shopIds.add(csOrgCustomerRelationExtDto.getShopId());
            }
            dto.setCustomerIdList((List)Lists.newArrayList((Iterable)customerIds));
            if (CollectionUtil.isNotEmpty((Collection)dto.getShopIds())) {
                dto.getShopIds().addAll(shopIds);
            } else {
                dto.setShopIds((List)Lists.newArrayList((Iterable)shopIds));
            }
        }
        if (CollectionUtil.isEmpty((Collection)(creditArchiveDgPageRspDtos = ((ICreditArchiveDgDomain)this.domain).queryPage(dto)))) {
            return new PageInfo();
        }
        HashSet ids = Sets.newHashSet();
        HashSet shopIds = Sets.newHashSet();
        HashSet customerIds = Sets.newHashSet();
        for (CreditArchiveDgPageRspDto creditArchiveDgPageRspDto : creditArchiveDgPageRspDtos) {
            ids.add(creditArchiveDgPageRspDto.getId());
            shopIds.add(creditArchiveDgPageRspDto.getShopId());
            customerIds.add(creditArchiveDgPageRspDto.getCustomerId());
        }
        List creditArchiveDetailDgEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.creditArchiveDetailDgDomain.filter().eq((Object)"status", (Object)YesNoEnum.NO.getValue())).eq((Object)"is_main", (Object)YesNoEnum.YES.getValue())).in((Object)"biz_type_id", (Collection)ids)).list();
        Map<Object, Object> creditDetailMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty((Collection)creditArchiveDetailDgEos)) {
            creditDetailMap = creditArchiveDetailDgEos.stream().collect(Collectors.groupingBy(CreditArchiveDetailDgEo::getBizTypeId));
        }
        Map<Object, Object> creditQuotaMap = Maps.newHashMap();
        List creditQuotaDgEoList = ((ExtQueryChainWrapper)this.creditQuotaDgDomain.filter().in((Object)"credit_archive_id", (Collection)ids)).list();
        if (CollectionUtil.isNotEmpty((Collection)creditQuotaDgEoList)) {
            creditQuotaMap = creditQuotaDgEoList.stream().collect(Collectors.toMap(CreditQuotaDgEo::getCreditArchiveId, Function.identity()));
        }
        for (CreditArchiveDgPageRspDto creditArchiveDgPageRspDto : creditArchiveDgPageRspDtos) {
            creditArchiveDgPageRspDto.setCreditBizTypeName(CreditArchiveBizTypeEnum.getDescByCode((Integer)creditArchiveDgPageRspDto.getCreditBizType()));
            creditArchiveDgPageRspDto.setCreditObjectTypeName(CreditArchiveObjectTypeEnum.getDescByCode((Integer)creditArchiveDgPageRspDto.getCreditObjectType()));
            creditArchiveDgPageRspDto.setShareCreditQuotaName(CreditArchiveShareQuotaEnum.getDescByCode((Integer)creditArchiveDgPageRspDto.getShareCreditQuota()));
            creditArchiveDgPageRspDto.setStatusName(CreditArchiveStatusEnum.getDescByCode((Integer)creditArchiveDgPageRspDto.getStatus()));
            if (creditDetailMap.containsKey(creditArchiveDgPageRspDto.getId())) {
                long count = ((List)creditDetailMap.get(creditArchiveDgPageRspDto.getId())).stream().count();
                creditArchiveDgPageRspDto.setShareGroupNum(Long.valueOf(count));
            }
            if (!creditQuotaMap.containsKey(creditArchiveDgPageRspDto.getId())) continue;
            CreditQuotaDgEo creditQuotaDgEo = (CreditQuotaDgEo)creditQuotaMap.get(creditArchiveDgPageRspDto.getId());
            creditArchiveDgPageRspDto.setTotalQuota(creditQuotaDgEo.getCreditTotalQuota());
            creditArchiveDgPageRspDto.setTotalFixedQuota(creditQuotaDgEo.getFixedQuota());
            creditArchiveDgPageRspDto.setTotalTempQuota(creditQuotaDgEo.getTempQuota());
        }
        List<CsOrgCustomerRelationExtDto> relationExtDtoList2 = this.customerRelationHelper.getByCustomerIdAndShopId(shopIds, customerIds);
        if (CollectionUtil.isNotEmpty(relationExtDtoList2)) {
            Map<Long, List<DgBusinessAreaLevelDto>> mapAreaLevel = this.customerRelationHelper.getMapAreaLevel(relationExtDtoList2);
            for (CsOrgCustomerRelationExtDto csOrgCustomerRelationExtDto : relationExtDtoList2) {
                if (!mapAreaLevel.containsKey(csOrgCustomerRelationExtDto.getAreaId())) continue;
                List<DgBusinessAreaLevelDto> areaLevelDtoList = mapAreaLevel.get(csOrgCustomerRelationExtDto.getAreaId());
                String regionName = this.customerRelationHelper.getRegionName(areaLevelDtoList);
                for (CreditArchiveDgPageRspDto creditArchiveDgPageRspDto : creditArchiveDgPageRspDtos) {
                    if (!csOrgCustomerRelationExtDto.getCustomerId().equals(creditArchiveDgPageRspDto.getCustomerId()) || !csOrgCustomerRelationExtDto.getShopId().equals(creditArchiveDgPageRspDto.getShopId())) continue;
                    creditArchiveDgPageRspDto.setRegionName(regionName);
                }
            }
        }
        PageInfo pageInfo = new PageInfo(creditArchiveDgPageRspDtos);
        return pageInfo;
    }

    private List<CreditArchiveDgPageRspDto> fillDemandRepaymentStrategies(List<Long> shopIds, List<Long> customerIds, List<CreditArchiveDgPageRspDto> creditArchiveDgPageRspDtoList) {
        DemandRepaymentStrategiesDgEo strategiesDgEo;
        DemandRepaymentStrategiesDgPageReqDto dto = new DemandRepaymentStrategiesDgPageReqDto();
        dto.setShopIds(shopIds);
        List strategiesDgEos = this.demandRepaymentStrategiesDgDomain.queryCustomerRange(dto);
        if (CollectionUtil.isEmpty((Collection)strategiesDgEos)) {
            return creditArchiveDgPageRspDtoList;
        }
        HashSet strategiesIds = Sets.newHashSet();
        HashMap strategiesDgEoMap = Maps.newHashMap();
        for (DemandRepaymentStrategiesDgEo strategiesDgEo2 : strategiesDgEos) {
            strategiesIds.add(strategiesDgEo2.getId());
            strategiesDgEoMap.put(strategiesDgEo2.getId(), strategiesDgEo2);
        }
        List customersOptionDgEos = ((ExtQueryChainWrapper)this.applicableCustomersOptionDgDomain.filter().in((Object)"repayment_strategies_id", (Collection)strategiesIds)).list();
        ArrayList allCustomer = Lists.newArrayList();
        HashMap strategiesMap = Maps.newHashMap();
        for (Long customerId : customerIds) {
            ArrayList repaymentStrategiesDgDtoList = Lists.newArrayList();
            for (ApplicableCustomersOptionDgEo customersOptionDgEo : customersOptionDgEos) {
                if (Objects.equals(customersOptionDgEo.getIsAllCustomers(), 2)) {
                    if (!customersOptionDgEo.getCustomerIds().contains(String.valueOf(customerId))) continue;
                    strategiesDgEo = (DemandRepaymentStrategiesDgEo)strategiesDgEoMap.get(customersOptionDgEo.getRepaymentStrategiesId());
                    String key = strategiesDgEo.getShopId() + "_" + customerId;
                    DemandRepaymentStrategiesDgDto dgDto = new DemandRepaymentStrategiesDgDto();
                    dgDto.setId(strategiesDgEo.getId());
                    dgDto.setName(strategiesDgEo.getName());
                    dgDto.setShopId(strategiesDgEo.getShopId());
                    dgDto.setCustomerId(customerId);
                    dgDto.setCreateTime(strategiesDgEo.getCreateTime());
                    repaymentStrategiesDgDtoList.add(dgDto);
                    strategiesMap.put(key, repaymentStrategiesDgDtoList);
                    continue;
                }
                allCustomer.add(customersOptionDgEo);
            }
        }
        ArrayList all = Lists.newArrayList();
        ArrayList notMatch = Lists.newArrayList();
        ArrayList match = Lists.newArrayList();
        if (strategiesMap.size() > 0) {
            for (CreditArchiveDgPageRspDto c : creditArchiveDgPageRspDtoList) {
                String key = c.getShopId() + "_" + c.getCustomerId();
                if (strategiesMap.containsKey(key)) {
                    List repaymentStrategiesDgDtoList = (List)strategiesMap.get(key);
                    repaymentStrategiesDgDtoList.sort(Comparator.comparing(BaseDto::getCreateTime).reversed());
                    c.setDemandRepaymentStrategiesName(((DemandRepaymentStrategiesDgDto)repaymentStrategiesDgDtoList.get(0)).getName());
                    match.add(c);
                    continue;
                }
                notMatch.add(c);
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)allCustomer) && CollectionUtil.isNotEmpty((Collection)notMatch)) {
            for (CreditArchiveDgPageRspDto c : notMatch) {
                strategiesDgEo = (DemandRepaymentStrategiesDgEo)strategiesDgEoMap.get(((ApplicableCustomersOptionDgEo)allCustomer.get(0)).getRepaymentStrategiesId());
                c.setDemandRepaymentStrategiesName(strategiesDgEo.getName());
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)notMatch)) {
            all.addAll(notMatch);
        }
        if (CollectionUtil.isNotEmpty((Collection)match)) {
            all.addAll(match);
        }
        return all;
    }

    @Override
    public PageInfo<CreditReceivableAccountReconciliationDgPageRespDto> receivableAccountReconciliationPage(CreditReceivableAccountReconciliationDgPageReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        List list = ((ICreditArchiveDgDomain)this.domain).queryReceivableAccountReconciliationPage(dto);
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    @Override
    public PageInfo<CreditCustomerRespReport> creditArchiveReport(CreditCustomerReqReport dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        List creditCustomerRespReportList = ((ICreditArchiveDgDomain)this.domain).creditArchiveReport(dto);
        PageInfo pageInfo = new PageInfo(creditCustomerRespReportList);
        return pageInfo;
    }
}

