/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.credit.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.report.convert.entity.CreditPendingStatementDgConverter;
import com.yunxi.dg.base.center.report.domain.credit.ICreditPendingStatementDgDomain;
import com.yunxi.dg.base.center.report.dto.credit.CreditPendingStatementDgDto;
import com.yunxi.dg.base.center.report.dto.credit.CreditPendingStatementDgPageReqDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.CsOrgCustomerRelationExtDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.DgBusinessAreaLevelDto;
import com.yunxi.dg.base.center.report.eo.credit.CreditPendingStatementDgEo;
import com.yunxi.dg.base.center.report.service.credit.ICreditPendingStatementDgService;
import com.yunxi.dg.base.center.report.service.credit.impl.CustomerRelationHelper;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.assertj.core.util.Lists;
import org.springframework.stereotype.Service;

@Service
public class CreditPendingStatementDgServiceImpl
extends BaseServiceImpl<CreditPendingStatementDgDto, CreditPendingStatementDgEo, ICreditPendingStatementDgDomain>
implements ICreditPendingStatementDgService {
    @Resource
    private CustomerRelationHelper customerRelationHelper;

    public CreditPendingStatementDgServiceImpl(ICreditPendingStatementDgDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<CreditPendingStatementDgDto, CreditPendingStatementDgEo> converter() {
        return CreditPendingStatementDgConverter.INSTANCE;
    }

    @Override
    public PageInfo<CreditPendingStatementDgDto> pageQuery(CreditPendingStatementDgPageReqDto dto) {
        List creditPendingStatementDgDtoList;
        HashSet customerIds;
        HashSet shopIds;
        List<CsOrgCustomerRelationExtDto> relationExtDtoList;
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        if (CollectionUtil.isNotEmpty((Collection)dto.getRegionIdList()) && CollectionUtil.isNotEmpty(relationExtDtoList = this.customerRelationHelper.getBusinessAreaList(dto.getRegionIdList()))) {
            shopIds = Sets.newHashSet();
            customerIds = Sets.newHashSet();
            for (CsOrgCustomerRelationExtDto csOrgCustomerRelationExtDto : relationExtDtoList) {
                customerIds.add(csOrgCustomerRelationExtDto.getCustomerId());
                shopIds.add(csOrgCustomerRelationExtDto.getShopId());
            }
            dto.setCustomerIdList((List)Lists.newArrayList((Iterable)customerIds));
            if (CollectionUtil.isNotEmpty((Collection)dto.getShopIdList())) {
                dto.getShopIdList().addAll(shopIds);
            } else {
                dto.setShopIdList((List)Lists.newArrayList((Iterable)shopIds));
            }
        }
        if (CollectionUtil.isEmpty((Collection)(creditPendingStatementDgDtoList = ((ICreditPendingStatementDgDomain)this.domain).pageQuery(dto)))) {
            return new PageInfo();
        }
        shopIds = Sets.newHashSet();
        customerIds = Sets.newHashSet();
        for (CreditPendingStatementDgDto creditPendingStatementDgDto : creditPendingStatementDgDtoList) {
            shopIds.add(creditPendingStatementDgDto.getShopId());
            customerIds.add(creditPendingStatementDgDto.getCustomerId());
        }
        List<CsOrgCustomerRelationExtDto> relationExtDtoList2 = this.customerRelationHelper.getByCustomerIdAndShopId(shopIds, customerIds);
        if (CollectionUtil.isNotEmpty(relationExtDtoList2)) {
            Map<Long, List<DgBusinessAreaLevelDto>> mapAreaLevel = this.customerRelationHelper.getMapAreaLevel(relationExtDtoList2);
            for (CsOrgCustomerRelationExtDto csOrgCustomerRelationExtDto : relationExtDtoList2) {
                if (!mapAreaLevel.containsKey(csOrgCustomerRelationExtDto.getAreaId())) continue;
                List<DgBusinessAreaLevelDto> areaLevelDtoList = mapAreaLevel.get(csOrgCustomerRelationExtDto.getAreaId());
                String regionName = this.customerRelationHelper.getRegionName(areaLevelDtoList);
                for (CreditPendingStatementDgDto creditPendingStatementDgDto : creditPendingStatementDgDtoList) {
                    if (!csOrgCustomerRelationExtDto.getCustomerId().equals(creditPendingStatementDgDto.getCustomerId()) || !csOrgCustomerRelationExtDto.getShopId().equals(creditPendingStatementDgDto.getShopId())) continue;
                    creditPendingStatementDgDto.setRegionName(regionName);
                }
            }
        }
        return new PageInfo(creditPendingStatementDgDtoList);
    }
}

