/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.enterprice.impl.handler;

import cn.hutool.core.util.StrUtil;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.report.domain.entity.IEnterpriceCrossOrderDomain;
import com.yunxi.dg.base.center.report.domain.entity.IEnterpriceCrossOrderLineDomain;
import com.yunxi.dg.base.center.report.dto.enterprice.EnterpriceInPlanOrderOrgDto;
import com.yunxi.dg.base.center.report.dto.enterprice.EnterpriceOeaPurchaseOrderLine;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossReceiveDeliveryResultReqDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossTradeRelationRespDto;
import com.yunxi.dg.base.center.report.enums.BusinessTypeEnum;
import com.yunxi.dg.base.center.report.enums.CompanyTradeTypeEnum;
import com.yunxi.dg.base.center.report.enums.DisplayBusinessTypeEnum;
import com.yunxi.dg.base.center.report.enums.EnterpriceCrossOrderSyncErpStatusEnum;
import com.yunxi.dg.base.center.report.eo.EnterpriceCrossOrderEo;
import com.yunxi.dg.base.center.report.service.enterprice.IEnterpriceCrossTradeRelationService;
import com.yunxi.dg.base.center.report.service.enterprice.impl.handler.EnterpriceCrossAbstractSceneServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class EnterpriceIntraPurchaseOrderServiceImpl
extends EnterpriceCrossAbstractSceneServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(EnterpriceIntraPurchaseOrderServiceImpl.class);
    @Resource
    private IEnterpriceCrossOrderDomain orderDomain;
    @Resource
    private IEnterpriceCrossOrderLineDomain orderLineDomain;
    @Resource
    private IEnterpriceCrossTradeRelationService tradeRelationService;

    @Override
    public Boolean checkEnterpriceOrderAndHandleBusinessType(EnterpriceCrossReceiveDeliveryResultReqDto context) {
        if (!context.getResultDto().getRelevanceTableName().equals("in_plan_order")) {
            return Boolean.FALSE;
        }
        if (context.getResultDto().getBusinessType().equals(BusinessTypeEnum.PURCHASE_ORDER.getType())) {
            context.getResultDto().setDisplayBusinessType(DisplayBusinessTypeEnum.PURCHASE_ORDER.getType());
            context.getResultDto().setBusinessType(BusinessTypeEnum.PURCHASE_ORDER.getType());
            return Boolean.TRUE;
        }
        if (context.getResultDto().getBusinessType().equals(BusinessTypeEnum.PURCHASE_ORDER_RETURN.getType())) {
            context.getResultDto().setDisplayBusinessType(DisplayBusinessTypeEnum.PURCHASE_ORDER.getType());
            context.getResultDto().setBusinessType(BusinessTypeEnum.PURCHASE_ORDER_RETURN.getType());
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public List<Long> createOrder(EnterpriceCrossReceiveDeliveryResultReqDto context) {
        boolean isPurchaseOrder = context.getResultDto().getBusinessType().equals(BusinessTypeEnum.PURCHASE_ORDER.getType());
        String saleEnterpriceOrderType = isPurchaseOrder ? CompanyTradeTypeEnum.SALE_ORDER.getType() : CompanyTradeTypeEnum.AFTERSALE_ORDER.getType();
        String purchaseEnterpriceOrderType = isPurchaseOrder ? CompanyTradeTypeEnum.PURCHASE_ORDER.getType() : CompanyTradeTypeEnum.PURCHASE_AFTERSALE_ORDER.getType();
        ArrayList<Long> orderIds = new ArrayList<Long>();
        EnterpriceInPlanOrderOrgDto inPlanOrderOrgDto = this.orderDomain.selectInPlanOrderOrgByInPlanOrderNo(context.getResultDto().getRelevanceNo());
        EnterpriceCrossTradeRelationRespDto saleEnterprise = this.tradeRelationService.getBySaleEnterpriseByPurchaseEnterpriseCodeAndSupplierCode(inPlanOrderOrgDto.getSaleOrganizationCode(), inPlanOrderOrgDto.getSupplierCode());
        List oeaPurchaseOrderLines = this.orderDomain.selectOeaPurchaseSkuPriceList(context.getResultDto().getId());
        if (isPurchaseOrder) {
            Integer sourceType = ((EnterpriceOeaPurchaseOrderLine)oeaPurchaseOrderLines.get(0)).getSourceType();
            BigDecimal ratio = sourceType.equals(1) ? (saleEnterprise == null ? BigDecimal.ONE : saleEnterprise.getExtPurchaseRatio()) : (saleEnterprise == null ? BigDecimal.ONE : saleEnterprise.getFactoryRatio());
            orderIds.add(this.createSaleOrder(context, saleEnterpriceOrderType, inPlanOrderOrgDto, saleEnterprise, ratio, oeaPurchaseOrderLines));
            orderIds.add(this.createPurchaseOrder(context, purchaseEnterpriceOrderType, inPlanOrderOrgDto, saleEnterprise, ratio, oeaPurchaseOrderLines));
        } else {
            orderIds.add(this.createPurchaseOrder(context, purchaseEnterpriceOrderType, inPlanOrderOrgDto, saleEnterprise, null, null));
            orderIds.add(this.createSaleOrder(context, saleEnterpriceOrderType, inPlanOrderOrgDto, saleEnterprise, null, null));
        }
        return orderIds;
    }

    private Long createPurchaseOrder(EnterpriceCrossReceiveDeliveryResultReqDto context, String orderType, EnterpriceInPlanOrderOrgDto inPlanOrderOrgDto, EnterpriceCrossTradeRelationRespDto saleEnterprise, BigDecimal ratio, List<EnterpriceOeaPurchaseOrderLine> oeaPurchaseOrderLines) {
        EnterpriceCrossOrderEo purchaseOrderEo = this.createEo();
        purchaseOrderEo.setSyncStatus(EnterpriceCrossOrderSyncErpStatusEnum.SYNC_TODO.getType());
        purchaseOrderEo.setBusinessType(context.getResultDto().getBusinessType());
        purchaseOrderEo.setDisplayBusinessType(context.getResultDto().getDisplayBusinessType());
        purchaseOrderEo.setResultOrderId(context.getResultDto().getId());
        purchaseOrderEo.setType(orderType);
        purchaseOrderEo.setDocumentNo(this.orderDomain.createDocumentNo(purchaseOrderEo.getType()));
        if (inPlanOrderOrgDto == null || StrUtil.isBlank((CharSequence)inPlanOrderOrgDto.getSaleOrganizationCode())) {
            this.setExceptionToSyncException(purchaseOrderEo, "\u83b7\u53d6\u91c7\u8d2d\u65b9\u4fe1\u606f\u5931\u8d25");
        } else {
            purchaseOrderEo.setPurchaseEnterpriseId(inPlanOrderOrgDto.getPurchaseEnterpriseId());
            purchaseOrderEo.setPurchaseEnterpriseCode(inPlanOrderOrgDto.getSaleOrganizationCode());
            purchaseOrderEo.setCalculateCompanyCode(purchaseOrderEo.getPurchaseEnterpriseCode());
        }
        if (inPlanOrderOrgDto == null || StrUtil.isBlank((CharSequence)inPlanOrderOrgDto.getSupplierCode())) {
            this.setExceptionToSyncException(purchaseOrderEo, "\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25");
        } else {
            purchaseOrderEo.setSupplierId(inPlanOrderOrgDto.getSupplierId());
            purchaseOrderEo.setSupplierCode(inPlanOrderOrgDto.getSupplierCode());
        }
        this.orderDomain.insert((BaseEo)purchaseOrderEo);
        if (orderType.equals(CompanyTradeTypeEnum.PURCHASE_ORDER.getType())) {
            Boolean result = this.orderLineDomain.createPurchaseBusinessTypeOrderLine(context.getResultDto(), context.getResultDetailDtoList(), purchaseOrderEo, oeaPurchaseOrderLines, ratio);
            this.deductFailSetSyncException(result, purchaseOrderEo);
        }
        if (orderType.equals(CompanyTradeTypeEnum.PURCHASE_AFTERSALE_ORDER.getType())) {
            Boolean duductResult = this.orderLineDomain.purchaseOrderReturnDeductAndCreateOrderLine(context.getResultDetailDtoList(), purchaseOrderEo);
            this.deductFailSetSyncException(duductResult, purchaseOrderEo);
        }
        return purchaseOrderEo.getId();
    }

    private Long createSaleOrder(EnterpriceCrossReceiveDeliveryResultReqDto context, String orderType, EnterpriceInPlanOrderOrgDto inPlanOrderOrgDto, EnterpriceCrossTradeRelationRespDto saleEnterprise, BigDecimal ratio, List<EnterpriceOeaPurchaseOrderLine> oeaPurchaseOrderLines) {
        EnterpriceCrossOrderEo saleOrder = this.createEo();
        saleOrder.setSyncStatus(EnterpriceCrossOrderSyncErpStatusEnum.SYNC_TODO.getType());
        saleOrder.setBusinessType(context.getResultDto().getBusinessType());
        saleOrder.setDisplayBusinessType(context.getResultDto().getDisplayBusinessType());
        saleOrder.setResultOrderId(context.getResultDto().getId());
        saleOrder.setType(orderType);
        saleOrder.setDocumentNo(this.orderDomain.createDocumentNo(saleOrder.getType()));
        if (saleEnterprise == null) {
            this.setExceptionToSyncException(saleOrder, "\u83b7\u53d6\u9500\u552e\u516c\u53f8\u4fe1\u606f\u5931\u8d25");
            this.setExceptionToSyncException(saleOrder, "\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f\u5931\u8d25");
        } else {
            saleOrder.setSaleEnterpriseId(saleEnterprise.getEnterpriseId());
            saleOrder.setSaleEnterpriseCode(saleEnterprise.getEnterpriseCode());
            saleOrder.setCustomerId(saleEnterprise.getCustomerId());
            saleOrder.setCustomerCode(saleEnterprise.getCustomerCode());
            saleOrder.setCalculateCompanyCode(saleOrder.getSaleEnterpriseCode());
        }
        this.orderDomain.insert((BaseEo)saleOrder);
        if (saleOrder.getType().equals(CompanyTradeTypeEnum.SALE_ORDER.getType())) {
            Boolean result = this.orderLineDomain.createPurchaseBusinessTypeOrderLine(context.getResultDto(), context.getResultDetailDtoList(), saleOrder, oeaPurchaseOrderLines, ratio);
            this.deductFailSetSyncException(result, saleOrder);
        }
        if (saleOrder.getType().equals(CompanyTradeTypeEnum.AFTERSALE_ORDER.getType())) {
            Boolean duductResult = this.orderLineDomain.saleOrderReturnDeductAndCreateOrderLine(context.getResultDetailDtoList(), saleOrder);
            this.deductFailSetSyncException(duductResult, saleOrder);
        }
        return saleOrder.getId();
    }
}

