/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.constants.CostAllocRuleStatusEnum;
import com.yunxi.dg.base.center.report.convert.entity.BudgetCostAllocRuleConverter;
import com.yunxi.dg.base.center.report.domain.entity.IBudgetCostAllocRuleDomain;
import com.yunxi.dg.base.center.report.domain.entity.IBudgetCostAllocRuleShopDomain;
import com.yunxi.dg.base.center.report.domain.entity.ICostAllocRuleArchiveDomain;
import com.yunxi.dg.base.center.report.domain.entity.ICostArchiveDomain;
import com.yunxi.dg.base.center.report.dto.entity.AggBudgetCostAllocRuleDto;
import com.yunxi.dg.base.center.report.dto.entity.BudgetCostAllocRuleDto;
import com.yunxi.dg.base.center.report.dto.entity.BudgetCostAllocRulePageReqDto;
import com.yunxi.dg.base.center.report.dto.entity.BudgetCostAllocRulePageRespDto;
import com.yunxi.dg.base.center.report.dto.entity.BudgetCostAllocRuleShopDto;
import com.yunxi.dg.base.center.report.dto.entity.CostAllocRuleDto;
import com.yunxi.dg.base.center.report.dto.entity.CostArchiveDto;
import com.yunxi.dg.base.center.report.dto.entity.CostArchivePageReqDto;
import com.yunxi.dg.base.center.report.eo.BudgetCostAllocRuleEo;
import com.yunxi.dg.base.center.report.eo.BudgetCostAllocRuleShopEo;
import com.yunxi.dg.base.center.report.eo.CostAllocRuleArchiveEo;
import com.yunxi.dg.base.center.report.eo.CostArchiveEo;
import com.yunxi.dg.base.center.report.service.entity.IBudgetCostAllocRuleService;
import com.yunxi.dg.base.center.report.service.entity.ICostAllocRuleArchiveService;
import com.yunxi.dg.base.center.report.service.entity.ICostArchiveService;
import com.yunxi.dg.base.center.report.service.utils.BeanConvertUtil;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BudgetCostAllocRuleServiceImpl
extends BaseServiceImpl<BudgetCostAllocRuleDto, BudgetCostAllocRuleEo, IBudgetCostAllocRuleDomain>
implements IBudgetCostAllocRuleService {
    private static final Logger log = LoggerFactory.getLogger(BudgetCostAllocRuleServiceImpl.class);
    @Resource
    private ICostAllocRuleArchiveDomain iCostAllocRuleArchiveDomain;
    @Resource
    private IBudgetCostAllocRuleShopDomain iBudgetCostAllocRuleShopDomain;
    @Resource
    private ICostAllocRuleArchiveService iCostAllocRuleArchiveService;
    @Resource
    private ICostArchiveService iCostArchiveService;
    @Resource
    private ICostArchiveDomain iCostArchiveDomain;

    public BudgetCostAllocRuleServiceImpl(IBudgetCostAllocRuleDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<BudgetCostAllocRuleDto, BudgetCostAllocRuleEo> converter() {
        return BudgetCostAllocRuleConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long insertRuleInfo(AggBudgetCostAllocRuleDto dto) {
        this.verifyInsertParam(dto);
        BudgetCostAllocRuleEo ruleEo = (BudgetCostAllocRuleEo)BeanConvertUtil.toBean((Object)dto, BudgetCostAllocRuleEo.class);
        ((IBudgetCostAllocRuleDomain)this.domain).saveOrUpdate((BaseEo)ruleEo);
        dto.setId(ruleEo.getId());
        this.insertArchiveDtoList(dto);
        this.insertBudgetRuleList(dto);
        return dto.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long updateRuleInfo(AggBudgetCostAllocRuleDto dto) {
        BudgetCostAllocRuleEo eo = this.verifyParam((BudgetCostAllocRuleDto)dto);
        dto.setStatus(eo.getStatus());
        this.deleteSlaveData(dto.getId());
        return this.insertRuleInfo(dto);
    }

    @Override
    public AggBudgetCostAllocRuleDto getAggRule(Long id) {
        AggBudgetCostAllocRuleDto budgetCostAllocRuleDto = (AggBudgetCostAllocRuleDto)BeanConvertUtil.toBean((Object)((IBudgetCostAllocRuleDomain)this.domain).selectByPrimaryKey(id), AggBudgetCostAllocRuleDto.class);
        AssertUtils.notNull((Object)budgetCostAllocRuleDto, (String)"\u975e\u6cd5\u5165\u53c2");
        budgetCostAllocRuleDto.setArchiveDtoList(this.iCostAllocRuleArchiveService.queryByRuleId(id, 2));
        budgetCostAllocRuleDto.setBudgetRuleList(BeanConvertUtil.copyToList((Collection)this.iBudgetCostAllocRuleShopDomain.selectList((LambdaQueryWrapper)Wrappers.lambdaQuery(BudgetCostAllocRuleShopEo.class).eq(BudgetCostAllocRuleShopEo::getRuleId, (Object)id)), BudgetCostAllocRuleShopDto.class));
        return budgetCostAllocRuleDto;
    }

    @Override
    public Long updateStatus(BudgetCostAllocRuleDto dto) {
        Date date;
        BudgetCostAllocRuleEo budgetCostAllocRuleEo = this.verifyParam(dto);
        AssertUtils.notNull((Object)dto.getStatus(), (String)"\u53d8\u66f4\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((!budgetCostAllocRuleEo.getStatus().equals("end") ? 1 : 0) != 0, (String)"\u5df2\u7ecf\u7ed3\u675f\u5355\u636e\u4e0d\u53ef\u53d8\u66f4\u72b6\u6001");
        budgetCostAllocRuleEo.setStatus(dto.getStatus());
        if (dto.getStatus().equals("pending")) {
            date = new Date();
            if (budgetCostAllocRuleEo.getStartTime().before(date) && budgetCostAllocRuleEo.getEndTime().after(date)) {
                budgetCostAllocRuleEo.setStatus("running");
                budgetCostAllocRuleEo.setStartTime((Date)DateUtil.beginOfDay((Date)date));
            } else if (budgetCostAllocRuleEo.getEndTime().before(date)) {
                budgetCostAllocRuleEo.setStatus("end");
                budgetCostAllocRuleEo.setEndTime((Date)DateUtil.beginOfSecond((Date)DateUtil.endOfDay((Date)date)));
            }
        }
        if ("end".equals(dto.getStatus())) {
            date = new Date();
            date = date.before(budgetCostAllocRuleEo.getEndTime()) ? date : budgetCostAllocRuleEo.getEndTime();
            budgetCostAllocRuleEo.setEndTime((Date)DateUtil.beginOfSecond((Date)DateUtil.endOfDay((Date)date)));
        }
        ((IBudgetCostAllocRuleDomain)this.domain).updateSelective((BaseEo)budgetCostAllocRuleEo);
        return dto.getId();
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> logicDelete(Long id) {
        BudgetCostAllocRuleEo budgetCostAllocRuleEo = (BudgetCostAllocRuleEo)((IBudgetCostAllocRuleDomain)this.domain).selectByPrimaryKey(id);
        AssertUtils.notNull((Object)budgetCostAllocRuleEo, (String)"\u5220\u9664\u6570\u636e\u4e0d\u5b58\u5728\u4e86\u6216\u8005\u88ab\u5220\u9664\u4e86");
        AssertUtils.isTrue((!budgetCostAllocRuleEo.getStatus().equals("running") ? 1 : 0) != 0, (String)"\u6267\u884c\u4e2d\u7684\u6570\u636e\u4e0d\u53ef\u5220\u9664");
        this.deleteSlaveData(id);
        return super.logicDelete(id);
    }

    @Override
    public PageInfo<BudgetCostAllocRulePageRespDto> page(BudgetCostAllocRulePageReqDto pageReqDto) {
        if (!this.listCostArchiveInfo(pageReqDto).booleanValue()) {
            return new PageInfo();
        }
        PageInfo ruleEoPageInfo = ((IBudgetCostAllocRuleDomain)this.domain).selectPage((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(BudgetCostAllocRuleEo.class).eq(StrUtil.isNotBlank((CharSequence)pageReqDto.getCode()), BudgetCostAllocRuleEo::getCode, (Object)pageReqDto.getCode())).like(StrUtil.isNotBlank((CharSequence)pageReqDto.getName()), BudgetCostAllocRuleEo::getName, (Object)pageReqDto.getName())).in(CollectionUtil.isNotEmpty((Collection)pageReqDto.getStatusList()), BudgetCostAllocRuleEo::getStatus, (Collection)pageReqDto.getStatusList())).in(CollectionUtil.isNotEmpty((Collection)pageReqDto.getIdList()), BaseEo::getId, (Collection)pageReqDto.getIdList())).orderByDesc(BaseEo::getCreateTime), pageReqDto.getPageNum(), pageReqDto.getPageSize());
        PageInfo<BudgetCostAllocRulePageRespDto> convert = BeanConvertUtil.convert(ruleEoPageInfo, BudgetCostAllocRulePageRespDto.class);
        this.setCostAllocRuleNameForCostAllocRulePage(convert);
        return convert;
    }

    @Override
    public void scanBudgetCostAllocRuleStatus() {
        List budgetCostAllocRuleEos = ((IBudgetCostAllocRuleDomain)this.domain).selectList((LambdaQueryWrapper)Wrappers.lambdaQuery(BudgetCostAllocRuleEo.class).in(BudgetCostAllocRuleEo::getStatus, new Object[]{CostAllocRuleStatusEnum.UNSTART.getCode(), CostAllocRuleStatusEnum.PENDING.getCode(), CostAllocRuleStatusEnum.RUNNING.getCode()}));
        if (CollectionUtil.isEmpty((Collection)budgetCostAllocRuleEos)) {
            log.info("\u6ca1\u6709\u9700\u8981\u53d8\u66f4\u72b6\u6001");
            return;
        }
        for (BudgetCostAllocRuleEo budgetCostAllocRuleEo : budgetCostAllocRuleEos) {
            Date date = new Date();
            if (CostAllocRuleStatusEnum.UNSTART.getCode().equals(budgetCostAllocRuleEo.getStatus())) {
                if (!budgetCostAllocRuleEo.getEndTime().before(date)) continue;
                budgetCostAllocRuleEo.setStatus(CostAllocRuleStatusEnum.ABOLISHED.getCode());
                ((IBudgetCostAllocRuleDomain)this.domain).updateSelective((BaseEo)budgetCostAllocRuleEo);
                continue;
            }
            if (budgetCostAllocRuleEo.getStartTime().before(date) && budgetCostAllocRuleEo.getEndTime().after(date)) {
                if ("running".equals(budgetCostAllocRuleEo.getStatus())) continue;
                budgetCostAllocRuleEo.setStatus("running");
                budgetCostAllocRuleEo.setStartTime((Date)DateUtil.beginOfDay((Date)date));
                ((IBudgetCostAllocRuleDomain)this.domain).updateSelective((BaseEo)budgetCostAllocRuleEo);
                continue;
            }
            if (!budgetCostAllocRuleEo.getEndTime().before(date)) continue;
            budgetCostAllocRuleEo.setStatus("end");
            ((IBudgetCostAllocRuleDomain)this.domain).updateSelective((BaseEo)budgetCostAllocRuleEo);
        }
    }

    private void deleteSlaveData(Long id) {
        this.iCostAllocRuleArchiveDomain.delete((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(CostAllocRuleArchiveEo.class).eq(CostAllocRuleArchiveEo::getType, (Object)2)).eq(CostAllocRuleArchiveEo::getRuleId, (Object)id));
        this.iBudgetCostAllocRuleShopDomain.delete((LambdaUpdateWrapper)Wrappers.lambdaUpdate(BudgetCostAllocRuleShopEo.class).eq(BudgetCostAllocRuleShopEo::getRuleId, (Object)id));
    }

    private void setCostAllocRuleNameForCostAllocRulePage(PageInfo<BudgetCostAllocRulePageRespDto> pageInfo) {
        if (CollectionUtil.isEmpty((Collection)pageInfo.getList())) {
            return;
        }
        List<Long> ruleIds = ((List)Optional.ofNullable(pageInfo.getList()).orElse(new ArrayList())).stream().map(BaseDto::getId).collect(Collectors.toList());
        List<CostAllocRuleArchiveEo> costAllocRuleArchiveEos = this.listCostAllocRuleArchiveEos(null, ruleIds);
        Map ruleIdMap = costAllocRuleArchiveEos.stream().collect(Collectors.groupingBy(CostAllocRuleArchiveEo::getRuleId, Collectors.mapping(CostAllocRuleArchiveEo::getArchiveId, Collectors.toList())));
        List costArchiveEos = this.iCostArchiveDomain.selectByIds(costAllocRuleArchiveEos.stream().map(CostAllocRuleArchiveEo::getArchiveId).collect(Collectors.toList()));
        Map costArchiveEoMap = costArchiveEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        for (BudgetCostAllocRulePageRespDto respDto : pageInfo.getList()) {
            List archiveIds = ruleIdMap.getOrDefault(respDto.getId(), Collections.emptyList());
            for (Long archiveId : archiveIds) {
                if (StrUtil.isNotBlank((CharSequence)respDto.getArchiveName())) {
                    respDto.setArchiveName(respDto.getArchiveName() + "," + ((CostArchiveEo)costArchiveEoMap.get(archiveId)).getName());
                    continue;
                }
                respDto.setArchiveName(((CostArchiveEo)costArchiveEoMap.get(archiveId)).getName());
            }
        }
    }

    private Boolean listCostArchiveInfo(BudgetCostAllocRulePageReqDto pageReqDto) {
        if (StrUtil.isNotBlank((CharSequence)pageReqDto.getArchiveName())) {
            CostArchivePageReqDto archivePageReqDto = new CostArchivePageReqDto();
            archivePageReqDto.setName(pageReqDto.getArchiveName());
            List<CostArchiveDto> costArchiveDtos = this.iCostArchiveService.queryList(archivePageReqDto);
            if (CollectionUtil.isEmpty(costArchiveDtos)) {
                return false;
            }
            List<Long> archiveIdList = ((List)Optional.ofNullable(costArchiveDtos).orElse(new ArrayList())).stream().map(BaseDto::getId).collect(Collectors.toList());
            List<CostAllocRuleArchiveEo> costAllocRuleArchiveEos = this.listCostAllocRuleArchiveEos(archiveIdList, null);
            if (CollectionUtil.isEmpty(costAllocRuleArchiveEos)) {
                return false;
            }
            List ruleIds = costAllocRuleArchiveEos.stream().map(CostAllocRuleArchiveEo::getRuleId).collect(Collectors.toList());
            pageReqDto.setIdList(ruleIds);
            return true;
        }
        return true;
    }

    private List<CostAllocRuleArchiveEo> listCostAllocRuleArchiveEos(List<Long> archiveIdList, List<Long> roleIds) {
        List costAllocRuleArchiveEos = this.iCostAllocRuleArchiveDomain.selectList((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CostAllocRuleArchiveEo.class).eq(CostAllocRuleArchiveEo::getType, (Object)2)).in(CollectionUtil.isNotEmpty(archiveIdList), CostAllocRuleArchiveEo::getArchiveId, archiveIdList)).in(CollectionUtil.isNotEmpty(roleIds), CostAllocRuleArchiveEo::getRuleId, roleIds));
        return costAllocRuleArchiveEos;
    }

    private BudgetCostAllocRuleEo verifyParam(BudgetCostAllocRuleDto dto) {
        boolean isAbolished;
        AssertUtils.notNull((Object)dto, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)dto.getId(), (String)"\u5165\u53c2id\u4e0d\u80fd\u4e3a\u7a7a");
        BudgetCostAllocRuleEo budgetCostAllocRuleEo = (BudgetCostAllocRuleEo)((IBudgetCostAllocRuleDomain)this.domain).selectByPrimaryKey(dto.getId());
        AssertUtils.notNull((Object)budgetCostAllocRuleEo, (String)"\u975e\u6cd5\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        dto.setCode(budgetCostAllocRuleEo.getCode());
        Date endTime = dto.getEndTime() != null ? dto.getEndTime() : budgetCostAllocRuleEo.getEndTime();
        boolean bl = isAbolished = CostAllocRuleStatusEnum.UNSTART.getCode().equals(budgetCostAllocRuleEo.getStatus()) && endTime.before(new Date());
        if (isAbolished) {
            dto.setStatus(CostAllocRuleStatusEnum.ABOLISHED.getCode());
        }
        return budgetCostAllocRuleEo;
    }

    private void insertBudgetRuleList(AggBudgetCostAllocRuleDto dto) {
        if (CollectionUtil.isEmpty((Collection)dto.getBudgetRuleList())) {
            return;
        }
        dto.getBudgetRuleList().forEach(e -> {
            e.setRuleId(dto.getId());
            e.setId(null);
        });
        this.iBudgetCostAllocRuleShopDomain.saveOrUpdateBatch(BeanConvertUtil.copyToList((Collection)dto.getBudgetRuleList(), BudgetCostAllocRuleShopEo.class));
    }

    private void insertArchiveDtoList(AggBudgetCostAllocRuleDto dto) {
        if (CollectionUtil.isEmpty((Collection)dto.getArchiveDtoList())) {
            return;
        }
        dto.getArchiveDtoList().forEach(e -> {
            e.setRuleId(dto.getId());
            e.setType(Integer.valueOf(2));
            e.setId(null);
        });
        this.iCostAllocRuleArchiveDomain.saveOrUpdateBatch(BeanConvertUtil.copyToList((Collection)dto.getArchiveDtoList(), CostAllocRuleArchiveEo.class));
    }

    private void verifyInsertParam(AggBudgetCostAllocRuleDto dto) {
        AssertUtils.notNull((Object)dto, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)dto.getName(), (String)"\u5206\u644a\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)dto.getStartTime(), (String)"\u6267\u884c\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)dto.getEndTime(), (String)"\u6267\u884c\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)dto.getAllocType(), (String)"\u5206\u644a\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty((Collection)dto.getBudgetRuleList(), (String)"\u9884\u7b97\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty((Collection)dto.getArchiveDtoList(), (String)"\u9002\u7528\u8d39\u7528\u4e0d\u80fd\u4e3a\u7a7a");
        if (StrUtil.isBlank((CharSequence)dto.getCode())) {
            dto.setCode(String.format("BC%s", DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss")));
        }
        if (StringUtils.isBlank((CharSequence)dto.getStatus())) {
            dto.setStatus("unstart");
        }
    }

    @Override
    public List<CostAllocRuleDto> getRules(List<String> statusList) {
        return ((IBudgetCostAllocRuleDomain)this.domain).getRules(statusList);
    }
}

