/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.wh.center.expenses.api.dto.request.ExpenseQueryDetailReqDto;
import com.wh.center.expenses.api.dto.response.ExpenseRespDto;
import com.wh.center.expenses.api.query.IExpenseQueryApi;
import com.yunxi.dg.base.center.report.convert.entity.CostArchiveConverter;
import com.yunxi.dg.base.center.report.domain.entity.ICostArchiveDomain;
import com.yunxi.dg.base.center.report.domain.entity.ICostCategoryDomain;
import com.yunxi.dg.base.center.report.dto.entity.CostArchiveDto;
import com.yunxi.dg.base.center.report.dto.entity.CostArchivePageReqDto;
import com.yunxi.dg.base.center.report.eo.CostArchiveEo;
import com.yunxi.dg.base.center.report.eo.CostCategoryEo;
import com.yunxi.dg.base.center.report.service.entity.ICostAllocRuleArchiveService;
import com.yunxi.dg.base.center.report.service.entity.ICostArchiveService;
import com.yunxi.dg.base.center.report.service.entity.ICostCategoryService;
import com.yunxi.dg.base.center.report.service.utils.BeanConvertUtil;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.dto.BasePageDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CostArchiveServiceImpl
extends BaseServiceImpl<CostArchiveDto, CostArchiveEo, ICostArchiveDomain>
implements ICostArchiveService {
    private static final Logger log = LoggerFactory.getLogger(CostArchiveServiceImpl.class);
    @Resource
    private ICostAllocRuleArchiveService costAllocRuleArchiveService;
    @Resource
    private ICostCategoryDomain costCategoryDomain;
    @Resource
    private ICostCategoryService costCategoryService;
    @Resource
    private IExpenseQueryApi expenseQueryApi;
    @Resource
    private ICostCategoryDomain iCostCategoryDomain;

    public CostArchiveServiceImpl(ICostArchiveDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<CostArchiveDto, CostArchiveEo> converter() {
        return CostArchiveConverter.INSTANCE;
    }

    public RestResponse<Long> insert(CostArchiveDto dto) {
        this.verifyParam(dto);
        return super.insert((BaseDto)dto);
    }

    public RestResponse<Integer> update(CostArchiveDto dto) {
        this.verifyParam(dto);
        return super.update((BaseDto)dto);
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Integer> insertBatch(List<CostArchiveDto> dtos) {
        boolean b = ((ICostArchiveDomain)this.domain).saveOrUpdateBatch(BeanUtil.copyToList(dtos, CostArchiveEo.class));
        return RestResponse.createInteger((Integer)1);
    }

    public RestResponse<Void> logicDelete(Long id) {
        int count = this.costAllocRuleArchiveService.countByArchiveIds(Lists.newArrayList((Object[])new Long[]{id}));
        AssertUtils.isTrue((count <= 0 ? 1 : 0) != 0, (String)"\u8be5\u8d39\u7528\u6863\u6848\u5df2\u88ab\u76f8\u5173\u89c4\u5219\u5173\u8054\uff0c\u65e0\u6cd5\u5220\u9664");
        return super.logicDelete(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> logicDeleteBatch(List<String> idList) {
        int count = this.costAllocRuleArchiveService.countByArchiveIds(idList.stream().map(Long::parseLong).collect(Collectors.toList()));
        AssertUtils.isTrue((count <= 0 ? 1 : 0) != 0, (String)"\u8be5\u8d39\u7528\u6863\u6848\u5df2\u88ab\u76f8\u5173\u89c4\u5219\u5173\u8054\uff0c\u65e0\u6cd5\u5220\u9664");
        ((ICostArchiveDomain)this.domain).logicDeleteByIds(idList.stream().map(Long::valueOf).collect(Collectors.toList()));
        return RestResponse.VOID;
    }

    public RestResponse<CostArchiveDto> get(Long id) {
        RestResponse resp = super.get(id);
        CostArchiveDto dto = (CostArchiveDto)RestResponseHelper.extractData((RestResponse)resp);
        if (dto != null) {
            this.setJoinCategoryName(Lists.newArrayList((Object[])new CostArchiveDto[]{dto}));
        }
        return resp;
    }

    public RestResponse<PageInfo<CostArchiveDto>> page(BasePageDto queryDto) {
        CostArchivePageReqDto archivePageReqDto = (CostArchivePageReqDto)queryDto;
        List<String> categoryCodes = Optional.ofNullable(archivePageReqDto.getCategoryCodes()).orElse(new ArrayList());
        if (StrUtil.isNotBlank((CharSequence)archivePageReqDto.getCategoryCode())) {
            categoryCodes.add(archivePageReqDto.getCategoryCode());
        }
        categoryCodes = this.costCategoryService.getDescendantCodes(categoryCodes);
        archivePageReqDto.setCategoryCodes(categoryCodes);
        PageInfo costArchiveEoPageInfo = ((ICostArchiveDomain)this.domain).selectPage((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CostArchiveEo.class).eq(StrUtil.isNotBlank((CharSequence)archivePageReqDto.getCode()), CostArchiveEo::getCode, (Object)archivePageReqDto.getCode())).eq(StrUtil.isNotBlank((CharSequence)archivePageReqDto.getExpenseCode()), CostArchiveEo::getExpenseCode, (Object)archivePageReqDto.getExpenseCode())).like(StrUtil.isNotBlank((CharSequence)archivePageReqDto.getName()), CostArchiveEo::getName, (Object)archivePageReqDto.getName())).like(StrUtil.isNotBlank((CharSequence)archivePageReqDto.getCategoryName()), CostArchiveEo::getCategoryName, (Object)archivePageReqDto.getCategoryName())).like(StrUtil.isNotBlank((CharSequence)archivePageReqDto.getExpenseName()), CostArchiveEo::getExpenseName, (Object)archivePageReqDto.getExpenseName())).in(CollectionUtil.isNotEmpty((Collection)archivePageReqDto.getCodeList()), CostArchiveEo::getCode, (Collection)archivePageReqDto.getCodeList())).in(CollectionUtil.isNotEmpty((Collection)archivePageReqDto.getIdList()), BaseEo::getId, (Collection)archivePageReqDto.getIdList())).in(!categoryCodes.isEmpty(), CostArchiveEo::getCategoryCode, categoryCodes), queryDto.getPageNum(), queryDto.getPageSize());
        PageInfo<CostArchiveDto> page = BeanConvertUtil.convert(costArchiveEoPageInfo, CostArchiveDto.class);
        this.setJoinCategoryName(page.getList());
        this.setExpenseName(page.getList());
        return new RestResponse(page);
    }

    private void setExpenseName(List<CostArchiveDto> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        List expenseCodes = list.stream().map(CostArchiveDto::getExpenseCode).filter(CharSequenceUtil::isNotBlank).distinct().collect(Collectors.toList());
        if (expenseCodes.isEmpty()) {
            return;
        }
        ExpenseQueryDetailReqDto req = new ExpenseQueryDetailReqDto();
        req.setCodes(expenseCodes);
        RestResponse resp = this.expenseQueryApi.queryByCodes(req);
        List expenses = (List)RestResponseHelper.extractData((RestResponse)resp);
        Map<String, String> map = expenses.stream().collect(Collectors.toMap(ExpenseRespDto::getExpenseCode, ExpenseRespDto::getExpenseName));
        for (CostArchiveDto dto : list) {
            if (dto.getExpenseCode() == null || !map.containsKey(dto.getExpenseCode())) continue;
            dto.setExpenseName(map.get(dto.getExpenseCode()));
        }
    }

    @Override
    public List<CostArchiveDto> queryList(CostArchivePageReqDto archivePageReqDto) {
        List costArchiveEos = ((ICostArchiveDomain)this.domain).selectList((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CostArchiveEo.class).eq(StrUtil.isNotBlank((CharSequence)archivePageReqDto.getCode()), CostArchiveEo::getCode, (Object)archivePageReqDto.getCode())).eq(StrUtil.isNotBlank((CharSequence)archivePageReqDto.getExpenseCode()), CostArchiveEo::getExpenseCode, (Object)archivePageReqDto.getExpenseCode())).like(StrUtil.isNotBlank((CharSequence)archivePageReqDto.getName()), CostArchiveEo::getName, (Object)archivePageReqDto.getName())).like(StrUtil.isNotBlank((CharSequence)archivePageReqDto.getCategoryName()), CostArchiveEo::getCategoryName, (Object)archivePageReqDto.getCategoryName())).like(StrUtil.isNotBlank((CharSequence)archivePageReqDto.getExpenseName()), CostArchiveEo::getExpenseName, (Object)archivePageReqDto.getExpenseName())).in(CollectionUtil.isNotEmpty((Collection)archivePageReqDto.getCodeList()), CostArchiveEo::getCode, (Collection)archivePageReqDto.getCodeList())).in(CollectionUtil.isNotEmpty((Collection)archivePageReqDto.getIdList()), BaseEo::getId, (Collection)archivePageReqDto.getIdList())).eq(StrUtil.isNotBlank((CharSequence)archivePageReqDto.getCategoryCode()), CostArchiveEo::getCategoryCode, (Object)archivePageReqDto.getCategoryCode()));
        List costArchiveDtos = BeanConvertUtil.copyToList((Collection)costArchiveEos, CostArchiveDto.class);
        List costCategoryEos = this.iCostCategoryDomain.selectAll();
        Map<String, List<CostCategoryEo>> parentNameMap = this.getParentNameListByChild(costCategoryEos);
        this.setJoinCategoryName(costArchiveDtos);
        return costArchiveDtos;
    }

    @Override
    public int countByCategoryCode(String categoryCode) {
        return ((ICostArchiveDomain)this.domain).countByCategoryCode(categoryCode);
    }

    private void setJoinCategoryName(List<CostArchiveDto> costArchiveList) {
        this.costCategoryService.setCategoryPaths(costArchiveList, CostArchiveDto::getCategoryCode, CostArchiveDto::setJoinCategoryCode, CostArchiveDto::setJoinCategoryName);
    }

    private Map<String, List<CostCategoryEo>> getParentNameListByChild(List<CostCategoryEo> costCategoryEos) {
        if (CollectionUtil.isEmpty(costCategoryEos)) {
            return Collections.emptyMap();
        }
        Map<Long, CostCategoryEo> nodeMap = ((List)Optional.ofNullable(costCategoryEos).orElse(new ArrayList())).stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (v1, v2) -> v1));
        HashMap<String, List<CostCategoryEo>> ancestorsMap = new HashMap<String, List<CostCategoryEo>>();
        for (CostCategoryEo costCategoryEo : costCategoryEos) {
            ArrayList<CostCategoryEo> ancestors = new ArrayList<CostCategoryEo>();
            this.findAncestors(costCategoryEo, nodeMap, ancestors);
            ancestorsMap.put(costCategoryEo.getCode(), ancestors);
        }
        return ancestorsMap;
    }

    private void findAncestors(CostCategoryEo node, Map<Long, CostCategoryEo> nodeMap, List<CostCategoryEo> parentNameList) {
        CostCategoryEo parentNode;
        long parentId = node.getParentId();
        while (parentId != -1L && (parentNode = nodeMap.get(parentId)) != null) {
            parentNameList.add(parentNode);
            parentId = parentNode.getParentId();
        }
    }

    private void verifyParam(CostArchiveDto dto) {
        AssertUtils.notBlank((String)dto.getCode(), (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)dto.getName(), (String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)dto.getCategoryCode(), (String)"\u7c7b\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String categoryCode = StrUtil.subAfter((CharSequence)dto.getCategoryCode(), (CharSequence)"/", (boolean)true);
        dto.setCategoryCode(categoryCode);
        String categoryName = StrUtil.subAfter((CharSequence)dto.getCategoryName(), (CharSequence)"/", (boolean)true);
        dto.setCategoryName(categoryName);
        CostArchiveEo costArchiveEo = (CostArchiveEo)((ICostArchiveDomain)this.domain).selectOne((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CostArchiveEo.class).eq(CostArchiveEo::getCode, (Object)dto.getCode())).ne(dto.getId() != null && !dto.getId().equals(0L), BaseEo::getId, (Object)dto.getId()));
        AssertUtils.isNull((Object)costArchiveEo, (String)"\u8be5\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
    }
}

