/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.eo.BaseEo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.report.convert.entity.CustomerRebateDetailReportConverter;
import com.yunxi.dg.base.center.report.domain.customer.IDgCsOrgCustomerRelationDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgCsRRelationShopDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgCustomerAreaDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgCustomerDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgEnterpriseDomain;
import com.yunxi.dg.base.center.report.domain.entity.IAccountFlowDomain;
import com.yunxi.dg.base.center.report.domain.entity.ICustomerRebateDetailReportDomain;
import com.yunxi.dg.base.center.report.domain.entity.IDgShopDomain;
import com.yunxi.dg.base.center.report.domain.entity.IDictDomain;
import com.yunxi.dg.base.center.report.domain.entity.IFlowTypeDomain;
import com.yunxi.dg.base.center.report.domain.rebate.IBillDomain;
import com.yunxi.dg.base.center.report.dto.customer.entity.CsCustomerAreaInfoDto;
import com.yunxi.dg.base.center.report.dto.entity.CodeAndNameDto;
import com.yunxi.dg.base.center.report.dto.entity.CustomerRebateDetailReportDto;
import com.yunxi.dg.base.center.report.dto.entity.CustomerRebateDetailReportJoinDto;
import com.yunxi.dg.base.center.report.dto.entity.CustomerRebateDetailReportPageReqDto;
import com.yunxi.dg.base.center.report.dto.entity.ReportSyncReqDto;
import com.yunxi.dg.base.center.report.eo.CustomerRebateDetailReportEo;
import com.yunxi.dg.base.center.report.eo.DgShopEo;
import com.yunxi.dg.base.center.report.eo.account.AccountFlowEo;
import com.yunxi.dg.base.center.report.eo.customer.DgCsRRelationShopEo;
import com.yunxi.dg.base.center.report.eo.customer.DgCustomerEo;
import com.yunxi.dg.base.center.report.eo.customer.DgEnterpriseEo;
import com.yunxi.dg.base.center.report.eo.customer.DgOrgCustomerRelationEo;
import com.yunxi.dg.base.center.report.eo.rebate.BillEo;
import com.yunxi.dg.base.center.report.service.entity.ICustomerRebateCollectReportService;
import com.yunxi.dg.base.center.report.service.entity.ICustomerRebateDetailReportService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CustomerRebateDetailReportServiceImpl
extends BaseServiceImpl<CustomerRebateDetailReportDto, CustomerRebateDetailReportEo, ICustomerRebateDetailReportDomain>
implements ICustomerRebateDetailReportService {
    private static final Logger log = LoggerFactory.getLogger(CustomerRebateDetailReportServiceImpl.class);
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    @Resource
    private IAccountFlowDomain accountFlowDomain;
    @Resource
    private IBillDomain billDomain;
    @Resource
    private IDgShopDomain dgShopDomain;
    @Resource
    private IDgCsRRelationShopDomain dgCsRRelationShopDomain;
    @Resource
    private IDgCsOrgCustomerRelationDomain dgCsOrgCustomerRelationDomain;
    @Resource
    private IDgCustomerAreaDomain dgCustomerAreaDomain;
    @Resource
    private ICustomerRebateCollectReportService customerRebateCollectReportService;
    @Resource
    private IDgCustomerDomain customerDomain;
    @Resource
    private IFlowTypeDomain flowTypeDomain;
    @Resource
    private IDictDomain dictDomain;
    @Resource
    private IDgEnterpriseDomain enterpriseDomain;

    public CustomerRebateDetailReportServiceImpl(ICustomerRebateDetailReportDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<CustomerRebateDetailReportDto, CustomerRebateDetailReportEo> converter() {
        return CustomerRebateDetailReportConverter.INSTANCE;
    }

    @Override
    public void syncWithParams(ReportSyncReqDto dto) {
        dto.paramsCheck(() -> this.accountFlowDomain.getMinUpdateTime());
        dto.syncByStep("\u5ba2\u6237\u8fd4\u5229\u51fa\u5165\u6c60\u660e\u7ec6\u62a5\u8868", this::doSyncInternal);
    }

    private void doSyncInternal(LocalDateTime startTime, LocalDateTime endTime) {
        boolean hasNextPage;
        List deletedChangeTimes = ((ICustomerRebateDetailReportDomain)this.domain).queryBusinessDateBySourceUpdateTime(startTime, endTime);
        ((ICustomerRebateDetailReportDomain)this.domain).physicsDeleteBySourceUpdateTime(startTime, endTime);
        if (!deletedChangeTimes.isEmpty()) {
            log.info("\u5ba2\u6237\u8fd4\u5229\u51fa\u5165\u6c60\u660e\u7ec6\u62a5\u8868\u91cd\u8dd1\u6536\u5f71\u54cd\u7684\u4e1a\u52a1\u65e5\u671f\uff1atimeRange={}-{}, businessDates={}", new Object[]{startTime.format(this.formatter), endTime.format(this.formatter), deletedChangeTimes});
        }
        int pageNum = 1;
        int pageSize = 1000;
        ArrayList amountBusinessTypes = Lists.newArrayList((Object[])new String[]{"income", "disburse"});
        ArrayList<AccountFlowEo> all = new ArrayList<AccountFlowEo>();
        do {
            PageInfo page = this.accountFlowDomain.pageRebateByUpdateTime(startTime, endTime, (List)amountBusinessTypes, pageNum, pageSize);
            log.info("\u5ba2\u6237\u8fd4\u5229\u51fa\u5165\u6c60\u660e\u7ec6\u62a5\u8868\u540c\u6b65: {} - {} \u67e5\u8be2\u5230\u7b2c {} \u9875\u6709 {} \u6761\u6570\u636e\uff0c\u5171 {} \u9875", new Object[]{startTime.format(this.formatter), endTime.format(this.formatter), pageNum, page.getSize(), page.getPages()});
            ++pageNum;
            hasNextPage = page.isHasNextPage();
            List list = page.getList();
            if (list == null || list.isEmpty()) continue;
            all.addAll(list);
        } while (hasNextPage);
        Set<LocalDate> businessDates = this.doSyncInternal(all);
        businessDates.addAll(deletedChangeTimes.stream().map(LocalDateTime::toLocalDate).collect(Collectors.toSet()));
        log.info("\u5ba2\u6237\u8fd4\u5229\u51fa\u5165\u6c60\u660e\u7ec6\u62a5\u8868\u540c\u6b65: \u4e00\u5171\u6709 {} \u5929\u7684\u6570\u636e\u9700\u8981\u89e6\u53d1\u6c47\u603b\u8868\u540c\u6b65\uff1a{}", (Object)businessDates.size(), businessDates);
        businessDates.stream().sorted().forEachOrdered(businessDate -> {
            ReportSyncReqDto req = new ReportSyncReqDto(businessDate.atStartOfDay(), businessDate.plusDays(1L).atStartOfDay(), Integer.valueOf(1));
            log.info("\u5ba2\u6237\u8fd4\u5229\u51fa\u5165\u6c60\u660e\u7ec6\u62a5\u8868\u540c\u6b65: \u89e6\u53d1 {} \u5b58\u5e93\u8fdb\u9500\u5b58\u62a5\u8868\u540c\u6b65\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", businessDate, (Object)JSONUtil.toJsonStr((Object)req));
            this.customerRebateCollectReportService.syncWithParams(req);
        });
    }

    private Set<LocalDate> doSyncInternal(List<AccountFlowEo> list) {
        log.info("\u5ba2\u6237\u8fd4\u5229\u51fa\u5165\u6c60\u660e\u7ec6\u62a5\u8868\u540c\u6b65: \u5171 {} \u6761\u8bb0\u5f55", (Object)list.size());
        if (list.isEmpty()) {
            return new HashSet<LocalDate>(0);
        }
        List<CustomerRebateDetailReportJoinDto> details = this.flowToDetails(list);
        this.process_dg_cs_org_customer_relation_And_dg_cs_r_relation_shop(details);
        this.process_dg_cs_customer_area(details);
        List flowIds = details.stream().map(CustomerRebateDetailReportDto::getFlowId).distinct().collect(Collectors.toList());
        log.info("\u5ba2\u6237\u8fd4\u5229\u51fa\u5165\u6c60\u660e\u7ec6\u62a5\u8868\u540c\u6b65: \u5220\u9664\u76f8\u5173\u7684\u65e7\u6570\u636e {}", flowIds);
        ((ICustomerRebateDetailReportDomain)this.domain).physicsDeleteByFlowIds(flowIds);
        log.info("\u5ba2\u6237\u8fd4\u5229\u51fa\u5165\u6c60\u660e\u7ec6\u62a5\u8868\u540c\u6b65: \u5220\u9664\u76f8\u5173\u7684\u65e7\u6570\u636e\u5b8c\u6210");
        ArrayList result = new ArrayList(list.size());
        HashSet<LocalDate> businessDates = new HashSet<LocalDate>();
        details.forEach(r -> {
            businessDates.add(LocalDateTimeUtil.of((Date)r.getChangeTime()).toLocalDate());
            result.add(this.converter().toEo((BaseDto)r));
        });
        log.info("\u5ba2\u6237\u8fd4\u5229\u51fa\u5165\u6c60\u660e\u7ec6\u62a5\u8868\u540c\u6b65: \u51c6\u5907\u4fdd\u5b58 {} \u6761\u6570\u636e", (Object)list.size());
        ((ICustomerRebateDetailReportDomain)this.domain).insertBatch(result);
        log.info("\u5ba2\u6237\u8fd4\u5229\u51fa\u5165\u6c60\u660e\u7ec6\u62a5\u8868\u540c\u6b65: \u51c6\u5907\u4fdd\u5b58 {} \u6761\u6570\u636e\u5b8c\u6210", (Object)list.size());
        return businessDates;
    }

    private void process_dg_cs_customer_area(List<CustomerRebateDetailReportJoinDto> list) {
        List areaIds = list.stream().map(CustomerRebateDetailReportJoinDto::getAreaId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (areaIds.isEmpty()) {
            return;
        }
        Map map = this.dgCustomerAreaDomain.getAreaInfoMap(areaIds);
        list.forEach(join -> {
            CsCustomerAreaInfoDto area = (CsCustomerAreaInfoDto)map.get(join.getAreaId());
            if (area == null) {
                log.info("businessOrderNo={}, areaId:{} not found", (Object)join.getBusinessOrderNo(), (Object)join.getAreaId());
                return;
            }
            join.setRegionCode(area.getRegionCode());
            join.setRegionName(area.getRegionName());
            join.setProvinceCode(area.getProvinceCode());
            join.setProvinceName(area.getProvinceName());
            join.setCityCode(area.getCityCode());
            join.setCityName(area.getCityName());
        });
    }

    private void process_dg_cs_org_customer_relation_And_dg_cs_r_relation_shop(List<CustomerRebateDetailReportJoinDto> list) {
        Set customerIds = list.stream().map(CustomerRebateDetailReportJoinDto::getCustomerId).filter(Objects::nonNull).collect(Collectors.toSet());
        if (customerIds.isEmpty()) {
            return;
        }
        int status = 4;
        List relations = this.dgCsOrgCustomerRelationDomain.queryByCustomerIdsAndStatus(customerIds, status);
        Map<Long, List<DgOrgCustomerRelationEo>> relationMap = relations.stream().collect(Collectors.groupingBy(DgOrgCustomerRelationEo::getCustomerId));
        List relationIds = relations.stream().map(BaseEo::getId).collect(Collectors.toList());
        List relationShops = this.dgCsRRelationShopDomain.queryByRelationIds(relationIds);
        Map<String, DgCsRRelationShopEo> shopMap = relationShops.stream().collect(Collectors.toMap(k -> k.getRelationId() + "-" + k.getShopId(), v -> v));
        list.forEach(join -> {
            List joinRelations = relationMap.getOrDefault(join.getCustomerId(), new ArrayList(0));
            if ((joinRelations = joinRelations.stream().filter(relation -> shopMap.containsKey(relation.getId() + "-" + join.getShopId())).collect(Collectors.toList())).isEmpty()) {
                return;
            }
            DgOrgCustomerRelationEo relation2 = (DgOrgCustomerRelationEo)joinRelations.get(0);
            join.setAreaId(relation2.getAreaId());
        });
    }

    private List<CustomerRebateDetailReportJoinDto> flowToDetails(List<AccountFlowEo> list) {
        HashSet rebateTypes = Sets.newHashSet((Object[])new String[]{"37"});
        List businessOrderNoList = list.stream().filter(flow -> rebateTypes.contains(flow.getChangeType())).map(AccountFlowEo::getBusinessOrderNo).collect(Collectors.toList());
        List bills = this.billDomain.queryByCodes(businessOrderNoList);
        Map<String, BillEo> billMap = bills.stream().collect(Collectors.toMap(BillEo::getCode, v -> v, (a, b) -> {
            log.warn("\u91cd\u590d\u7684\u8fd4\u5229\u6838\u7b97\u5355\u53f7\uff1a{}, a={}, b={}", new Object[]{a.getCode(), a.getId(), b.getId()});
            return b;
        }));
        HashSet customerCodes = new HashSet();
        HashSet shopCodes = new HashSet();
        list.forEach(flow -> {
            customerCodes.add(flow.getCustomerNo());
            shopCodes.add(flow.getShopCode());
        });
        List shops = this.dgShopDomain.selectByCodes(1, 1, 1, shopCodes);
        Map<String, DgShopEo> shopMap = shops.stream().collect(Collectors.toMap(DgShopEo::getCode, v -> v));
        List customers = this.customerDomain.queryByCodes(customerCodes);
        Map<String, DgCustomerEo> customerMap = customers.stream().collect(Collectors.toMap(DgCustomerEo::getCode, v -> v, (a, b) -> {
            log.warn("\u91cd\u590d\u7684\u5ba2\u6237\u7f16\u7801\uff1acode={}, a={}, b={}", new Object[]{a.getCode(), a.getId(), b.getId()});
            return b;
        }));
        List companies = this.enterpriseDomain.selectList((LambdaQueryWrapper)Wrappers.lambdaQuery(DgEnterpriseEo.class).eq(BaseEo::getDr, (Object)0));
        Map<String, DgEnterpriseEo> companyMap = companies.stream().collect(Collectors.toMap(DgEnterpriseEo::getCode, v -> v, (a, b) -> b));
        Map typeMap = this.flowTypeDomain.getTypeNewNameMap();
        Map documentTypeMap = this.dictDomain.queryValueCodeNameMap("yunxi-dg-base-center-account", "flow_document_type");
        return list.stream().map(flow -> {
            BillEo bill;
            DgShopEo shop;
            DgEnterpriseEo company;
            CustomerRebateDetailReportJoinDto report = new CustomerRebateDetailReportJoinDto();
            report.setFlowId(flow.getId());
            report.setCustomerCode(flow.getCustomerNo());
            report.setCustomerName(flow.getCustomerName());
            report.setType(flow.getType());
            report.setChangeTime(flow.getCreateTime());
            report.setSpecialProject(Integer.valueOf("REBATE_SP".equals(flow.getAccountType()) ? 1 : 0));
            report.setBusinessOrderNo(flow.getBusinessOrderNo());
            report.setChangeType(flow.getChangeType());
            CodeAndNameDto typeName = (CodeAndNameDto)typeMap.get(flow.getChangeType());
            report.setChangeTypeName(typeName != null ? typeName.getName() : flow.getChangeType());
            report.setDocumentType(flow.getDocumentType());
            report.setDocumentTypeName(documentTypeMap.getOrDefault(flow.getDocumentType(), flow.getDocumentType()));
            report.setTradeAmount(flow.getTradeAmount());
            report.setBeforeBalance(flow.getBeforeBalance());
            report.setBalance(flow.getBalance());
            report.setRebateDate(flow.getCreateTime());
            report.setSourceUpdateTime(LocalDateTimeUtil.of((Date)flow.getUpdateTime()));
            report.setShopCode(flow.getShopCode());
            report.setShopName(flow.getShopName());
            report.setCompanyName(flow.getSaleCompanyName());
            DgCustomerEo customer = (DgCustomerEo)customerMap.get(report.getCustomerCode());
            if (customer != null) {
                report.setCustomerId(customer.getId());
                report.setCustomerName(customer.getName());
                report.setCompanyId(customer.getCompanyId());
            }
            if ((company = (DgEnterpriseEo)companyMap.get(flow.getSaleCompanyCode())) != null) {
                report.setCompanyId(company.getId());
                report.setCompanyName(company.getName());
            }
            if ((shop = (DgShopEo)shopMap.get(report.getShopCode())) != null) {
                report.setShopId(shop.getId());
                report.setShopName(shop.getName());
                report.setBusinessUnitCode(shop.getBusinessUnitCode());
                report.setBusinessUnitName(shop.getBusinessUnitName());
            }
            if (rebateTypes.contains(flow.getChangeType()) && (bill = (BillEo)billMap.get(flow.getBusinessOrderNo())) != null) {
                report.setRebateBusinessTypeCode(bill.getRebateBusinessTypeCode());
                report.setRebateBusinessTypeName(bill.getRebateBusinessTypeName());
                report.setRemark(bill.getRemark());
            }
            return report;
        }).collect(Collectors.toList());
    }

    @Override
    public PageInfo<CustomerRebateDetailReportDto> page(CustomerRebateDetailReportPageReqDto dto) {
        return PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize()).doSelectPageInfo(() -> ((ICustomerRebateDetailReportDomain)this.domain).queryList(dto));
    }

    @Override
    public LocalDateTime getLastSourceUpdateTime() {
        return ((ICustomerRebateDetailReportDomain)this.domain).getLastSourceUpdateTime();
    }
}

