/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.report.convert.entity.DgCustomerInfoConverter;
import com.yunxi.dg.base.center.report.domain.entity.IDgCustomerInfoDomain;
import com.yunxi.dg.base.center.report.dto.entity.DgCustomerInfoDto;
import com.yunxi.dg.base.center.report.eo.DgCustomerInfoEo;
import com.yunxi.dg.base.center.report.service.entity.IDgCustomerInfoService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class DgCustomerInfoServiceImpl
extends BaseServiceImpl<DgCustomerInfoDto, DgCustomerInfoEo, IDgCustomerInfoDomain>
implements IDgCustomerInfoService {
    @Resource
    private IDgCustomerInfoDomain dgCustomerInfoDomain;

    public DgCustomerInfoServiceImpl(IDgCustomerInfoDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgCustomerInfoDto, DgCustomerInfoEo> converter() {
        return DgCustomerInfoConverter.INSTANCE;
    }

    @Override
    public RestResponse<List<DgCustomerInfoEo>> getCustomerInfoEos(List<String> customerCodes) {
        if (CollectionUtils.isNotEmpty(customerCodes)) {
            List customerInfoEos = ((ExtQueryChainWrapper)this.dgCustomerInfoDomain.filter().in((Object)"code", customerCodes)).list();
            return new RestResponse((Object)customerInfoEos);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<List<DgCustomerInfoEo>> getCustomerInfos(List<String> customerCodes) {
        if (CollectionUtils.isNotEmpty(customerCodes)) {
            List customerInfoEos = ((ExtQueryChainWrapper)this.dgCustomerInfoDomain.filter().in((Object)"code", customerCodes)).list();
            return new RestResponse((Object)customerInfoEos);
        }
        return new RestResponse();
    }
}

