/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.DateUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.convert.entity.KeepAccountMidwaySnapConverter;
import com.yunxi.dg.base.center.report.domain.entity.IKeepAccountMidwaySnapDomain;
import com.yunxi.dg.base.center.report.dto.entity.KeepAccountEnRouteInventoryDetailDto;
import com.yunxi.dg.base.center.report.dto.entity.KeepAccountEnRouteInventoryReqDto;
import com.yunxi.dg.base.center.report.dto.entity.KeepAccountMidwaySnapDto;
import com.yunxi.dg.base.center.report.dto.entity.KeepAccountMidwaySnapPageReqDto;
import com.yunxi.dg.base.center.report.eo.KeepAccountMidwaySnapEo;
import com.yunxi.dg.base.center.report.service.entity.IDgPushKeepAccountsService;
import com.yunxi.dg.base.center.report.service.entity.IKeepAccountMidwaySnapService;
import com.yunxi.dg.base.center.report.service.inventory.IDgLogicInventoryService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.BeanCopyUtil;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class KeepAccountMidwaySnapServiceImpl
extends BaseServiceImpl<KeepAccountMidwaySnapDto, KeepAccountMidwaySnapEo, IKeepAccountMidwaySnapDomain>
implements IKeepAccountMidwaySnapService {
    private static final Logger logger = LoggerFactory.getLogger(KeepAccountMidwaySnapServiceImpl.class);
    @Resource
    private IDgPushKeepAccountsService pushKeepAccountsService;
    @Resource
    private IDgLogicInventoryService logicInventoryService;

    public KeepAccountMidwaySnapServiceImpl(IKeepAccountMidwaySnapDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<KeepAccountMidwaySnapDto, KeepAccountMidwaySnapEo> converter() {
        return KeepAccountMidwaySnapConverter.INSTANCE;
    }

    @Override
    public List<KeepAccountMidwaySnapDto> querySnap() {
        Date beforeDate = DateUtil.getStartOfDay((Date)new Date());
        ArrayList inventoryReqDtoList = new ArrayList();
        KeepAccountEnRouteInventoryReqDto reqDto = new KeepAccountEnRouteInventoryReqDto();
        reqDto.setPageNum(Integer.valueOf(1));
        reqDto.setPageSize(Integer.valueOf(2000));
        PageInfo<KeepAccountEnRouteInventoryDetailDto> pageInfo = this.pushKeepAccountsService.queryKeepAccountEnRouteInventoryDetail(reqDto);
        while (ObjectUtils.isNotEmpty(pageInfo) && CollectionUtil.isNotEmpty((Collection)pageInfo.getList()) && pageInfo.getList().size() > 0) {
            inventoryReqDtoList.addAll(pageInfo.getList());
            reqDto.setPageNum(Integer.valueOf(reqDto.getPageNum() + 1));
            pageInfo = this.pushKeepAccountsService.queryKeepAccountEnRouteInventoryDetail(reqDto);
        }
        if (CollectionUtil.isEmpty(inventoryReqDtoList)) {
            logger.info("\u67e5\u8be2\u8bb0\u8d26\u5728\u9014\u5e93\u5b58\u660e\u7ec6,\u65e0\u6570\u636e");
            return new ArrayList<KeepAccountMidwaySnapDto>();
        }
        logger.info("\u67e5\u8be2\u8bb0\u8d26\u5728\u9014\u5e93\u5b58\u660e\u7ec6\u6570\u91cf\uff1a{}", (Object)inventoryReqDtoList.size());
        logger.debug("\u67e5\u8be2\u8bb0\u8d26\u5728\u9014\u5e93\u5b58\u660e\u7ec6\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString(inventoryReqDtoList));
        Map<String, List<KeepAccountEnRouteInventoryDetailDto>> enRouteInventoryMap = inventoryReqDtoList.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getLogicWarehouseCode()) && StringUtils.isNotBlank((CharSequence)f.getSkuCode())).collect(Collectors.groupingBy(g -> g.getLogicWarehouseCode() + g.getSkuCode()));
        logger.debug("\u6839\u636e\u903b\u8f91\u4ed3\u5e93+sku\u7f16\u7801\u5206\u7ec4\uff1a{}", (Object)JSON.toJSONString(enRouteInventoryMap));
        ArrayList<KeepAccountMidwaySnapDto> midwaySnapDtoList = new ArrayList<KeepAccountMidwaySnapDto>();
        enRouteInventoryMap.forEach((k, v) -> {
            BigDecimal midwayNum = v.stream().map(KeepAccountEnRouteInventoryDetailDto::getDoneQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            KeepAccountEnRouteInventoryDetailDto detailDto = (KeepAccountEnRouteInventoryDetailDto)v.get(0);
            KeepAccountMidwaySnapDto snapDto = new KeepAccountMidwaySnapDto();
            snapDto.setStatisticsDate(beforeDate);
            snapDto.setLogicWarehouseCodeList(v.stream().map(KeepAccountEnRouteInventoryDetailDto::getLogicWarehouseCode).collect(Collectors.toList()));
            snapDto.setLogicWarehouseCode(detailDto.getLogicWarehouseCode());
            snapDto.setLogicWarehouseName(detailDto.getLogicWarehouseName());
            snapDto.setPhysicsWarehouseCode(detailDto.getPhysicsWarehouseCode());
            snapDto.setPhysicsWarehouseName(detailDto.getPhysicsWarehouseName());
            snapDto.setSkuCode(detailDto.getSkuCode());
            snapDto.setSkuName(detailDto.getSkuName());
            snapDto.setItemCode(detailDto.getItemCode());
            snapDto.setItemName(detailDto.getItemName());
            snapDto.setMidwayNum(midwayNum);
            snapDto.setCurrentNum(BigDecimal.ZERO);
            midwaySnapDtoList.add(snapDto);
        });
        return midwaySnapDtoList;
    }

    @Override
    public void saveSnap() {
        logger.info("\u4fdd\u5b58\u8bb0\u8d26\u5728\u9014\u5e93\u5b58\u5feb\u7167");
        List<KeepAccountMidwaySnapDto> snapDtoList = this.querySnap();
        if (CollectionUtil.isEmpty(snapDtoList)) {
            logger.info("\u65e0\u5feb\u7167\u6570\u636e\u9700\u8981\u751f\u6210");
            return;
        }
        logger.debug("\u6784\u5efa\u7684\u5feb\u7167\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(snapDtoList));
        List historySnapEoList = ((ExtQueryChainWrapper)((IKeepAccountMidwaySnapDomain)this.domain).filter().eq((Object)"statistics_date", (Object)snapDtoList.get(0).getStatisticsDate())).list();
        AssertUtils.isFalse((boolean)CollectionUtil.isNotEmpty((Collection)historySnapEoList), (String)"\u8be5\u65e5\u671f\u5df2\u5b58\u5728\u5feb\u7167\u4fe1\u606f");
        List snapEoList = BeanUtil.copyToList(snapDtoList, KeepAccountMidwaySnapEo.class);
        List updateEoLists = Lists.partition((List)snapEoList, (int)2000);
        for (List updateEoList : updateEoLists) {
            ((IKeepAccountMidwaySnapDomain)this.domain).insertBatch(updateEoList);
        }
    }

    @Override
    public PageInfo<KeepAccountMidwaySnapDto> queryPage(KeepAccountMidwaySnapPageReqDto pageReqDto) {
        logger.info("\u8bb0\u8d26\u5728\u9014\u5e93\u5b58\u5feb\u7167\u5206\u9875\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)pageReqDto));
        PageInfo eoPageInfo = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IKeepAccountMidwaySnapDomain)this.domain).filter().eq(ObjectUtils.isNotEmpty((Object)pageReqDto.getStatisticsDate()), (Object)"statistics_date", (Object)pageReqDto.getStatisticsDate())).in(CollectionUtil.isNotEmpty((Collection)pageReqDto.getLogicWarehouseCodeList()), (Object)"logic_warehouse_code", (Collection)pageReqDto.getLogicWarehouseCodeList())).eq(StringUtils.isNotBlank((CharSequence)pageReqDto.getSkuCode()), (Object)"sku_code", (Object)pageReqDto.getSkuCode())).like(StringUtils.isNotBlank((CharSequence)pageReqDto.getItemName()), (Object)"sku_name", (Object)("%" + pageReqDto.getItemName() + "%"))).in(CollectionUtil.isNotEmpty((Collection)pageReqDto.getSkuCodeList()), (Object)"sku_code", (Collection)pageReqDto.getSkuCodeList())).in(CollectionUtil.isNotEmpty((Collection)pageReqDto.getPhysicsWarehouseCodeList()), (Object)"physics_warehouse_code", (Collection)pageReqDto.getPhysicsWarehouseCodeList())).orderByDesc((Object)"id")).page(pageReqDto.getPageNum(), pageReqDto.getPageSize());
        PageInfo returnPageInfo = new PageInfo();
        BeanCopyUtil.copyProperties((Object)eoPageInfo, (Object)returnPageInfo);
        List returnList = BeanUtil.copyToList((Collection)eoPageInfo.getList(), KeepAccountMidwaySnapDto.class);
        returnPageInfo.setList(returnList);
        return returnPageInfo;
    }

    @Override
    public List<KeepAccountMidwaySnapDto> queryKeepAccountMidwaySnapList(KeepAccountMidwaySnapPageReqDto pageReqDto) {
        KeepAccountEnRouteInventoryReqDto keepAccountEnRouteInventoryReqDto = new KeepAccountEnRouteInventoryReqDto();
        keepAccountEnRouteInventoryReqDto.setLogicWarehouseCodeList(pageReqDto.getLogicWarehouseCodeList());
        keepAccountEnRouteInventoryReqDto.setSkuCodeList(pageReqDto.getSkuCodeList());
        List<KeepAccountEnRouteInventoryDetailDto> inventoryReqDtoList = this.pushKeepAccountsService.queryKeepAccountEnRouteInventoryDetailList(keepAccountEnRouteInventoryReqDto);
        if (CollectionUtils.isEmpty(inventoryReqDtoList)) {
            return Lists.newArrayList();
        }
        Map<String, List<KeepAccountEnRouteInventoryDetailDto>> enRouteInventoryMap = inventoryReqDtoList.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getLogicWarehouseCode()) && StringUtils.isNotBlank((CharSequence)f.getSkuCode())).collect(Collectors.groupingBy(g -> g.getLogicWarehouseCode() + g.getSkuCode()));
        logger.debug("\u6839\u636e\u903b\u8f91\u4ed3\u5e93+sku\u7f16\u7801\u5206\u7ec4\uff1a{}", (Object)JSON.toJSONString(enRouteInventoryMap));
        ArrayList<KeepAccountMidwaySnapDto> midwaySnapDtoList = new ArrayList<KeepAccountMidwaySnapDto>();
        enRouteInventoryMap.forEach((k, v) -> {
            BigDecimal midwayNum = v.stream().map(KeepAccountEnRouteInventoryDetailDto::getDoneQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            KeepAccountEnRouteInventoryDetailDto detailDto = (KeepAccountEnRouteInventoryDetailDto)v.get(0);
            KeepAccountMidwaySnapDto snapDto = new KeepAccountMidwaySnapDto();
            snapDto.setStatisticsDate(new Date());
            snapDto.setLogicWarehouseCodeList(v.stream().map(KeepAccountEnRouteInventoryDetailDto::getLogicWarehouseCode).collect(Collectors.toList()));
            snapDto.setLogicWarehouseCode(detailDto.getLogicWarehouseCode());
            snapDto.setLogicWarehouseName(detailDto.getLogicWarehouseName());
            snapDto.setPhysicsWarehouseCode(detailDto.getPhysicsWarehouseCode());
            snapDto.setPhysicsWarehouseName(detailDto.getPhysicsWarehouseName());
            snapDto.setSkuCode(detailDto.getSkuCode());
            snapDto.setSkuName(detailDto.getSkuName());
            snapDto.setItemCode(detailDto.getItemCode());
            snapDto.setItemName(detailDto.getItemName());
            snapDto.setMidwayNum(midwayNum);
            snapDto.setCurrentNum(BigDecimal.ZERO);
            midwaySnapDtoList.add(snapDto);
        });
        return midwaySnapDtoList;
    }
}

