/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.expense;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.report.domain.customer.IDgCustomerAreaDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgCustomerDomain;
import com.yunxi.dg.base.center.report.domain.item.IBrandDgDomain;
import com.yunxi.dg.base.center.report.domain.item.IDirDgDomain;
import com.yunxi.dg.base.center.report.domain.item.IItemDgDomain;
import com.yunxi.dg.base.center.report.domain.user.IUsOrganizationDomain;
import com.yunxi.dg.base.center.report.dto.expense.BudgetObjectInfoDto;
import com.yunxi.dg.base.center.report.dto.expense.constant.BudgetTypeEnum;
import com.yunxi.dg.base.center.report.eo.ItemDgEo;
import com.yunxi.dg.base.center.report.eo.customer.DgCustomerAreaEo;
import com.yunxi.dg.base.center.report.eo.customer.DgCustomerEo;
import com.yunxi.dg.base.center.report.eo.item.BrandDgEo;
import com.yunxi.dg.base.center.report.eo.item.DirDgEo;
import com.yunxi.dg.base.center.report.eo.user.OrganizationEo;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class BudgetUtils {
    @Resource
    private IUsOrganizationDomain organizationDomain;
    @Resource
    private IDgCustomerDomain dgCustomerDomain;
    @Resource
    private IBrandDgDomain brandDgDomain;
    @Resource
    private IDirDgDomain dirDgDomain;
    @Resource
    private IItemDgDomain itemDgDomain;
    @Resource
    private IDgCustomerAreaDomain dgCustomerAreaDomain;

    public void dealObjectName(List<BudgetObjectInfoDto> list) {
        Map<Integer, List<BudgetObjectInfoDto>> map = list.stream().collect(Collectors.groupingBy(BudgetObjectInfoDto::getBudgetType));
        for (Map.Entry<Integer, List<BudgetObjectInfoDto>> entry : map.entrySet()) {
            Integer budgetType = entry.getKey();
            List<BudgetObjectInfoDto> childList = entry.getValue();
            List<Long> objectIds = childList.stream().map(BudgetObjectInfoDto::getObjectId).distinct().collect(Collectors.toList());
            this.setObjectInfo(childList, objectIds, budgetType);
        }
    }

    private void setObjectInfo(List<BudgetObjectInfoDto> list, List<Long> objectIds, Integer budgetType) {
        if (Objects.equals(BudgetTypeEnum.SEAL_ORG.getCode(), budgetType)) {
            LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
            lqw.select(new SFunction[]{OrganizationEo::getId, OrganizationEo::getCode, OrganizationEo::getName});
            lqw.in(OrganizationEo::getId, objectIds);
            List organizationEos = this.organizationDomain.getMapper().selectList((Wrapper)lqw);
            Map eoMap = organizationEos.stream().collect(Collectors.toMap(OrganizationEo::getId, Function.identity()));
            list.forEach(dto -> {
                OrganizationEo organizationEo = (OrganizationEo)eoMap.get(dto.getObjectId());
                if (Objects.nonNull(organizationEo)) {
                    dto.setObjectCode(organizationEo.getCode());
                    dto.setObjectName(organizationEo.getName());
                } else {
                    dto.setObjectName("\u7ec4\u7ec7\u540d\u79f0\u672a\u627e\u5230/\u6570\u636e\u4e0d\u540c\u6b65");
                }
            });
        } else if (Objects.equals(BudgetTypeEnum.CUSTOMER.getCode(), budgetType)) {
            LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
            lqw.select(new SFunction[]{BaseEo::getId, DgCustomerEo::getCode, DgCustomerEo::getName});
            lqw.in(BaseEo::getId, objectIds);
            List customerEos = this.dgCustomerDomain.getMapper().selectList((Wrapper)lqw);
            Map eoMap = customerEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
            list.forEach(dto -> {
                DgCustomerEo customerEo = (DgCustomerEo)eoMap.get(dto.getObjectId());
                if (Objects.nonNull(customerEo)) {
                    dto.setObjectCode(customerEo.getCode());
                    dto.setObjectName(customerEo.getName());
                } else {
                    dto.setObjectName("\u5ba2\u6237\u540d\u79f0\u672a\u627e\u5230/\u6570\u636e\u4e0d\u540c\u6b65");
                }
            });
        } else if (Objects.equals(BudgetTypeEnum.BRAND.getCode(), budgetType)) {
            LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
            lqw.select(new SFunction[]{BaseEo::getId, BrandDgEo::getCode, BrandDgEo::getName});
            lqw.in(BaseEo::getId, objectIds);
            List brandEos = this.brandDgDomain.getMapper().selectList((Wrapper)lqw);
            Map eoMap = brandEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
            list.forEach(dto -> {
                BrandDgEo brandDgEo = (BrandDgEo)eoMap.get(dto.getObjectId());
                if (Objects.nonNull(brandDgEo)) {
                    dto.setObjectCode(brandDgEo.getCode());
                    dto.setObjectName(brandDgEo.getName());
                } else {
                    dto.setObjectName("\u54c1\u724c\u540d\u79f0\u672a\u627e\u5230/\u6570\u636e\u4e0d\u540c\u6b65");
                }
            });
        } else if (Objects.equals(BudgetTypeEnum.DIR.getCode(), budgetType)) {
            LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
            lqw.select(new SFunction[]{BaseEo::getId, DirDgEo::getCode, DirDgEo::getName});
            lqw.in(BaseEo::getId, objectIds);
            List dirEos = this.dirDgDomain.getMapper().selectList((Wrapper)lqw);
            Map eoMap = dirEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
            list.forEach(dto -> {
                DirDgEo dirDgEo = (DirDgEo)eoMap.get(dto.getObjectId());
                if (Objects.nonNull(dirDgEo)) {
                    dto.setObjectCode(dirDgEo.getCode());
                    dto.setObjectName(dirDgEo.getName());
                } else {
                    dto.setObjectName("\u7c7b\u76ee\u540d\u79f0\u672a\u627e\u5230/\u6570\u636e\u4e0d\u540c\u6b65");
                }
            });
        } else if (Objects.equals(BudgetTypeEnum.ITEM.getCode(), budgetType)) {
            LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
            lqw.select(new SFunction[]{BaseEo::getId, ItemDgEo::getCode, ItemDgEo::getName});
            lqw.in(BaseEo::getId, objectIds);
            List itemEos = this.itemDgDomain.getMapper().selectList((Wrapper)lqw);
            Map eoMap = itemEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
            list.forEach(dto -> {
                ItemDgEo itemDgEo = (ItemDgEo)eoMap.get(dto.getObjectId());
                if (Objects.nonNull(itemDgEo)) {
                    dto.setObjectCode(itemDgEo.getCode());
                    dto.setObjectName(itemDgEo.getName());
                } else {
                    dto.setObjectName("\u5546\u54c1\u540d\u79f0\u672a\u627e\u5230/\u6570\u636e\u4e0d\u540c\u6b65");
                }
            });
        } else if (Objects.equals(BudgetTypeEnum.CUSTOMER_CATEGORY.getCode(), budgetType)) {
            LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
            lqw.select(new SFunction[]{BaseEo::getId, DgCustomerAreaEo::getCode, DgCustomerAreaEo::getName});
            lqw.in(BaseEo::getId, objectIds);
            List customerAreaEos = this.dgCustomerAreaDomain.getMapper().selectList((Wrapper)lqw);
            Map eoMap = customerAreaEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
            list.forEach(dto -> {
                DgCustomerAreaEo customerAreaEo = (DgCustomerAreaEo)eoMap.get(dto.getObjectId());
                if (Objects.nonNull(customerAreaEo)) {
                    dto.setObjectCode(customerAreaEo.getCode());
                    dto.setObjectName(customerAreaEo.getName());
                } else {
                    dto.setObjectName("\u4ea4\u6613\u4e1a\u52a1\u533a\u57df\u540d\u79f0\u672a\u627e\u5230/\u6570\u636e\u4e0d\u540c\u6b65");
                }
            });
        }
    }

    public static String getQuarterStrByQuarter(int quarter) {
        switch (quarter) {
            case 1: {
                return "\u7b2c\u4e00\u5b63\u5ea6";
            }
            case 2: {
                return "\u7b2c\u4e8c\u5b63\u5ea6";
            }
            case 3: {
                return "\u7b2c\u4e09\u5b63\u5ea6";
            }
            case 4: {
                return "\u7b2c\u56db\u5b63\u5ea6";
            }
        }
        return "";
    }

    public static String getQuarterStrByMonth(int month) {
        if (month < 4) {
            return "\u7b2c\u4e00\u5b63\u5ea6";
        }
        if (month < 7) {
            return "\u7b2c\u4e8c\u5b63\u5ea6";
        }
        if (month < 10) {
            return "\u7b2c\u4e09\u5b63\u5ea6";
        }
        return "\u7b2c\u56db\u5b63\u5ea6";
    }
}

