/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.expense.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.report.dao.das.expense.IActivityVerifyDas;
import com.yunxi.dg.base.center.report.dao.das.expense.IActivityVerifyFormDas;
import com.yunxi.dg.base.center.report.dao.das.expense.IActivityVerifyMaterialDas;
import com.yunxi.dg.base.center.report.dao.das.expense.IActivityVerifyPayDas;
import com.yunxi.dg.base.center.report.dao.das.expense.IActivityVerifyPayItemDas;
import com.yunxi.dg.base.center.report.domain.expense.IActivityCostDomain;
import com.yunxi.dg.base.center.report.domain.expense.IActivityVerifyDomain;
import com.yunxi.dg.base.center.report.dto.expense.ActivityVerifyDto;
import com.yunxi.dg.base.center.report.dto.expense.ActivityVerifyFormDto;
import com.yunxi.dg.base.center.report.dto.expense.ActivityVerifyMaterialDto;
import com.yunxi.dg.base.center.report.dto.expense.ActivityVerifyPayDto;
import com.yunxi.dg.base.center.report.dto.expense.ActivityVerifyPayItemDto;
import com.yunxi.dg.base.center.report.dto.expense.ActivityVerifyRecordDto;
import com.yunxi.dg.base.center.report.dto.expense.ActivityVerifyRecordQueryDto;
import com.yunxi.dg.base.center.report.dto.expense.constant.BudgetTypeEnum;
import com.yunxi.dg.base.center.report.eo.expense.ActivityCostEo;
import com.yunxi.dg.base.center.report.eo.expense.ActivityVerifyEo;
import com.yunxi.dg.base.center.report.eo.expense.ActivityVerifyPayEo;
import com.yunxi.dg.base.center.report.service.expense.BudgetUtils;
import com.yunxi.dg.base.center.report.service.expense.IActivityVerifyService;
import com.yunxi.dg.base.commons.utils.BeanCopyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ActivityVerifyService
implements IActivityVerifyService {
    @Resource
    private IActivityVerifyDomain activityVerifyDomain;
    @Resource
    private IActivityCostDomain activityCostDomain;
    @Resource
    private IActivityVerifyFormDas activityVerifyFormDas;
    @Resource
    private IActivityVerifyDas activityVerifyDas;
    @Resource
    private IActivityVerifyMaterialDas activityVerifyMaterialDas;
    @Resource
    private BudgetUtils budgetUtils;
    @Resource
    private IContext context;
    @Resource
    private IActivityVerifyPayDas activityVerifyPayDas;
    @Resource
    private IActivityVerifyPayItemDas activityVerifyPayItemDas;

    @Override
    public PageInfo<ActivityVerifyRecordDto> queryVerifyRecord(ActivityVerifyRecordQueryDto queryDto) {
        PageInfo pageInfo;
        List activityVerifyRecordDtoList;
        if (Objects.equals(queryDto.getSelfCreate(), 1)) {
            queryDto.setCreatePerson(this.context.userName());
        }
        if (StringUtils.isNotBlank((String)queryDto.getObjectName()) && Objects.isNull(queryDto.getBudgetType())) {
            queryDto.setBudgetType(BudgetTypeEnum.CUSTOMER.getCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)(activityVerifyRecordDtoList = (pageInfo = this.activityVerifyDomain.queryVerifyRecord(queryDto)).getList()))) {
            ArrayList list = Lists.newArrayList();
            list.addAll(activityVerifyRecordDtoList);
            this.budgetUtils.dealObjectName(list);
        }
        return pageInfo;
    }

    @Override
    public ActivityVerifyDto detail(Long id) {
        ActivityVerifyEo activityVerifyEo = (ActivityVerifyEo)this.activityVerifyDas.selectByPrimaryKey(id);
        if (Objects.isNull(activityVerifyEo)) {
            throw new BizException("\u6838\u9500\u660e\u7ec6ID\u65e0\u6548\uff0c\u627e\u4e0d\u5230\u6b64ID");
        }
        ActivityVerifyDto verifyDto = new ActivityVerifyDto();
        BeanCopyUtil.copyProperties((Object)activityVerifyEo, (Object)verifyDto);
        ActivityCostEo costEo = (ActivityCostEo)this.activityCostDomain.selectByPrimaryKey(verifyDto.getActivityCostId());
        verifyDto.setActivityCostType(costEo.getCategory());
        verifyDto.setActivityCostName(costEo.getName());
        verifyDto.setActivityCostCode(costEo.getCode());
        verifyDto.setBeginTime(costEo.getBeginTime());
        verifyDto.setEndTime(costEo.getEndTime());
        List formDtos = this.activityVerifyFormDas.queryByVerifyId(id);
        if (CollectionUtils.isNotEmpty((Collection)formDtos)) {
            ArrayList list = Lists.newArrayList();
            list.addAll(formDtos);
            this.budgetUtils.dealObjectName(list);
            verifyDto.setVerifyFormDtos(formDtos);
            List materialDtos = this.activityVerifyMaterialDas.queryByActivityVerifyId(id);
            if (CollectionUtils.isNotEmpty((Collection)materialDtos)) {
                Map<Long, List<ActivityVerifyMaterialDto>> verifyMaterialMap = materialDtos.stream().collect(Collectors.groupingBy(ActivityVerifyMaterialDto::getVerifyFormId));
                for (ActivityVerifyFormDto formDto : formDtos) {
                    formDto.setVerifyMaterialDtos(verifyMaterialMap.get(formDto.getId()));
                }
            }
            this.dealWithPayMethod(formDtos);
        }
        return verifyDto;
    }

    private void dealWithPayMethod(List<ActivityVerifyFormDto> formDtos) {
        ArrayList formIds = Lists.newArrayList();
        HashMap formDtoMap = Maps.newHashMap();
        for (ActivityVerifyFormDto r : formDtos) {
            formIds.add(r.getId());
            formDtoMap.put(r.getId(), r);
        }
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.in(ActivityVerifyPayEo::getVerifyFormId, (Collection)formIds);
        List verifyPayDtos = this.activityVerifyPayDas.queryByVerifyFormIds((List)formIds);
        if (CollectionUtils.isNotEmpty((Collection)verifyPayDtos)) {
            List verifyPayItemDtos;
            HashMap formMap = Maps.newHashMap();
            ArrayList payIds = Lists.newArrayList();
            HashMap payDtoMap = Maps.newHashMap();
            for (ActivityVerifyPayDto activityVerifyPayDto : verifyPayDtos) {
                if (Objects.equals(activityVerifyPayDto.getPayType(), 1)) {
                    payIds.add(activityVerifyPayDto.getId());
                }
                formMap.putIfAbsent(activityVerifyPayDto.getVerifyFormId(), Lists.newArrayList());
                ((List)formMap.get(activityVerifyPayDto.getVerifyFormId())).add(activityVerifyPayDto);
                payDtoMap.put(activityVerifyPayDto.getId(), activityVerifyPayDto);
            }
            for (Map.Entry entry : formMap.entrySet()) {
                ((ActivityVerifyFormDto)formDtoMap.get(entry.getKey())).setVerifyPayDtos((List)entry.getValue());
            }
            if (CollectionUtils.isNotEmpty((Collection)payIds) && CollectionUtils.isNotEmpty((Collection)(verifyPayItemDtos = this.activityVerifyPayItemDas.queryByVerifyPayIds((List)payIds)))) {
                Map<Long, List<ActivityVerifyPayItemDto>> map = verifyPayItemDtos.stream().collect(Collectors.groupingBy(ActivityVerifyPayItemDto::getVerifyPayId));
                for (Map.Entry<Long, List<ActivityVerifyPayItemDto>> row : map.entrySet()) {
                    ((ActivityVerifyPayDto)payDtoMap.get(row.getKey())).setVerifyPayItemDtos(row.getValue());
                }
            }
        }
    }
}

