/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.fetch.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.yunxi.dg.base.center.pulldata.dao.common.select.MultipartJoinSelectGeneric;
import com.yunxi.dg.base.center.pulldata.domain.entity.IPmsInventoryPostDetailDomain;
import com.yunxi.dg.base.center.pulldata.service.component.collect.ICollectDocumentDataService;
import com.yunxi.dg.base.center.pulldata.service.component.context.CollectDataInitContext;
import com.yunxi.dg.base.center.pulldata.service.component.fetch.DataFetchBo;
import com.yunxi.dg.base.center.pulldata.service.component.fetch.DataFetchStrategy;
import com.yunxi.dg.base.center.report.constants.reconciliation.InventoryReconciliationSourceEnum;
import com.yunxi.dg.base.center.report.domain.inventory.IDgOutResultOrderDomain;
import com.yunxi.dg.base.center.report.service.fetch.impl.AbstractDataFetchOverwriteStrategy;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class HyxDataFetchStrategy
extends AbstractDataFetchOverwriteStrategy
implements DataFetchStrategy {
    private static final Logger log = LoggerFactory.getLogger(HyxDataFetchStrategy.class);
    @Resource
    private ICollectDocumentDataService collectDocumentDataService;
    @Resource
    private IDgOutResultOrderDomain outResultOrderDomain;
    @Resource
    private IPmsInventoryPostDetailDomain domain;

    public CollectDataInitContext init(Date startOfDay, DateTime endOfDay, boolean queryInOutTime) {
        CollectDataInitContext context = new CollectDataInitContext();
        MultipartJoinSelectGeneric generic = new MultipartJoinSelectGeneric("cs_delivery_result_order", "m");
        generic.addField("m.document_no");
        generic.addField("m.relevance_no");
        generic.addField("m.business_type");
        generic.addField("m.jump_document_type");
        generic.addField("m.display_business_type");
        generic.addField("m.delivery_logic_warehouse_code");
        generic.addField("m.delivery_logic_warehouse_name");
        generic.addField("m.receive_logic_warehouse_code");
        generic.addField("m.receive_logic_warehouse_name");
        generic.addField("m.order_type");
        generic.addField("m.extension");
        generic.equalsWhere("m.dr", (Object)0);
        if (queryInOutTime) {
            List outResultOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.outResultOrderDomain.filter().ge((Object)"in_out_time", (Object)startOfDay)).le((Object)"in_out_time", (Object)endOfDay)).list();
            if (CollectionUtils.isNotEmpty((Collection)outResultOrderEos)) {
                generic.in("m.pre_order_no", outResultOrderEos.stream().map(e -> e.getDocumentNo()).distinct().collect(Collectors.toList()));
            } else {
                context = null;
            }
        } else {
            generic.greaterThanEqualWhere("m.biz_date", (Object)startOfDay);
            generic.lessThanEqualWhere("m.biz_date", (Object)endOfDay);
        }
        generic.equalsWhere("m.offset_type", (Object)"un_offset");
        log.info(JSON.toJSONString((Object)context));
        if (Objects.isNull(context)) {
            List eos = ((ExtQueryChainWrapper)this.domain.filter().eq((Object)"reconciliation_time", (Object)startOfDay)).list();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)eos)) {
                List ids = eos.stream().map(e -> e.getId()).collect(Collectors.toList());
                this.domain.getMapper().deleteBatchIds(ids);
            }
            return null;
        }
        generic.addLeftJoin("cs_transfer_order", "cto", "m.relevance_no = cto.transfer_order_no and  m.relevance_table_name = 'cs_transfer_order' AND cto.dr = 0");
        generic.addLeftJoin("in_plan_order", "ipo", "m.relevance_no = ipo.order_no AND ipo.dr = 0");
        generic.addLeftJoin("in_other_storage_order", "ioso", "m.relevance_no = ioso.storage_order_no and  m.relevance_table_name = 'in_other_storage_order' AND ioso.dr = 0");
        generic.addField("m.external_order_no");
        generic.addField("(case when m.business_type = 'SALE_OUT_ORDER' then ipo.order_status when m.relevance_table_name = 'cs_transfer_order' then cto.order_status when m.relevance_table_name = 'in_plan_order' then ipo.order_status when m.relevance_table_name = 'in_other_storage_order' then ioso.order_status end) as order_status");
        generic.orderBy("m.id", "desc");
        context.setInventoryReconciliationTime(startOfDay);
        context.setExtensionAssemblyFunction(data -> {
            JSONObject jsonObject = new JSONObject();
            String externalOrderNo = (String)data.get("external_order_no");
            String documentNo = (String)data.get("document_no");
            String extension = (String)data.get("extension");
            jsonObject.put("externalOrderNo", (Object)StrUtil.nullToDefault((CharSequence)externalOrderNo, (String)documentNo));
            jsonObject.put("erpPurchaseOrderNo", (Object)StrUtil.nullToDefault((CharSequence)externalOrderNo, (String)documentNo));
            jsonObject.put("documentNo", (Object)documentNo);
            jsonObject.put("extension", (Object)extension);
            return jsonObject;
        });
        context.setGeneric(generic);
        return context;
    }

    @Override
    public void doFetchAndSaveData(DataFetchBo dataFetchBo) {
        DateTime endOfDay;
        DateTime startOfDay = DateUtil.beginOfDay((Date)dataFetchBo.getReconciliationDate());
        CollectDataInitContext context = this.init((Date)startOfDay, endOfDay = DateUtil.endOfDay((Date)dataFetchBo.getReconciliationDate()), InventoryReconciliationSourceEnum.WMS.getCode().equals(dataFetchBo.getExtension()));
        if (Objects.nonNull(context)) {
            this.collectDocumentDataService.collectAndSaveDataToSnapshot(context);
        }
        if (InventoryReconciliationSourceEnum.WMS.getCode().equals(dataFetchBo.getExtension())) {
            log.info("\u5bf9\u8d26\u6765\u6e90wms\u7684PENDING_INSPECTION_TO_QUALIFIED\u7c7b\u578b\u6ca1\u6709inOutTime\u503c\uff0c\u9700\u8981\u6839\u636ebizTime\u91cd\u65b0\u67e5\u4e00\u904d");
            context = this.init((Date)startOfDay, endOfDay, false);
            context.getGeneric().equalsWhere("m.display_business_type", (Object)"PENDING_INSPECTION_TO_QUALIFIED");
            context.setDeleteOldData(Boolean.valueOf(false));
            this.collectDocumentDataService.collectAndSaveDataToSnapshot(context);
        }
    }

    public String type() {
        return InventoryReconciliationSourceEnum.HYX.getCode();
    }
}

