/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.finance.impl;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.report.dao.das.IDgKeepAccountsDetailDas;
import com.yunxi.dg.base.center.report.dto.account.constant.VoucherTypeEnum;
import com.yunxi.dg.base.center.report.eo.DgKeepAccountsDetailEo;
import com.yunxi.dg.base.center.report.service.finance.IKeepAccountingService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class KeepAccountingServiceImpl
implements IKeepAccountingService {
    private static final Logger log = LoggerFactory.getLogger(KeepAccountingServiceImpl.class);
    @Resource
    private IDgKeepAccountsDetailDas keepAccountsDetailDas;
    protected static final Cache<String, String> DATA_CACHE = Caffeine.newBuilder().initialCapacity(500).maximumSize(3000L).expireAfterWrite(1440L, TimeUnit.MINUTES).build();

    @Override
    public Map<String, String> getAccountingOrderNos(List<String> orderNos) {
        String voucherKey1;
        HashMap accountingOrderMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty(orderNos)) {
            return accountingOrderMap;
        }
        for (String string : orderNos) {
            String cachedResult1;
            String voucherKey = string + "-" + VoucherTypeEnum.DELIVERY.getCode();
            String cachedResult = (String)DATA_CACHE.getIfPresent((Object)voucherKey);
            if (cachedResult != null) {
                accountingOrderMap.put(voucherKey, cachedResult);
            }
            if ((cachedResult1 = (String)DATA_CACHE.getIfPresent((Object)(voucherKey1 = string + "-" + VoucherTypeEnum.INVOICE.getCode()))) == null) continue;
            accountingOrderMap.put(voucherKey1, cachedResult1);
        }
        try {
            HashSet<String> missingOrderNoSet = new HashSet<String>();
            for (String orderNo : orderNos) {
                String voucherKey = orderNo + "-" + VoucherTypeEnum.INVOICE.getCode();
                if (!accountingOrderMap.containsKey(voucherKey)) {
                    missingOrderNoSet.add(orderNo);
                }
                if (accountingOrderMap.containsKey(voucherKey1 = orderNo + "-" + VoucherTypeEnum.DELIVERY.getCode())) continue;
                missingOrderNoSet.add(orderNo);
            }
            if (!missingOrderNoSet.isEmpty()) {
                ArrayList arrayList = new ArrayList(missingOrderNoSet);
                int size = arrayList.size();
                for (int i = 0; i < size; i += 500) {
                    int end = Math.min(i + 500, size);
                    List accountsDetailEos = ((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().in((Object)"order_no", arrayList.subList(i, end))).list();
                    if (!CollectionUtils.isNotEmpty((Collection)accountsDetailEos)) continue;
                    for (DgKeepAccountsDetailEo v : accountsDetailEos) {
                        if (!Objects.equals(v.getAccountingResult(), "ACCOUNT_SUCCESS")) continue;
                        String key = v.getOrderNo() + "-" + v.getVoucherType();
                        String result = v.getAccountingResult();
                        DATA_CACHE.put((Object)key, (Object)result);
                        accountingOrderMap.put(key, result);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u8bb0\u8d26\u4fe1\u606f\u5f02\u5e38\uff1a{},{}", (Object)e, (Object)Throwables.getStackTraceAsString((Throwable)e));
        }
        return accountingOrderMap;
    }
}

