/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.assemble;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.domain.entity.IOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IAssemblyDisassemblyOrderDetailDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IAssemblyDisassemblyOrderDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgOutNoticeOrderDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.report.dto.inventory.AssemblyDisassemblyOrderDetailRespDto;
import com.yunxi.dg.base.center.report.dto.inventory.AssemblyDisassemblyOrderDto;
import com.yunxi.dg.base.center.report.dto.inventory.AssemblyDisassemblyOrderDtoExtension;
import com.yunxi.dg.base.center.report.dto.inventory.AssemblyDisassemblyOrderItemComboRespDto;
import com.yunxi.dg.base.center.report.dto.inventory.AssemblyDisassemblyOrderItemRespDto;
import com.yunxi.dg.base.center.report.dto.inventory.AssemblyDisassemblyOrderQueryDto;
import com.yunxi.dg.base.center.report.eo.OutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.report.eo.inventory.AssemblyDisassemblyOrderDetailEo;
import com.yunxi.dg.base.center.report.eo.inventory.AssemblyDisassemblyOrderEo;
import com.yunxi.dg.base.center.report.eo.inventory.DgOutNoticeOrderEo;
import com.yunxi.dg.base.center.report.eo.inventory.DgPhysicsWarehouseEo;
import com.yunxi.dg.base.center.report.service.impl.inventory.query.IReportDataSearchService;
import com.yunxi.dg.base.center.report.service.inventory.IAssemblyDisassemblyOrderService;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class AssemblyDisassemblyOrderServiceImpl
extends BaseServiceImpl<AssemblyDisassemblyOrderDto, AssemblyDisassemblyOrderEo, IAssemblyDisassemblyOrderDomain>
implements IAssemblyDisassemblyOrderService {
    private static final Logger log = LoggerFactory.getLogger(AssemblyDisassemblyOrderServiceImpl.class);
    @Resource
    private IDgOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    private IOutNoticeOrderDetailDomain outNoticeOrderDetailDomain;
    @Resource
    private IAssemblyDisassemblyOrderDetailDomain assemblyDisassemblyOrderDetailDomain;
    @Resource
    private IDgPhysicsWarehouseDomain physicsWarehouseDomain;
    @Resource(name="assemblyDisassemblyReportDataSearchService")
    private IReportDataSearchService reportDataSearchService;

    public AssemblyDisassemblyOrderServiceImpl(IAssemblyDisassemblyOrderDomain iAssemblyDisassemblyOrderDomain) {
        super((IBaseDomain)iAssemblyDisassemblyOrderDomain);
    }

    @Override
    public PageInfo<AssemblyDisassemblyOrderDto> queryPage(AssemblyDisassemblyOrderQueryDto queryDto) {
        PageInfo pageInfo = ((IAssemblyDisassemblyOrderDomain)this.domain).queryPage(queryDto);
        return this.assemblyRespPageData((PageInfo<AssemblyDisassemblyOrderDto>)pageInfo);
    }

    @Override
    public PageInfo<AssemblyDisassemblyOrderItemComboRespDto> queryByItemPage(AssemblyDisassemblyOrderQueryDto queryDto) {
        queryDto.setType(Integer.valueOf(1));
        PageHelper.startPage((int)queryDto.getPageNum(), (int)queryDto.getPageSize());
        PageInfo pageInfo = this.reportDataSearchService.queryList(queryDto);
        return this.assemblyRespData(pageInfo);
    }

    public PageInfo<AssemblyDisassemblyOrderDto> assemblyRespPageData(PageInfo<AssemblyDisassemblyOrderDto> pageInfo) {
        if (pageInfo == null || CollUtil.isEmpty((Collection)pageInfo.getList())) {
            return new PageInfo();
        }
        HashMap cacheMap = new HashMap();
        pageInfo.getList().forEach(x -> {
            x.setShowProcess((Boolean)cacheMap.get(x.getLogicWarehouseCode()));
            String extension = x.getExtension();
            AssemblyDisassemblyOrderDtoExtension orderDtoExtension = null;
            if (StringUtils.isNotBlank((CharSequence)extension) && Objects.nonNull(orderDtoExtension = (AssemblyDisassemblyOrderDtoExtension)JSONObject.parseObject((String)extension, AssemblyDisassemblyOrderDtoExtension.class))) {
                x.setAuditRemark(orderDtoExtension.getAuditRemark());
            }
        });
        return pageInfo;
    }

    public PageInfo<AssemblyDisassemblyOrderItemComboRespDto> assemblyRespData(PageInfo<AssemblyDisassemblyOrderDetailRespDto> pageInfo) {
        if (pageInfo == null || CollUtil.isEmpty((Collection)pageInfo.getList())) {
            return new PageInfo();
        }
        Set<String> orderNos = pageInfo.getList().stream().map(AssemblyDisassemblyOrderDto::getOrderNo).collect(Collectors.toSet());
        Map<String, List<AssemblyDisassemblyOrderDetailEo>> orderNo2packListMap = this.assemblyDisassemblyOrderDetailDomain.queryPackListByOrderNos(new ArrayList(orderNos)).stream().collect(Collectors.groupingBy(AssemblyDisassemblyOrderDetailEo::getOrderNo));
        Set warehouseCodes = pageInfo.getList().stream().map(AssemblyDisassemblyOrderDto::getPhysicsWarehouseCode).collect(Collectors.toSet());
        List physicsWarehouseEos = Optional.ofNullable(((ExtQueryChainWrapper)this.physicsWarehouseDomain.filter().in((Object)"warehouse_code", warehouseCodes)).list()).orElse(new ArrayList());
        Map<String, Boolean> code2WmsMap = physicsWarehouseEos.stream().collect(Collectors.toMap(DgPhysicsWarehouseEo::getWarehouseCode, x -> ObjectUtil.equals((Object)x.getInterconnectionFlag(), (Object)1), (k1, k2) -> k1));
        Map<String, BigDecimal> processingQuantityOfTheDocumentMap = this.getProcessingQuantityOfTheDocument(orderNos);
        List list = pageInfo.getList().stream().map(respDto -> {
            List detailEoList;
            AssemblyDisassemblyOrderItemComboRespDto comboRespDto = new AssemblyDisassemblyOrderItemComboRespDto();
            BeanUtils.copyProperties((Object)respDto, (Object)comboRespDto);
            AssemblyDisassemblyOrderItemRespDto resp = new AssemblyDisassemblyOrderItemRespDto();
            BeanUtils.copyProperties((Object)respDto, (Object)resp);
            String detailKey = this.genKey(respDto.getOrderNo(), resp.getSkuCode(), 1);
            if (processingQuantityOfTheDocumentMap.containsKey(detailKey)) {
                resp.setActualQuantity(Integer.valueOf(((BigDecimal)processingQuantityOfTheDocumentMap.get(detailKey)).intValueExact()));
            }
            comboRespDto.setDetail(resp);
            if (orderNo2packListMap.containsKey(respDto.getOrderNo()) && !CollUtil.isEmpty((Collection)(detailEoList = (List)orderNo2packListMap.get(respDto.getOrderNo())))) {
                AssemblyDisassemblyOrderItemRespDto packResp = new AssemblyDisassemblyOrderItemRespDto();
                BeanUtils.copyProperties(detailEoList.get(0), (Object)packResp, (String[])new String[]{"mixtureRatio"});
                packResp.setPlanQuantity(((AssemblyDisassemblyOrderDetailEo)detailEoList.get(0)).getQuantity());
                String key = this.genKey(respDto.getOrderNo(), packResp.getSkuCode(), 0);
                if (processingQuantityOfTheDocumentMap.containsKey(key)) {
                    packResp.setActualQuantity(Integer.valueOf(((BigDecimal)processingQuantityOfTheDocumentMap.get(key)).intValueExact()));
                }
                comboRespDto.setPack(packResp);
            }
            String extension = respDto.getExtension();
            AssemblyDisassemblyOrderDtoExtension orderDtoExtension = null;
            if (StringUtils.isNotBlank((CharSequence)extension) && Objects.nonNull(orderDtoExtension = (AssemblyDisassemblyOrderDtoExtension)JSONObject.parseObject((String)extension, AssemblyDisassemblyOrderDtoExtension.class))) {
                comboRespDto.setAuditRemark(orderDtoExtension.getAuditRemark());
            }
            comboRespDto.setShowProcess(Boolean.valueOf(code2WmsMap.getOrDefault(respDto.getPhysicsWarehouseCode(), true) == false));
            return comboRespDto;
        }).collect(Collectors.toList());
        PageInfo pageInfoResult = new PageInfo();
        BeanUtils.copyProperties(pageInfo, (Object)pageInfoResult, (String[])new String[]{"list", "navigatepageNums"});
        pageInfoResult.setList(list);
        return pageInfoResult;
    }

    public String genKey(String relevanceNo, String skuCode, Integer packType) {
        return relevanceNo + '@' + skuCode + '@' + packType;
    }

    public Map<String, BigDecimal> getProcessingQuantityOfTheDocument(Set<String> orderNos) {
        HashMap<String, BigDecimal> code2DoneQuantityMap = new HashMap<String, BigDecimal>();
        List inOutNoticeOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().in((Object)"relevance_no", orderNos)).eq((Object)"order_type", (Object)"assembly_disassembly")).notIn((Object)"order_status", new Object[]{"ono_cancel", "ino_cancel"})).list();
        if (CollectionUtils.isNotEmpty((Collection)inOutNoticeOrderEos)) {
            Set documentCodes = inOutNoticeOrderEos.stream().map(DgOutNoticeOrderEo::getDocumentNo).collect(Collectors.toSet());
            code2DoneQuantityMap.putAll(((ExtQueryChainWrapper)this.outNoticeOrderDetailDomain.filter().in((Object)"document_no", documentCodes)).list().stream().collect(Collectors.groupingBy(x -> this.genKey(x.getRelevanceNo(), x.getSkuCode(), x.getPackType()), Collectors.mapping(OutNoticeOrderDetailEo::getDoneQuantity, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add)))));
        }
        return code2DoneQuantityMap;
    }
}

