/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.customer.tob;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.domain.customer.IDgCsCustomerCompanyAuditDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgCsOrgCustomerRelationAuditDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgCsOrgCustomerRelationDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgCsRRelationDepartmentDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgCsRRelationEnterpriseDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgCsRRelationSalesmanDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgCsRRelationShopDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgCustomerAreaDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgCustomerDomain;
import com.yunxi.dg.base.center.report.domain.entity.IDgShopDomain;
import com.yunxi.dg.base.center.report.domain.user.IEmployeeDomain;
import com.yunxi.dg.base.center.report.domain.user.IUsOrganizationDomain;
import com.yunxi.dg.base.center.report.dto.customer.entity.CsOrgCustomerRelationAuditDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.CsOrgCustomerRelationAuditPageReqDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.CsOrganizationPageRespDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.CsRRelationSalesmanDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.CsRRelationShopDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.DgBusinessAreaLevelDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.DgCsRRelationDepartmentDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.DgOrganizationLevelDto;
import com.yunxi.dg.base.center.report.dto.customer.request.CustomerTransactionStatusCountQueryDto;
import com.yunxi.dg.base.center.report.dto.customer.request.TransactionRelationStatusCountQueryDto;
import com.yunxi.dg.base.center.report.dto.customer.response.CsOrgCustomerRelationCountRespDto;
import com.yunxi.dg.base.center.report.dto.customer.response.DgCustomerInfoCountRespDto;
import com.yunxi.dg.base.center.report.dto.shop.request.DgShopQueryReqDto;
import com.yunxi.dg.base.center.report.dto.shop.response.DgShopRespDto;
import com.yunxi.dg.base.center.report.enums.DgCustomerBusinessTypeEnum;
import com.yunxi.dg.base.center.report.eo.EmployeeEo;
import com.yunxi.dg.base.center.report.eo.customer.DgCsRRelationDepartmentEo;
import com.yunxi.dg.base.center.report.eo.customer.DgCsRRelationEnterpriseEo;
import com.yunxi.dg.base.center.report.eo.customer.DgCsRRelationShopEo;
import com.yunxi.dg.base.center.report.eo.customer.DgCustomerAreaEo;
import com.yunxi.dg.base.center.report.eo.customer.DgCustomerCompanyAuditEo;
import com.yunxi.dg.base.center.report.eo.customer.DgRRelationSalesmanEo;
import com.yunxi.dg.base.center.report.service.customer.tob.IDgOrgCustomerRelationAuditService;
import com.yunxi.dg.base.center.report.service.customer.tob.IDgOrgCustomerRelationService;
import com.yunxi.dg.base.center.report.utils.RequestUtil;
import com.yunxi.dg.base.commons.dto.BaseDto;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class DgOrgCustomerRelationAuditServiceImpl
implements IDgOrgCustomerRelationAuditService {
    @Resource
    private IDgCsOrgCustomerRelationAuditDomain dgCsOrgCustomerRelationAuditDomain;
    @Resource
    private IDgCsRRelationDepartmentDomain dgCsRRelationDepartmentDomain;
    @Resource
    private IDgCsRRelationSalesmanDomain dgCsRRelationSalesmanDomain;
    @Resource
    private IDgCsRRelationEnterpriseDomain dgCsRRelationEnterpriseDomain;
    @Resource
    private IDgCsRRelationShopDomain dgCsRRelationShopDomain;
    @Resource
    private IDgOrgCustomerRelationService iDgOrgCustomerRelationService;
    @Resource
    private IEmployeeDomain iEmployeeDomain;
    @Resource
    private IDgShopDomain iDgShopDomain;
    @Resource
    private IDgCsOrgCustomerRelationDomain iDgCsOrgCustomerRelationDomain;
    @Resource
    private IDgCsCustomerCompanyAuditDomain iDgCsCustomerCompanyAuditDomain;
    @Resource
    private IDgCustomerAreaDomain iDgCustomerAreaDomain;
    @Resource
    private IUsOrganizationDomain iUsOrganizationDomain;
    @Resource
    private IDgCustomerDomain iDgCustomerDomain;

    @Override
    public PageInfo<CsOrgCustomerRelationAuditDto> queryTobCustomerRelationPage(CsOrgCustomerRelationAuditPageReqDto reqDto) {
        PageInfo pageInfo = new PageInfo();
        pageInfo = this.dgCsOrgCustomerRelationAuditDomain.queryPage(reqDto, Arrays.asList(DgCustomerBusinessTypeEnum.TYPE_CTJX.getType()));
        this.setRRelationDepartmentAndSalesman(pageInfo.getList());
        return pageInfo;
    }

    @Override
    public RestResponse<CsOrgCustomerRelationCountRespDto> queryApplyStatusCount(TransactionRelationStatusCountQueryDto queryDto) {
        CsOrgCustomerRelationCountRespDto countRespDto = new CsOrgCustomerRelationCountRespDto();
        Map auditMap = this.dgCsOrgCustomerRelationAuditDomain.queryGroupByStatusCount(queryDto, Arrays.asList(DgCustomerBusinessTypeEnum.TYPE_CTJX.getType()));
        countRespDto.setAuditCount(auditMap.getOrDefault(1, 0));
        countRespDto.setAuditPassCount(auditMap.getOrDefault(2, 0));
        countRespDto.setAuditFailCount(auditMap.getOrDefault(3, 0));
        countRespDto.setTemporaryStorageCount(auditMap.getOrDefault(6, 0));
        countRespDto.setExitCount(auditMap.getOrDefault(7, 0));
        List<Long> areaIds = this.iDgOrgCustomerRelationService.getChildByAreaIds(queryDto.getAreaIds());
        queryDto.setAreaIds(areaIds);
        Map map = this.iDgCsOrgCustomerRelationDomain.queryGroupByStatusCount(queryDto, Arrays.asList(DgCustomerBusinessTypeEnum.TYPE_CTJX.getType()));
        countRespDto.setEnableCount(map.getOrDefault(4, 0));
        countRespDto.setForbiddenCount(map.getOrDefault(5, 0));
        countRespDto.setAllCount(Integer.valueOf(countRespDto.getEnableCount() + countRespDto.getForbiddenCount()));
        return new RestResponse((Object)countRespDto);
    }

    @Override
    public RestResponse<DgCustomerInfoCountRespDto> queryCustomerStatusCount(CustomerTransactionStatusCountQueryDto queryDto) {
        Map<Integer, Long> count;
        DgCustomerInfoCountRespDto respDto = new DgCustomerInfoCountRespDto();
        ExtQueryChainWrapper filter = this.iDgCsCustomerCompanyAuditDomain.filter();
        this.setSqlFilters(queryDto, (ExtQueryChainWrapper<DgCustomerCompanyAuditEo>)filter);
        PageInfo page = filter.page(Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
        if (CollectionUtils.isNotEmpty((Collection)page.getList()) && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(count = page.getList().stream().filter(Objects::nonNull).filter(eo -> Objects.nonNull(eo.getStatus())).collect(Collectors.groupingBy(DgCustomerCompanyAuditEo::getStatus, Collectors.counting())))) {
            respDto.setAuditCount(Integer.valueOf(count.getOrDefault(1, 0L).intValue()));
            respDto.setPassCount(Integer.valueOf(count.getOrDefault(2, 0L).intValue()));
            respDto.setRejectCount(Integer.valueOf(count.getOrDefault(3, 0L).intValue()));
            respDto.setDraftCount(Integer.valueOf(count.getOrDefault(4, 0L).intValue()));
        }
        Map countMap = this.iDgCustomerDomain.queryGroupByStatusCount(queryDto, Arrays.asList(DgCustomerBusinessTypeEnum.TYPE_CTJX.getType()));
        respDto.setCooperationCount(countMap.getOrDefault(1, 0));
        respDto.setFrozenCount(countMap.getOrDefault(2, 0));
        respDto.setExitCount(countMap.getOrDefault(3, 0));
        return new RestResponse((Object)respDto);
    }

    private void setRRelationDepartmentAndSalesman(List<CsOrgCustomerRelationAuditDto> list) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(list)) {
            return;
        }
        List relationAuditIds = list.stream().map(CsOrgCustomerRelationAuditDto::getId).collect(Collectors.toList());
        Map<Long, Long> departmentIdOrgIdMap = list.stream().collect(Collectors.toMap(CsOrgCustomerRelationAuditDto::getDepartmentId, CsOrgCustomerRelationAuditDto::getOrganizationId, (k1, k2) -> k1));
        Map<Long, List<DgCsRRelationDepartmentEo>> rRelationDepartmentMap = ((List)Optional.ofNullable(this.dgCsRRelationDepartmentDomain.selectList((LambdaQueryWrapper)Wrappers.lambdaQuery(DgCsRRelationDepartmentEo.class).in(DgCsRRelationDepartmentEo::getAuditId, relationAuditIds))).orElse(new ArrayList())).stream().collect(Collectors.groupingBy(DgCsRRelationDepartmentEo::getAuditId));
        List rRelationSalesmanEos = Optional.ofNullable(this.dgCsRRelationSalesmanDomain.selectList((LambdaQueryWrapper)Wrappers.lambdaQuery(DgRRelationSalesmanEo.class).in(DgRRelationSalesmanEo::getAuditId, relationAuditIds))).orElse(new ArrayList());
        Map<Long, List<DgRRelationSalesmanEo>> rRelationSalesmanEoMap = rRelationSalesmanEos.stream().collect(Collectors.groupingBy(DgRRelationSalesmanEo::getAuditId));
        List salesmanIdList = rRelationSalesmanEos.stream().map(DgRRelationSalesmanEo::getSalesmanId).collect(Collectors.toList());
        Map employeeEoMap = ((List)Optional.ofNullable(this.iEmployeeDomain.selectList((LambdaQueryWrapper)Wrappers.lambdaQuery(EmployeeEo.class).in(com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(salesmanIdList), BaseEo::getId, salesmanIdList))).orElse(new ArrayList())).stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k1));
        List rRelationShopEos = Optional.ofNullable(this.dgCsRRelationShopDomain.selectList((LambdaQueryWrapper)Wrappers.lambdaQuery(DgCsRRelationShopEo.class).in(DgCsRRelationShopEo::getAuditId, relationAuditIds))).orElse(new ArrayList());
        Map<Long, List<DgCsRRelationShopEo>> rRelationShopEoMap = rRelationShopEos.stream().collect(Collectors.groupingBy(DgCsRRelationShopEo::getAuditId));
        DgShopQueryReqDto queryReqDto = new DgShopQueryReqDto();
        queryReqDto.setIdList(rRelationShopEos.stream().map(DgCsRRelationShopEo::getShopId).collect(Collectors.toList()));
        Map dgShopRespDtoMap = ((List)Optional.ofNullable(this.iDgShopDomain.listShopByCondition(queryReqDto)).orElse(new ArrayList())).stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (k1, k2) -> k1));
        Map<Long, List<DgCsRRelationEnterpriseEo>> rRelationEnterpriseEoMap = ((List)Optional.ofNullable(this.dgCsRRelationEnterpriseDomain.selectList((LambdaQueryWrapper)Wrappers.lambdaQuery(DgCsRRelationEnterpriseEo.class).in(DgCsRRelationEnterpriseEo::getAuditId, relationAuditIds))).orElse(new ArrayList())).stream().collect(Collectors.groupingBy(DgCsRRelationEnterpriseEo::getAuditId));
        Map<Long, List<DgOrganizationLevelDto>> departmentLevelMap = this.iDgOrgCustomerRelationService.mapDepartmentLevel(departmentIdOrgIdMap);
        Map<Long, List<DgBusinessAreaLevelDto>> areaLevelMap = this.iDgOrgCustomerRelationService.mapAreaLevel(list.stream().map(CsOrgCustomerRelationAuditDto::getAreaId).collect(Collectors.toList()));
        list.forEach(o -> {
            o.setDepartmentList(BeanUtil.copyToList((Collection)((Collection)rRelationDepartmentMap.get(o.getId())), DgCsRRelationDepartmentDto.class));
            o.setSalesmanIdList(((List)Optional.ofNullable(rRelationSalesmanEoMap.get(o.getId())).orElse(new ArrayList())).stream().map(DgRRelationSalesmanEo::getSalesmanId).collect(Collectors.toList()));
            o.setSalesmanList(((List)Optional.ofNullable(rRelationSalesmanEoMap.get(o.getId())).orElse(new ArrayList())).stream().map(e -> {
                EmployeeEo employeeEo = (EmployeeEo)employeeEoMap.get(e.getSalesmanId());
                if (Objects.isNull(employeeEo)) {
                    return new CsRRelationSalesmanDto();
                }
                CsRRelationSalesmanDto salesmanDto = new CsRRelationSalesmanDto();
                salesmanDto.setSalesmanId(employeeEo.getId());
                salesmanDto.setSalesmanCode(employeeEo.getEmployeeNo());
                salesmanDto.setSalesmanName(employeeEo.getName());
                salesmanDto.setPosition(e.getPosition());
                return salesmanDto;
            }).collect(Collectors.toList()));
            o.setEnterpriseIdList(((List)Optional.ofNullable(rRelationEnterpriseEoMap.get(o.getId())).orElse(new ArrayList())).stream().map(DgCsRRelationEnterpriseEo::getEnterpriseId).collect(Collectors.toList()));
            List dgCsRRelationShopEos = Optional.ofNullable(rRelationShopEoMap.get(o.getId())).orElse(new ArrayList());
            o.setShopIdList(dgCsRRelationShopEos.stream().map(DgCsRRelationShopEo::getShopId).collect(Collectors.toList()));
            o.setShopList(dgCsRRelationShopEos.stream().map(e -> {
                DgShopRespDto shopRespDto = (DgShopRespDto)dgShopRespDtoMap.get(e.getShopId());
                CsRRelationShopDto shopDto = new CsRRelationShopDto();
                if (Objects.isNull(shopRespDto)) {
                    return shopDto;
                }
                shopDto.setShopId(e.getShopId());
                shopDto.setShopCode(shopRespDto.getStoreCode());
                shopDto.setShopName(shopRespDto.getStoreName());
                return shopDto;
            }).collect(Collectors.toList()));
            o.setCustomerTypeId(com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)dgCsRRelationShopEos) ? null : ((DgCsRRelationShopEo)dgCsRRelationShopEos.get(0)).getCustomerTypeId());
            o.setDepartmentLevelList(Objects.isNull(o.getDepartmentId()) ? Collections.emptyList() : (List)departmentLevelMap.get(o.getDepartmentId()));
            o.setBusinessAreaLevelList(Objects.isNull(o.getAreaId()) ? null : (List)areaLevelMap.get(o.getAreaId()));
        });
    }

    private void setSqlFilters(CustomerTransactionStatusCountQueryDto reqDto, ExtQueryChainWrapper<DgCustomerCompanyAuditEo> filter) {
        if (Objects.nonNull(reqDto.getCustomerType())) {
            filter.eq((Object)"customer_type", (Object)reqDto.getCustomerType());
        }
        if (StrUtil.isNotBlank((CharSequence)reqDto.getApplyCode())) {
            filter.like((Object)"apply_code", (Object)reqDto.getApplyCode());
        }
        if (StrUtil.isNotBlank((CharSequence)reqDto.getCreditCode())) {
            filter.like((Object)"credit_code", (Object)reqDto.getCreditCode());
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)reqDto.getStatusList())) {
            filter.in((Object)"status", (Collection)reqDto.getStatusList());
        }
        if (StrUtil.isNotBlank((CharSequence)reqDto.getCreatePerson())) {
            filter.like((Object)"create_person", (Object)reqDto.getCreatePerson());
        }
        if (StrUtil.isNotBlank((CharSequence)reqDto.getCompanyName())) {
            filter.like((Object)"company_content", (Object)reqDto.getCompanyName());
        }
        if (reqDto.getOperationType() != null) {
            filter.eq((Object)"operation_type", (Object)reqDto.getOperationType());
        }
        if (reqDto.getCustomerCode() != null) {
            filter.like((Object)"customer_code", (Object)reqDto.getCustomerCode());
        }
        if (reqDto.getRootOrganizationId() != null) {
            filter.eq((Object)"organization_id", (Object)reqDto.getRootOrganizationId());
        } else {
            String rootOrganizationId = RequestUtil.getHeader("Root-Organization-Id");
            filter.eq(StrUtil.isNotBlank((CharSequence)rootOrganizationId), (Object)"organization_id", (Object)rootOrganizationId);
        }
        if (StrUtil.isNotBlank((CharSequence)reqDto.getCompanyName())) {
            filter.like((Object)"company_name", (Object)reqDto.getCompanyName());
        }
        if (StrUtil.isNotBlank((CharSequence)reqDto.getParentCustomerName())) {
            filter.like((Object)"customer_content", (Object)("\"parentCustomerName\":\"%" + reqDto.getParentCustomerName() + "%\""));
        }
        if (StrUtil.isNotBlank((CharSequence)reqDto.getCustomerName())) {
            filter.like((Object)"customer_content", (Object)("\"customerName\":\"%" + reqDto.getCustomerName() + "%\""));
        }
        if (StrUtil.isNotBlank((CharSequence)reqDto.getParentCustomerExternalCode())) {
            filter.like((Object)"customer_content", (Object)("\"parentCustomerExternalCode\":\"%" + reqDto.getParentCustomerExternalCode() + "%\""));
        }
        filter.orderByDesc((Object)"create_time");
    }

    private void setCondition(CustomerTransactionStatusCountQueryDto reqDto) {
        List<Integer> businessType = Arrays.asList(DgCustomerBusinessTypeEnum.TYPE_CTJX.getType());
        if (reqDto.getRootOrganizationId() != null && StrUtil.isNotBlank((CharSequence)RequestUtil.getHeader("Root-Organization-Id"))) {
            String rootOrgId = RequestUtil.getHeader("Root-Organization-Id");
            reqDto.setRootOrganizationId(Long.valueOf(rootOrgId));
        }
        ArrayList<Long> departmentIdList = new ArrayList<Long>();
        if (Objects.nonNull(reqDto.getDepartmentId())) {
            departmentIdList.add(reqDto.getDepartmentId());
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)reqDto.getDepartmentIdList())) {
            departmentIdList.addAll(reqDto.getDepartmentIdList());
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(departmentIdList)) {
            ArrayList organizationDtoList = new ArrayList();
            this.iUsOrganizationDomain.listChildOrgByOrgIdAndFuncType(departmentIdList, "sales", organizationDtoList);
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(organizationDtoList)) {
                reqDto.setDepartmentIdList(organizationDtoList.stream().map(CsOrganizationPageRespDto::getId).collect(Collectors.toList()));
            }
        }
        this.setChildArea(reqDto);
    }

    private void setChildArea(CustomerTransactionStatusCountQueryDto reqDto) {
        List areaIdList = reqDto.getAreaIdList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)areaIdList)) {
            return;
        }
        List areaEos = this.iDgCustomerAreaDomain.selectList((LambdaQueryWrapper)Wrappers.lambdaQuery(DgCustomerAreaEo.class).in(BaseEo::getId, (Collection)areaIdList));
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)areaEos)) {
            return;
        }
        List codes = areaEos.stream().map(DgCustomerAreaEo::getCode).collect(Collectors.toList());
        ArrayList dgCustomerAreaEos = new ArrayList();
        this.iDgCustomerAreaDomain.listChildAreaByCodes(codes, dgCustomerAreaEos);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(dgCustomerAreaEos)) {
            reqDto.setAreaIdList(dgCustomerAreaEos.stream().map(BaseEo::getId).distinct().collect(Collectors.toList()));
        }
    }
}

