/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.inventory;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.domain.entity.IDgAfterSaleOrderDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgDailySplitWarehouseDetailDomain;
import com.yunxi.dg.base.center.report.dto.inventory.DgDailySplitWarehouseDetailDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgDailySplitWarehouseDetailReqDto;
import com.yunxi.dg.base.center.report.eo.inventory.DgOutResultOrderEo;
import com.yunxi.dg.base.center.report.eo.trade.DgAfterSaleOrderEo;
import com.yunxi.dg.base.center.report.service.inventory.IDgDailySplitWarehouseDetailService;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgDailySplitWarehouseDetailServiceImpl
extends BaseServiceImpl<DgDailySplitWarehouseDetailDto, DgOutResultOrderEo, IDgDailySplitWarehouseDetailDomain>
implements IDgDailySplitWarehouseDetailService {
    private static final Logger log = LoggerFactory.getLogger(DgDailySplitWarehouseDetailServiceImpl.class);
    @Resource
    private IDgAfterSaleOrderDomain dgAfterSaleOrderDomain;
    public static final String BUSINESS_ORDER = "businessOrder";
    public static final String SPLIT_WAREHOUSE = "splitWarehouse";

    public DgDailySplitWarehouseDetailServiceImpl(IDgDailySplitWarehouseDetailDomain domain) {
        super((IBaseDomain)domain);
    }

    @Override
    public PageInfo<DgDailySplitWarehouseDetailDto> queryList(DgDailySplitWarehouseDetailReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        if (BUSINESS_ORDER.equals(dto.getLabelType())) {
            List list = ((IDgDailySplitWarehouseDetailDomain)this.domain).queryBusinessOrderDetailList(dto);
            if (CollectionUtils.isEmpty((Collection)list)) {
                return new PageInfo();
            }
            List relevanceNoList = list.stream().filter(o -> ObjectUtil.isNull((Object)o.getBusinessType())).map(DgDailySplitWarehouseDetailDto::getRelevanceNo).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(relevanceNoList)) {
                List afterSaleOrderEos = ((ExtQueryChainWrapper)this.dgAfterSaleOrderDomain.filter().in((Object)"after_sale_order_no", relevanceNoList)).list();
                Map<String, Integer> businessTypeMap = afterSaleOrderEos.stream().collect(Collectors.toMap(DgAfterSaleOrderEo::getAfterSaleOrderNo, DgAfterSaleOrderEo::getReturnBizType, (o1, o2) -> o1));
                for (DgDailySplitWarehouseDetailDto detailDto : list) {
                    detailDto.setJumpDocumentType("order_sales_refund");
                    if (!businessTypeMap.containsKey(detailDto.getRelevanceNo())) continue;
                    detailDto.setBusinessType(businessTypeMap.get(detailDto.getRelevanceNo()).toString());
                }
            }
            return new PageInfo(list);
        }
        if (SPLIT_WAREHOUSE.equals(dto.getLabelType())) {
            return new PageInfo(((IDgDailySplitWarehouseDetailDomain)this.domain).querySplitWarehouseDetailList(dto));
        }
        PageHelper.clearPage();
        return new PageInfo();
    }

    @Override
    public PageInfo<DgDailySplitWarehouseDetailDto> summaryPage(DgDailySplitWarehouseDetailReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        return new PageInfo(((IDgDailySplitWarehouseDetailDomain)this.domain).summaryPage(dto));
    }
}

