/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.inventory;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.opensearch.api.IOpenSearchService;
import com.dtyunxi.huieryun.opensearch.enums.LogicalSymbol;
import com.dtyunxi.huieryun.opensearch.enums.SortOrder;
import com.dtyunxi.huieryun.opensearch.vo.FilterFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.config.SearchConfigVo;
import com.yunxi.dg.base.center.report.constants.DefaultConstants;
import com.yunxi.dg.base.center.report.convert.inventory.DgInOtherStorageOrderConverter;
import com.yunxi.dg.base.center.report.dao.mapper.inventory.DgOutNoticeOrderMapper;
import com.yunxi.dg.base.center.report.domain.entity.IOrderUnitConversionRecordDomain;
import com.yunxi.dg.base.center.report.domain.entity.IOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.report.domain.entity.IWarehouseAddressDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgInOtherStorageOrderDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgOutNoticeOrderDomain;
import com.yunxi.dg.base.center.report.dto.entity.OutNoticeOrderDetailDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgInOtherStorageOrderDetailDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgInOtherStorageOrderDetailPageReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgInOtherStorageOrderDetailSumGoodsDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgInOtherStorageOrderDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgInOtherStorageOrderPageReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgOutNoticeOrderPageReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.InventoryStatisticsRespDto;
import com.yunxi.dg.base.center.report.dto.inventory.utils.OrderUnitConverterDto;
import com.yunxi.dg.base.center.report.dto.item.ItDirDto;
import com.yunxi.dg.base.center.report.eo.OrderUnitConversionRecordEo;
import com.yunxi.dg.base.center.report.eo.WarehouseAddressEo;
import com.yunxi.dg.base.center.report.eo.inventory.DgInOtherStorageOrderEo;
import com.yunxi.dg.base.center.report.eo.inventory.DgOutNoticeOrderEo;
import com.yunxi.dg.base.center.report.service.impl.inventory.es.BaseEsServiceInterface;
import com.yunxi.dg.base.center.report.service.impl.inventory.utils.UnitConverUtils;
import com.yunxi.dg.base.center.report.service.inventory.IDgInOtherStorageOrderService;
import com.yunxi.dg.base.center.report.service.item.IItDirService;
import com.yunxi.dg.base.center.report.util.EsSearchUtils;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DgInOtherStorageOrderServiceImpl
extends BaseServiceImpl<DgInOtherStorageOrderDto, DgInOtherStorageOrderEo, IDgInOtherStorageOrderDomain>
implements IDgInOtherStorageOrderService,
BaseEsServiceInterface {
    private static final Logger log = LoggerFactory.getLogger(DgInOtherStorageOrderServiceImpl.class);
    String inOtherStorageTableName = "in_other_storage_order";
    String inOtherStorageDetailTableName = "in_other_storage_order_detail";
    private static final String[] ORDER_NOS = new String[]{"orderNo", "externalOrderNo", "storageOrderNo"};
    @Resource
    private DgOutNoticeOrderMapper outNoticeOrderMapper;
    @Resource
    private IOrderUnitConversionRecordDomain orderUnitConversionRecordDomain;
    @Value(value="${project.inventory.es.query:false}")
    private Boolean esQuery;
    @Autowired
    protected IOpenSearchService openSearchService;
    @Resource
    private IWarehouseAddressDomain warehouseAddressDomain;
    @Resource
    private SearchConfigVo searchConfigVo;
    @Resource
    private IDgOutNoticeOrderDomain dgOutNoticeOrderDomain;
    @Resource
    private IOutNoticeOrderDetailDomain outNoticeOrderDetailDomain;
    @Resource
    private IItDirService dirService;

    public DgInOtherStorageOrderServiceImpl(IDgInOtherStorageOrderDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgInOtherStorageOrderDto, DgInOtherStorageOrderEo> converter() {
        return DgInOtherStorageOrderConverter.INSTANCE;
    }

    @Override
    public RestResponse<List<DgInOtherStorageOrderDto>> queryList(DgInOtherStorageOrderPageReqDto dto) {
        return new RestResponse((Object)((IDgInOtherStorageOrderDomain)this.domain).queryList(dto));
    }

    @Override
    public PageInfo<DgInOtherStorageOrderDto> queryPage(DgInOtherStorageOrderPageReqDto dto) {
        PageInfo dgInOtherStorageOrderDtoPageInfo = new PageInfo();
        if (this.esQuery.booleanValue()) {
            dgInOtherStorageOrderDtoPageInfo = this.getInOtherStorageOrderEsList(dto);
        } else {
            PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
            List dgInOtherStorageOrderDtos = ((IDgInOtherStorageOrderDomain)this.domain).queryList(dto);
            this.wrapData(dgInOtherStorageOrderDtos);
            dgInOtherStorageOrderDtoPageInfo = new PageInfo(dgInOtherStorageOrderDtos);
        }
        this.wrapperData(dgInOtherStorageOrderDtoPageInfo.getList());
        return dgInOtherStorageOrderDtoPageInfo;
    }

    public void wrapData(List<DgInOtherStorageOrderDto> dgInOtherStorageOrderDtos) {
        if (CollectionUtil.isEmpty(dgInOtherStorageOrderDtos)) {
            return;
        }
        for (DgInOtherStorageOrderDto orderDto : dgInOtherStorageOrderDtos) {
            JSONObject jsonObject;
            String extension = orderDto.getExtension();
            if (StringUtils.isEmpty((CharSequence)extension) || !Objects.nonNull(jsonObject = JSONObject.parseObject((String)extension))) continue;
            orderDto.setAuditRemark(jsonObject.getString("auditRemark"));
            orderDto.setWhetherSend(jsonObject.getInteger("whetherScan"));
            orderDto.setWhDepartmentCode(jsonObject.getString("whDepartmentCode"));
            orderDto.setWhDepartmentName(jsonObject.getString("whDepartmentName"));
        }
    }

    private void wrapperData(List<DgInOtherStorageOrderDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Set physicsWarehouseCodeList = list.stream().map(DgInOtherStorageOrderDto::getPhysicsWarehouseCode).collect(Collectors.toSet());
        List inPhysicsWarehouseEoList = this.warehouseAddressDomain.queryByWarehouseCodes(new ArrayList(physicsWarehouseCodeList), "physics");
        Map<String, WarehouseAddressEo> warehouseEoMap = inPhysicsWarehouseEoList.stream().collect(Collectors.toMap(WarehouseAddressEo::getWarehouseCode, warehouseEo -> warehouseEo, (existing, replacement) -> existing));
        for (DgInOtherStorageOrderDto orderDto : list) {
            WarehouseAddressEo in;
            String extension = orderDto.getExtension();
            if (StringUtils.isNotEmpty((CharSequence)extension)) {
                JSONObject param = JSONObject.parseObject((String)extension);
                orderDto.setTransportTypeCode(param.getString("transportTypeCode"));
                orderDto.setTransportTypeName(param.getString("transportTypeName"));
                orderDto.setLineCode(param.getString("lineCode"));
                orderDto.setLineName(param.getString("lineName"));
            }
            if ((in = warehouseEoMap.get(orderDto.getPhysicsWarehouseCode())) == null) continue;
            String sb = in.getProvince() + in.getCity() + in.getDistrict() + in.getDetailAddress();
            orderDto.setShippingWarehouseAddress(sb);
        }
    }

    @Override
    public PageInfo<DgInOtherStorageOrderDetailDto> queryDetailPage(DgInOtherStorageOrderPageReqDto dto) {
        PageInfo dgInOtherStorageOrderDetailDtoPageInfo = new PageInfo();
        if (CollectionUtils.isNotEmpty((Collection)dto.getLastDirIdList())) {
            List<String> skuCodes = this.dirService.querySkuCodeListByDirList(dto.getLastDirIdList());
            if (CollectionUtils.isEmpty(skuCodes)) {
                return new PageInfo();
            }
            List skuCodeList = Optional.ofNullable(dto.getSkuCodeList()).orElse(new ArrayList());
            skuCodeList.addAll(skuCodes);
            dto.setSkuCodeList(skuCodeList);
        }
        if (this.esQuery.booleanValue()) {
            dgInOtherStorageOrderDetailDtoPageInfo = this.getInOtherStorageOrderDetailEsList(dto);
        } else {
            PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
            List detailDtoList = ((IDgInOtherStorageOrderDomain)this.domain).queryDetailList(dto);
            this.wrapDetail(detailDtoList);
            dgInOtherStorageOrderDetailDtoPageInfo = new PageInfo(detailDtoList);
        }
        this.setDefaultParam(dgInOtherStorageOrderDetailDtoPageInfo);
        return dgInOtherStorageOrderDetailDtoPageInfo;
    }

    public void wrapDetail(List<DgInOtherStorageOrderDetailDto> resultList) {
        if (CollectionUtils.isEmpty(resultList)) {
            return;
        }
        String[] overStatus = new String[]{"completed", "finish", "cancel"};
        Set<String> orderNos = resultList.stream().filter(x -> !StrUtil.equalsAny((CharSequence)x.getOrderStatus(), (CharSequence[])overStatus)).map(DgInOtherStorageOrderDetailDto::getStorageOrderNo).collect(Collectors.toSet());
        Map<Long, InventoryStatisticsRespDto> processingQuantityOfTheDocumentMap = this.getOutQuantityOfTheDocument(orderNos, "out", "in");
        ArrayList convertList = new ArrayList();
        resultList.forEach(o -> {
            if (DefaultConstants.STATIC_STATUS_LIST.contains(o.getOrderStatus())) {
                o.setWaitQuantity(o.getQuantity());
            } else if (!StrUtil.equalsAny((CharSequence)o.getOrderStatus(), (CharSequence[])overStatus)) {
                InventoryStatisticsRespDto detailEo = processingQuantityOfTheDocumentMap.getOrDefault(o.getId(), new InventoryStatisticsRespDto());
                OrderUnitConverterDto converDto = new OrderUnitConverterDto();
                BeanUtil.copyProperties((Object)o, (Object)converDto, (String[])new String[0]);
                converDto.setConvedUnit(true);
                converDto.setDocumentCode(o.getStorageOrderNo());
                converDto.setPlanQuantity(detailEo.getPlanQuantity());
                converDto.setDoneQuantity(detailEo.getDoneQuantity());
                converDto.setWaitQuantity(BigDecimalUtils.subtract((BigDecimal)detailEo.getPlanQuantity(), (BigDecimal)detailEo.getDoneQuantity()));
                converDto.setConsumer(ver -> {
                    o.setDoneQuantity(ver.getDoneQuantity());
                    o.setWaitQuantity(ver.getWaitQuantity());
                });
                convertList.add(converDto);
            }
            if (StringUtils.isNotEmpty((CharSequence)o.getExtension())) {
                JSONObject param = JSONObject.parseObject((String)o.getExtension());
                o.setTransportTypeCode(param.getString("transportTypeCode"));
                o.setTransportTypeName(param.getString("transportTypeName"));
                o.setLineCode(param.getString("lineCode"));
                o.setLineName(param.getString("lineName"));
            }
        });
        UnitConverUtils.unitConvertBatch(new ArrayList(convertList));
    }

    private Map<Long, InventoryStatisticsRespDto> getOutQuantityOfTheDocument(Set<String> orderNos, String ... type) {
        if (CollectionUtils.isEmpty(orderNos)) {
            return new HashMap<Long, InventoryStatisticsRespDto>();
        }
        List dgOutNoticeOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgOutNoticeOrderDomain.filter().in((Object)"relevance_no", orderNos)).in((Object)"order_type", (Object[])type)).notIn((Object)"order_status", new Object[]{"ono_cancel", "ino_cancel"})).list();
        if (CollectionUtils.isEmpty((Collection)dgOutNoticeOrderEos)) {
            return new HashMap<Long, InventoryStatisticsRespDto>();
        }
        Set documentNoSet = dgOutNoticeOrderEos.stream().map(DgOutNoticeOrderEo::getDocumentNo).collect(Collectors.toSet());
        return ((ExtQueryChainWrapper)this.outNoticeOrderDetailDomain.filter().in((Object)"document_no", documentNoSet)).list().stream().map(x -> (InventoryStatisticsRespDto)BeanUtil.copyProperties((Object)x, InventoryStatisticsRespDto.class, (String[])new String[0])).collect(Collectors.toMap(InventoryStatisticsRespDto::getPreOrderItemId, Function.identity(), (o, o1) -> {
            o.setWaitQuantity(BigDecimalUtils.add((BigDecimal)o.getWaitQuantity(), (BigDecimal)o1.getWaitQuantity()));
            o.setDoneQuantity(BigDecimalUtils.add((BigDecimal)o.getDoneQuantity(), (BigDecimal)o1.getDoneQuantity()));
            o.setCancelQuantity(BigDecimalUtils.add((BigDecimal)o.getCancelQuantity(), (BigDecimal)o1.getCancelQuantity()));
            o.setPlanQuantity(BigDecimalUtils.add((BigDecimal)o.getPlanQuantity(), (BigDecimal)o1.getPlanQuantity()));
            return o;
        }));
    }

    private void setDefaultParam(PageInfo<DgInOtherStorageOrderDetailDto> dgInOtherStorageOrderDetailDtoPageInfo) {
        if (Objects.isNull(dgInOtherStorageOrderDetailDtoPageInfo) || CollectionUtils.isEmpty((Collection)dgInOtherStorageOrderDetailDtoPageInfo.getList())) {
            return;
        }
        List<String> skuCodes = dgInOtherStorageOrderDetailDtoPageInfo.getList().stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getSkuCode())).map(e -> e.getSkuCode()).distinct().collect(Collectors.toList());
        Map lastDirMap = Optional.ofNullable(this.dirService.queryLastDirBySkuCodes(skuCodes)).orElse(new HashMap());
        dgInOtherStorageOrderDetailDtoPageInfo.getList().forEach(o -> {
            ItDirDto itDirDto = (ItDirDto)lastDirMap.get(o.getSkuCode());
            if (Objects.nonNull(itDirDto)) {
                o.setLastDirId(itDirDto.getId());
                o.setLastDirName(itDirDto.getName());
            }
        });
    }

    @Override
    public RestResponse<DgInOtherStorageOrderDetailDto> queryDetail(String storageOrderNo) {
        DgInOtherStorageOrderPageReqDto dgInOtherStorageOrderPageReqDto = new DgInOtherStorageOrderPageReqDto();
        DgInOtherStorageOrderDetailDto dgInOtherStorageOrderDetailDto = new DgInOtherStorageOrderDetailDto();
        dgInOtherStorageOrderPageReqDto.setStorageOrderNo(storageOrderNo);
        List dgInOtherStorageOrderDtos = ((IDgInOtherStorageOrderDomain)this.domain).queryList(dgInOtherStorageOrderPageReqDto);
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dgInOtherStorageOrderDtos), (String)"\u5355\u636e\u8bb0\u5f55\u4e0d\u5b58\u5728");
        if (CollectionUtils.isNotEmpty((Collection)dgInOtherStorageOrderDtos)) {
            BeanUtil.copyProperties(dgInOtherStorageOrderDtos.get(0), (Object)dgInOtherStorageOrderDetailDto, (String[])new String[0]);
            if (StringUtils.isNotEmpty((CharSequence)((DgInOtherStorageOrderDto)dgInOtherStorageOrderDtos.get(0)).getDocumentUrl())) {
                dgInOtherStorageOrderDetailDto.setDocumentUrlList(Arrays.asList(((DgInOtherStorageOrderDto)dgInOtherStorageOrderDtos.get(0)).getDocumentUrl().split(",")));
            }
        }
        return new RestResponse((Object)dgInOtherStorageOrderDetailDto);
    }

    @Override
    public RestResponse<DgInOtherStorageOrderDetailSumGoodsDto> querySumGoods(String storageOrderNo) {
        DgInOtherStorageOrderEo orderEo = (DgInOtherStorageOrderEo)((ExtQueryChainWrapper)((IDgInOtherStorageOrderDomain)this.domain).filter().eq((Object)"storage_order_no", (Object)storageOrderNo)).one();
        AssertUtils.isTrue((orderEo != null ? 1 : 0) != 0, (String)"\u5355\u636e\u4fe1\u606f\u4e0d\u5b58\u5728");
        DgInOtherStorageOrderPageReqDto dgInOtherStorageOrderPageReqDto = new DgInOtherStorageOrderPageReqDto();
        dgInOtherStorageOrderPageReqDto.setStorageOrderNo(storageOrderNo);
        DgInOtherStorageOrderDetailSumGoodsDto dgInOtherStorageOrderDetailSumGoodsDto = ((IDgInOtherStorageOrderDomain)this.domain).querySumGoods(dgInOtherStorageOrderPageReqDto);
        AssertUtils.isTrue((dgInOtherStorageOrderDetailSumGoodsDto != null ? 1 : 0) != 0, (String)"\u5546\u54c1\u4fe1\u606f\u7edf\u8ba1\u8bb0\u5f55\u4e0d\u5b58\u5728");
        if (StrUtil.equalsAny((CharSequence)orderEo.getOrderStatus(), (CharSequence[])new CharSequence[]{"wait_audit", "wait_submit", "audit_failed", "cancel"})) {
            dgInOtherStorageOrderDetailSumGoodsDto.setTotalDoneQuantity(BigDecimal.ZERO);
            dgInOtherStorageOrderDetailSumGoodsDto.setTotalWaitQuantity(dgInOtherStorageOrderDetailSumGoodsDto.getTotalPlanQuantity());
            return new RestResponse((Object)dgInOtherStorageOrderDetailSumGoodsDto);
        }
        DgOutNoticeOrderPageReqDto outNoticeOrderPageReqDto = new DgOutNoticeOrderPageReqDto();
        outNoticeOrderPageReqDto.setRelevanceNoList(Arrays.asList(storageOrderNo));
        outNoticeOrderPageReqDto.setNotOrderStatusList(Arrays.asList("ono_cancel", "ino_cancel"));
        List outNoticeOrderDetailDtos = this.outNoticeOrderMapper.queryDetailList(outNoticeOrderPageReqDto);
        List relevanceNoList = outNoticeOrderDetailDtos.stream().map(OutNoticeOrderDetailDto::getRelevanceNo).collect(Collectors.toList());
        List unitConversionRecordEos = ((ExtQueryChainWrapper)this.orderUnitConversionRecordDomain.filter().in(CollectionUtils.isNotEmpty(relevanceNoList), (Object)"document_code", relevanceNoList)).list();
        Map unitConversionMap = unitConversionRecordEos.stream().collect(Collectors.toMap(o -> o.getDocumentCode() + o.getSkuCode(), Function.identity(), (o2, o1) -> o2));
        outNoticeOrderDetailDtos.forEach(o -> {
            if (unitConversionMap.containsKey(o.getRelevanceNo() + o.getSkuCode())) {
                this.unitConversion((OutNoticeOrderDetailDto)o, (OrderUnitConversionRecordEo)unitConversionMap.get(o.getRelevanceNo() + o.getSkuCode()));
            }
        });
        BigDecimal totalDoneQuantity = outNoticeOrderDetailDtos.stream().filter(o -> o.getRelevanceNo().equals(storageOrderNo)).map(OutNoticeOrderDetailDto::getDoneQuantity).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(6);
        BigDecimal totalWaitQuantity = outNoticeOrderDetailDtos.stream().filter(o -> o.getRelevanceNo().equals(storageOrderNo)).map(OutNoticeOrderDetailDto::getWaitQuantity).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(6);
        dgInOtherStorageOrderDetailSumGoodsDto.setTotalDoneQuantity(totalDoneQuantity);
        if (StrUtil.equalsAny((CharSequence)orderEo.getOrderStatus(), (CharSequence[])new CharSequence[]{"completed", "finish"})) {
            totalWaitQuantity = BigDecimal.ZERO;
        }
        dgInOtherStorageOrderDetailSumGoodsDto.setTotalWaitQuantity(totalWaitQuantity);
        return new RestResponse((Object)dgInOtherStorageOrderDetailSumGoodsDto);
    }

    @Override
    public RestResponse<List<DgInOtherStorageOrderDetailDto>> queryPartsRequisitionList(DgInOtherStorageOrderDetailPageReqDto reqDto) {
        List dgInOtherStorageOrderDetailDtos = ((IDgInOtherStorageOrderDomain)this.domain).queryPartsRequisitionList(reqDto);
        return new RestResponse((Object)dgInOtherStorageOrderDetailDtos);
    }

    private void unitConversion(OutNoticeOrderDetailDto dto, OrderUnitConversionRecordEo unitConversionEo) {
        BigDecimal rate = BigDecimal.ZERO.compareTo(unitConversionEo.getToNum()) == 0 ? BigDecimal.ONE : unitConversionEo.getNum().divide(unitConversionEo.getToNum(), 6, RoundingMode.HALF_UP);
        BigDecimal toRate = BigDecimal.ZERO.compareTo(unitConversionEo.getToNum()) == 0 ? BigDecimal.ONE : unitConversionEo.getToNum().divide(unitConversionEo.getNum(), 6, RoundingMode.HALF_UP);
        dto.setDoneQuantity(UnitConverUtils.pareSaleNum(dto.getDoneQuantity(), toRate, rate));
        dto.setWaitQuantity(UnitConverUtils.pareSaleNum(dto.getWaitQuantity(), toRate, rate));
    }

    private PageInfo<DgInOtherStorageOrderDto> getInOtherStorageOrderEsList(DgInOtherStorageOrderPageReqDto dto) {
        String indexName = this.searchConfigVo.getIndexNamePreFix() + "-" + this.inOtherStorageTableName;
        PageInfo pageInfo = new PageInfo();
        try {
            OSSearchVo queryVo = this.initSearchVo(dto);
            BigDecimal pageNum = new BigDecimal(dto.getPageNum());
            BigDecimal pageSize = new BigDecimal(dto.getPageSize());
            BigDecimal maxSize = new BigDecimal(10000);
            if (pageNum.multiply(pageSize).subtract(pageSize).compareTo(maxSize) > -1) {
                pageNum = maxSize.divide(pageSize, 0, 0);
            }
            queryVo.setPage(pageNum.intValue());
            queryVo.setPageSize(pageSize.intValue());
            SearchResultVo searchResultVo = this.searchData(indexName, queryVo);
            if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
                return new PageInfo();
            }
            pageInfo = this.searchResultPage(searchResultVo);
            List dgDeliveryNoticeOrderDtoList = searchResultVo.getDocValues(docValue -> {
                DgInOtherStorageOrderDto orderItemPageDto = (DgInOtherStorageOrderDto)BeanUtil.copyProperties((Object)docValue, DgInOtherStorageOrderDto.class, (String[])new String[0]);
                return orderItemPageDto;
            });
            pageInfo.setList(dgDeliveryNoticeOrderDtoList);
        }
        catch (Exception e) {
            log.error("ES\u67e5\u8be2\u5f02\u5e38:", (Throwable)e);
            throw new BizException("ES\u67e5\u8be2\u5f02\u5e38:" + e.getMessage());
        }
        return pageInfo;
    }

    private OSSearchVo initSearchVo(DgInOtherStorageOrderPageReqDto reqDto) throws Exception {
        FilterFieldVo filter;
        log.info("ES\u5176\u4ed6\u51fa\u5165\u5e93\u5355\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)reqDto));
        OSSearchVo queryVo = EsSearchUtils.newInstance().getNewSearchVo((Object)reqDto);
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getCompoundOrderNo())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (String o : ORDER_NOS) {
                filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)o, (String)reqDto.getCompoundOrderNo(), (LogicalSymbol)LogicalSymbol.OR)});
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getSkuCodeList())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"skuCodeList", (List)reqDto.getSkuCodeList())});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getSpuCodeList())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"spuCodeList", (List)reqDto.getSpuCodeList())});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getBatchList())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"batchList", (List)reqDto.getBatchList())});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getSkuDisplayName())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.wildcard((String)"skuDisplayNameList", (String)("*" + reqDto.getSkuDisplayName() + "*"))});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        queryVo.addSort("id", SortOrder.DESC);
        log.info("ES\u5176\u4ed6\u51fa\u5165\u5e93\u5355\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)queryVo));
        return queryVo;
    }

    private PageInfo<DgInOtherStorageOrderDetailDto> getInOtherStorageOrderDetailEsList(DgInOtherStorageOrderPageReqDto dto) {
        String indexName = this.searchConfigVo.getIndexNamePreFix() + "-" + this.inOtherStorageDetailTableName;
        PageInfo pageInfo = new PageInfo();
        try {
            OSSearchVo queryVo = this.initDetailSearchVo(dto);
            BigDecimal pageNum = new BigDecimal(dto.getPageNum());
            BigDecimal pageSize = new BigDecimal(dto.getPageSize());
            BigDecimal maxSize = new BigDecimal(10000);
            if (pageNum.multiply(pageSize).subtract(pageSize).compareTo(maxSize) > -1) {
                pageNum = maxSize.divide(pageSize, 0, 0);
            }
            queryVo.setPage(pageNum.intValue());
            queryVo.setPageSize(pageSize.intValue());
            SearchResultVo searchResultVo = this.searchData(indexName, queryVo);
            if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
                return new PageInfo();
            }
            pageInfo = this.searchResultPage(searchResultVo);
            List dgDeliveryNoticeOrderDtoList = searchResultVo.getDocValues(docValue -> {
                DgInOtherStorageOrderDetailDto orderItemPageDto = (DgInOtherStorageOrderDetailDto)BeanUtil.copyProperties((Object)docValue, DgInOtherStorageOrderDetailDto.class, (String[])new String[0]);
                return orderItemPageDto;
            });
            pageInfo.setList(dgDeliveryNoticeOrderDtoList);
        }
        catch (Exception e) {
            log.error("ES\u67e5\u8be2\u5f02\u5e38:", (Throwable)e);
            throw new BizException("ES\u67e5\u8be2\u5f02\u5e38:" + e.getMessage());
        }
        return pageInfo;
    }

    private OSSearchVo initDetailSearchVo(DgInOtherStorageOrderPageReqDto reqDto) throws Exception {
        FilterFieldVo filter;
        log.info("ES\u5176\u4ed6\u51fa\u5165\u5e93\u5355\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)reqDto));
        OSSearchVo queryVo = EsSearchUtils.newInstance().getNewSearchVo((Object)reqDto);
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getCompoundOrderNo())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (String o : ORDER_NOS) {
                filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)o, (String)reqDto.getCompoundOrderNo(), (LogicalSymbol)LogicalSymbol.OR)});
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getSkuCodeList())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"skuCode", (List)reqDto.getSkuCodeList())});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getSpuCodeList())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"spuCode", (List)reqDto.getSpuCodeList())});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getBatchList())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"batch", (List)reqDto.getBatchList())});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getSkuDisplayName())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.wildcard((String)"skuDisplayName", (String)("*" + reqDto.getSkuDisplayName() + "*"))});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        queryVo.addSort("id", SortOrder.DESC);
        log.info("ES\u5176\u4ed6\u51fa\u5165\u5e93\u5355\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)queryVo));
        return queryVo;
    }

    @Override
    public IOpenSearchService getIOpenSearchService() {
        return this.openSearchService;
    }
}

