/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.inventory;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.convert.inventory.DgLogicWarehouseConverter;
import com.yunxi.dg.base.center.report.domain.inventory.IDgLogicWarehouseDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehouseDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehouseExtDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehouseOrgRespDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehousePageReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgPhysicsWarehouseDto;
import com.yunxi.dg.base.center.report.eo.inventory.DgLogicWarehouseEo;
import com.yunxi.dg.base.center.report.eo.inventory.DgPhysicsWarehouseEo;
import com.yunxi.dg.base.center.report.service.inventory.IDgLogicWarehouseService;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class DgLogicWarehouseServiceImpl
extends BaseServiceImpl<DgLogicWarehouseDto, DgLogicWarehouseEo, IDgLogicWarehouseDomain>
implements IDgLogicWarehouseService {
    @Resource
    private IDgPhysicsWarehouseDomain physicsWarehouseDomain;

    public DgLogicWarehouseServiceImpl(IDgLogicWarehouseDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgLogicWarehouseDto, DgLogicWarehouseEo> converter() {
        return DgLogicWarehouseConverter.INSTANCE;
    }

    @Override
    public RestResponse<List<DgLogicWarehouseOrgRespDto>> queryOrgList() {
        return new RestResponse((Object)((IDgLogicWarehouseDomain)this.domain).queryOrgList());
    }

    @Override
    public RestResponse<PageInfo<DgLogicWarehouseDto>> queryPage(DgLogicWarehousePageReqDto dto) {
        return new RestResponse((Object)((IDgLogicWarehouseDomain)this.domain).queryPage(dto));
    }

    @Override
    public RestResponse<List<DgLogicWarehouseDto>> queryList(DgLogicWarehousePageReqDto dto) {
        return new RestResponse((Object)((IDgLogicWarehouseDomain)this.domain).queryList(dto));
    }

    @Override
    public List<DgLogicWarehouseExtDto> queryExtList(DgLogicWarehousePageReqDto dto) {
        List<Object> extDtos = new ArrayList<DgLogicWarehouseExtDto>();
        List list = Optional.ofNullable(RestResponseHelper.extractData(this.queryList(dto))).orElse(new ArrayList());
        List physicsWarehouseCodes = list.stream().filter(e -> Objects.nonNull(e) && StringUtils.isNotBlank((CharSequence)e.getPhysicsWarehouseCode())).map(e -> e.getPhysicsWarehouseCode()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(physicsWarehouseCodes)) {
            List physicsWarehouseEos = Optional.ofNullable(((ExtQueryChainWrapper)this.physicsWarehouseDomain.filter().in((Object)"warehouse_code", physicsWarehouseCodes)).list()).orElse(new ArrayList());
            Map physicsWarehouseEoMap = physicsWarehouseEos.stream().collect(Collectors.toMap(DgPhysicsWarehouseEo::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
            extDtos = list.stream().map(e -> {
                DgLogicWarehouseExtDto extDto = new DgLogicWarehouseExtDto();
                CubeBeanUtils.copyProperties((Object)extDto, (Object)e, (String[])new String[0]);
                DgPhysicsWarehouseEo physicsWarehouseEo = (DgPhysicsWarehouseEo)physicsWarehouseEoMap.get(e.getPhysicsWarehouseCode());
                if (Objects.nonNull(physicsWarehouseEo)) {
                    DgPhysicsWarehouseDto physicsWarehouseDto = new DgPhysicsWarehouseDto();
                    CubeBeanUtils.copyProperties((Object)physicsWarehouseDto, (Object)physicsWarehouseEo, (String[])new String[0]);
                    extDto.setPhysicsWarehouseDto(physicsWarehouseDto);
                }
                return extDto;
            }).collect(Collectors.toList());
        }
        return extDtos;
    }

    @Override
    public RestResponse<PageInfo<DgLogicWarehouseExtDto>> queryLogicWarehouseAndEnterprise(DgLogicWarehousePageReqDto dto) {
        if (null == dto.getPageNum()) {
            dto.setPageNum(Integer.valueOf(1));
        }
        if (null == dto.getPageSize()) {
            dto.setPageSize(Integer.valueOf(100));
        }
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        return new RestResponse((Object)new PageInfo(((IDgLogicWarehouseDomain)this.domain).queryLogicWarehouseAndEnterprise(dto)));
    }
}

