/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.inventory.utils;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.yunxi.dg.base.center.report.dao.mapper.OrderUnitConversionRecordMapper;
import com.yunxi.dg.base.center.report.domain.entity.IOrderUnitConversionRecordDomain;
import com.yunxi.dg.base.center.report.dto.inventory.utils.OrderUnitConverterDto;
import com.yunxi.dg.base.center.report.eo.OrderUnitConversionRecordEo;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class UnitConverUtils {
    @Resource
    private IOrderUnitConversionRecordDomain orderUnitConversionRecordDomain;
    @Resource
    private OrderUnitConversionRecordMapper orderUnitConversionRecordMapper;
    public static UnitConverUtils self;

    @PostConstruct
    private void init() {
        self = this;
        UnitConverUtils.self.orderUnitConversionRecordDomain = this.orderUnitConversionRecordDomain;
        UnitConverUtils.self.orderUnitConversionRecordMapper = this.orderUnitConversionRecordMapper;
    }

    private static void conversOpt(OrderUnitConverterDto dto, OrderUnitConversionRecordEo unitConversionEo) {
        if (!dto.isConvedUnit()) {
            dto.setUnit(unitConversionEo.getUnit());
        }
        BigDecimal rate = BigDecimal.ZERO.compareTo(unitConversionEo.getToNum()) == 0 ? BigDecimal.ONE : BigDecimalUtils.divide((BigDecimal)unitConversionEo.getToNum(), (BigDecimal)unitConversionEo.getNum(), (int)6);
        BigDecimal toRate = BigDecimal.ZERO.compareTo(unitConversionEo.getToNum()) == 0 ? BigDecimal.ONE : BigDecimalUtils.divide((BigDecimal)unitConversionEo.getNum(), (BigDecimal)unitConversionEo.getToNum(), (int)6);
        BigDecimal planQuantity = UnitConverUtils.getParseQuantity(dto.getPlanQuantity(), toRate, rate, dto.isBaseTo());
        BigDecimal doneQuantity = UnitConverUtils.getParseQuantity(dto.getDoneQuantity(), toRate, rate, dto.isBaseTo());
        BigDecimal waitQuantity = UnitConverUtils.getParseQuantity(dto.getWaitQuantity(), toRate, rate, dto.isBaseTo());
        BigDecimal doneInQuantity = UnitConverUtils.getParseQuantity(dto.getDoneInQuantity(), toRate, rate, dto.isBaseTo());
        dto.setPlanQuantity(planQuantity);
        dto.setDoneQuantity(doneQuantity);
        dto.setWaitQuantity(waitQuantity);
        dto.setDoneInQuantity(doneInQuantity);
    }

    private static BigDecimal getParseQuantity(BigDecimal q, BigDecimal toRate, BigDecimal rate, boolean base) {
        return base ? UnitConverUtils.pareSaleNum(q, rate, toRate) : UnitConverUtils.pareSaleNum(q, toRate, rate);
    }

    public static <T extends OrderUnitConverterDto> void unitConvertBatch(List<T> dtos) {
        List documentCodeList = dtos.stream().map(OrderUnitConverterDto::getDocumentCode).collect(Collectors.toList());
        if (documentCodeList.isEmpty()) {
            return;
        }
        List unitConversionRecordEoList = ((ExtQueryChainWrapper)UnitConverUtils.self.orderUnitConversionRecordDomain.filter().in((Object)"document_code", documentCodeList)).list();
        Map unitConversionMap = unitConversionRecordEoList.stream().collect(Collectors.toMap(UnitConverUtils::getKey, Function.identity(), (o2, o1) -> o2));
        Map unitConversionBaseMap = unitConversionRecordEoList.stream().collect(Collectors.toMap(o -> o.getDocumentCode() + o.getSkuCode(), Function.identity(), (o2, o1) -> o2));
        dtos.forEach(o -> {
            String key = UnitConverUtils.getMatchKey(o);
            OrderUnitConversionRecordEo orDefault = (OrderUnitConversionRecordEo)unitConversionMap.getOrDefault(key, unitConversionBaseMap.get(key));
            if (Objects.nonNull(orDefault)) {
                UnitConverUtils.conversOpt(o, orDefault);
                if (o.getConsumer() != null) {
                    o.getConsumer().accept(o);
                }
            }
        });
    }

    @NotNull
    private static <T extends OrderUnitConverterDto> String getMatchKey(T o) {
        return o.isBaseTo() ? o.getDocumentCode() + o.getSkuCode() : o.getDocumentCode() + o.getSkuCode() + o.getUnit();
    }

    @NotNull
    private static String getKey(OrderUnitConversionRecordEo o) {
        return o.getDocumentCode() + o.getSkuCode() + o.getUnit();
    }

    public static BigDecimal pareSaleNum(BigDecimal quantity, BigDecimal ratio, BigDecimal toRatio) {
        return Optional.ofNullable(quantity).map(q -> BigDecimalUtils.gt((BigDecimal)ratio, (BigDecimal)toRatio) != false ? BigDecimalUtils.divide((BigDecimal)quantity, (BigDecimal)ratio, (int)6) : BigDecimalUtils.multiply((BigDecimal)quantity, (BigDecimal)toRatio)).orElse(BigDecimal.ZERO);
    }
}

