/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.reconciliation.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.inventory.api.IKingdeeEdiApi;
import com.yunxi.dg.base.center.inventory.dto.request.BillFlowReqDto;
import com.yunxi.dg.base.center.inventory.dto.response.BillFlowRespDto;
import com.yunxi.dg.base.center.report.convert.reconciliation.ErpInventoryPostDetailConverter;
import com.yunxi.dg.base.center.report.domain.item.IItemDgDomain;
import com.yunxi.dg.base.center.report.domain.item.IItemSkuDgDomain;
import com.yunxi.dg.base.center.report.domain.reconciliation.IErpInventoryPostDetailDomain;
import com.yunxi.dg.base.center.report.dto.entity.LogicInventorySnapshotDto;
import com.yunxi.dg.base.center.report.dto.entity.LogicInventorySnapshotPageReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehouseDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehousePageReqDto;
import com.yunxi.dg.base.center.report.dto.reconciliation.ErpInventoryPostDetailDto;
import com.yunxi.dg.base.center.report.dto.reconciliation.ErpInventoryPostDetailPageReqDto;
import com.yunxi.dg.base.center.report.eo.ItemDgEo;
import com.yunxi.dg.base.center.report.eo.item.ItemSkuDgEo;
import com.yunxi.dg.base.center.report.eo.reconciliation.ErpInventoryPostDetailEo;
import com.yunxi.dg.base.center.report.service.inventory.IDgLogicWarehouseService;
import com.yunxi.dg.base.center.report.service.inventory.ILogicInventorySnapshotService;
import com.yunxi.dg.base.center.report.service.reconciliation.IErpInventoryPostDetailService;
import com.yunxi.dg.base.center.report.service.utils.DateTimeUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ErpInventoryPostDatailServiceImpl
extends BaseServiceImpl<ErpInventoryPostDetailDto, ErpInventoryPostDetailEo, IErpInventoryPostDetailDomain>
implements IErpInventoryPostDetailService {
    private static final Logger log = LoggerFactory.getLogger(ErpInventoryPostDatailServiceImpl.class);
    @Resource
    private IKingdeeEdiApi kingdeeEdiApi;
    @Resource
    private IDgLogicWarehouseService logicWarehouseService;
    @Resource
    private IItemSkuDgDomain iItemSkuDgDomain;
    @Resource
    private IItemDgDomain iItemDgDomain;
    @Resource
    private ILogicInventorySnapshotService snapshotService;
    @Value(value="${erp.pageNum:1}")
    private Integer erpPageNum;
    @Value(value="${erp.pageSize:6000}")
    private Integer erpPageSize;
    @Value(value="${erp.endNum:1}")
    private Integer erpEndNum;

    public ErpInventoryPostDatailServiceImpl(IErpInventoryPostDetailDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<ErpInventoryPostDetailDto, ErpInventoryPostDetailEo> converter() {
        return ErpInventoryPostDetailConverter.INSTANCE;
    }

    @Override
    public RestResponse<PageInfo<ErpInventoryPostDetailDto>> queryPage(ErpInventoryPostDetailPageReqDto dto) {
        return null;
    }

    @Override
    public void saveErpInventoryPostDetail(List<ErpInventoryPostDetailDto> postDetailDtoList) {
        if (CollectionUtils.isNotEmpty(postDetailDtoList)) {
            List dispositionEoList = this.converter().toEoList(postDetailDtoList);
            ((IErpInventoryPostDetailDomain)this.domain).insertBatch(dispositionEoList);
        }
    }

    @Override
    public void pullErpInventoryPostDetail(String reconciliationTime, String source) {
        log.info("start pull erp data reconciliationTime = {}", (Object)reconciliationTime);
        if (StringUtils.isNotEmpty((CharSequence)reconciliationTime)) {
            LogicInventorySnapshotPageReqDto pageReqDto = new LogicInventorySnapshotPageReqDto();
            pageReqDto.setSnapshotDate(reconciliationTime);
            List snapshotDtos = (List)RestResponseHelper.extractData(this.snapshotService.queryList(pageReqDto));
            if (CollectionUtils.isNotEmpty((Collection)snapshotDtos)) {
                List warehouseCodes = snapshotDtos.stream().map(LogicInventorySnapshotDto::getWarehouseCode).distinct().collect(Collectors.toList());
                DgLogicWarehousePageReqDto dto = new DgLogicWarehousePageReqDto();
                dto.setWarehouseCodes(warehouseCodes);
                List logicWarehouseDtos = (List)RestResponseHelper.extractData(this.logicWarehouseService.queryList(dto));
                if (CollectionUtils.isNotEmpty((Collection)logicWarehouseDtos)) {
                    CompletableFuture.runAsync(() -> this.getErpInventoryPostDetailDto(logicWarehouseDtos, reconciliationTime));
                }
            }
        }
    }

    private List<ErpInventoryPostDetailDto> getErpInventoryPostDetailDto(List<DgLogicWarehouseDto> logicWarehouseDtos, String reconciliationTime) {
        ArrayList postDetailDtoList = Lists.newArrayList();
        logicWarehouseDtos.forEach(v -> {
            ErpInventoryPostDetailEo postDetailEo = new ErpInventoryPostDetailEo();
            postDetailEo.setReconciliationTime(DateTimeUtils.parseDate(reconciliationTime));
            postDetailEo.setLogicWarehouseCode(v.getWarehouseCode());
            ((IErpInventoryPostDetailDomain)this.domain).getMapper().delete((BaseEo)postDetailEo);
            BillFlowReqDto reqDto = new BillFlowReqDto();
            reqDto.setStartTime(reconciliationTime);
            reqDto.setEndTime(reconciliationTime);
            reqDto.setStockOrgNumbers(Collections.singletonList("100"));
            Integer pageNum = 1;
            log.info("pullErpInventoryPostDetail reqDto = {}", (Object)JSONObject.toJSONString((Object)reqDto));
            reqDto.setPageNum(this.erpPageNum);
            reqDto.setPageSize(this.erpPageSize);
            reqDto.setBeginStockNumber(v.getWarehouseCode());
            reqDto.setEndStockNumber(v.getWarehouseCode());
            log.info("pullErpInventoryPostDetail pageNum = {}", (Object)pageNum);
            boolean hasMore = true;
            try {
                int number = reqDto.getPageNum();
                while (hasMore) {
                    reqDto.setPageNum(Integer.valueOf(number));
                    log.info("\u62c9\u53d6erp\u5355\u636e\u6d41\u6c34\u8bf7\u6c42\uff1a{},{}", (Object)number, (Object)JSONObject.toJSONString((Object)reqDto));
                    List billFlowRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.kingdeeEdiApi.getBillFlowList(reqDto));
                    if (CollectionUtils.isNotEmpty((Collection)billFlowRespDtos)) {
                        List<ErpInventoryPostDetailDto> erpInventoryPostDetailDtos = this.setErpInventoryPostDetail(reconciliationTime, billFlowRespDtos, (DgLogicWarehouseDto)v);
                        this.batchSaveErpInventoryPostDetail(reconciliationTime, erpInventoryPostDetailDtos);
                        ++number;
                    } else {
                        hasMore = false;
                    }
                    if (number < this.erpEndNum) continue;
                    hasMore = false;
                }
            }
            catch (Exception e) {
                log.error("\u62c9\u53d6\u5355\u636e\u6d41\u6c34\u5f02\u5e38\uff1a{},{}", (Object)reconciliationTime, (Object)Throwables.getStackTraceAsString((Throwable)e));
                hasMore = false;
            }
        });
        return postDetailDtoList;
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchSaveErpInventoryPostDetail(String reconciliationTime, List<ErpInventoryPostDetailDto> postDetailDtoList) {
        List dispositionEoList = this.converter().toEoList(postDetailDtoList);
        dispositionEoList.forEach(d -> {
            d.setDr(0);
            d.setCreateTime(new Date());
            d.setUpdateTime(new Date());
        });
        ((IErpInventoryPostDetailDomain)this.domain).insertBatch(dispositionEoList);
    }

    private List<ErpInventoryPostDetailDto> setErpInventoryPostDetail(String reconciliationTime, List<BillFlowRespDto> billFlowRespDtoList, DgLogicWarehouseDto logicWarehouseDto) {
        ArrayList<ErpInventoryPostDetailDto> detailDtoList = new ArrayList<ErpInventoryPostDetailDto>();
        if (CollectionUtils.isNotEmpty(billFlowRespDtoList)) {
            List<String> skuCodes = billFlowRespDtoList.stream().map(BillFlowRespDto::getSkuCode).distinct().collect(Collectors.toList());
            List<ItemSkuDgEo> itemSkuDgEoList = this.getItemSkuDgEo(skuCodes);
            Map<Object, Object> itemSkuDgEoMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty(itemSkuDgEoList)) {
                itemSkuDgEoMap = itemSkuDgEoList.stream().collect(Collectors.toMap(ItemSkuDgEo::getCode, Function.identity(), (k1, k2) -> k1));
            }
            for (BillFlowRespDto flowRespDto : billFlowRespDtoList) {
                ErpInventoryPostDetailDto detailDto = new ErpInventoryPostDetailDto();
                BeanUtils.copyProperties((Object)flowRespDto, (Object)detailDto);
                detailDto.setReconciliationTime(DateTimeUtils.parseDate(reconciliationTime));
                detailDto.setErpOrderNo(flowRespDto.getBookingNo());
                detailDto.setErpOrderType(flowRespDto.getBookingType());
                detailDto.setErpWarehouseCode(flowRespDto.getOsWarehouseCode());
                detailDto.setErpWarehouseName(flowRespDto.getOsWarehouseName());
                detailDto.setStorageQuantity(null == flowRespDto.getOsQuantity() ? BigDecimal.ZERO : new BigDecimal(flowRespDto.getOsQuantity()));
                BigDecimal deliveryNum = new BigDecimal(Math.abs(flowRespDto.getDeliveryNum()));
                BigDecimal receiveNum = new BigDecimal(Math.abs(flowRespDto.getReceiveNum()));
                if (deliveryNum.compareTo(BigDecimal.ZERO) > 0) {
                    detailDto.setErpQuantity(deliveryNum);
                    detailDto.setOrderType("delivery");
                } else if (receiveNum.compareTo(BigDecimal.ZERO) > 0) {
                    detailDto.setErpQuantity(receiveNum);
                    detailDto.setOrderType("receive");
                } else {
                    detailDto.setErpQuantity(null == flowRespDto.getOsQuantity() ? BigDecimal.ZERO : new BigDecimal(flowRespDto.getOsQuantity()));
                }
                detailDto.setDeliveryNum(null == flowRespDto.getDeliveryNum() ? BigDecimal.ZERO : new BigDecimal(flowRespDto.getDeliveryNum()));
                detailDto.setReceiveNum(null == flowRespDto.getReceiveNum() ? BigDecimal.ZERO : new BigDecimal(flowRespDto.getReceiveNum()));
                detailDto.setErpStatus(flowRespDto.getOsStatus());
                detailDto.setSkuUnit(flowRespDto.getUnit());
                detailDto.setRemark(flowRespDto.getRemark());
                detailDto.setCargoRightCode(logicWarehouseDto.getOrganizationCode());
                detailDto.setCargoRightName(logicWarehouseDto.getOrganizationName());
                detailDto.setPhysicsWarehouseCode(logicWarehouseDto.getPhysicsWarehouseCode());
                detailDto.setPhysicsWarehouseName(logicWarehouseDto.getPhysicsWarehouseName());
                detailDto.setOrganizationCode(logicWarehouseDto.getOrganizationCode());
                detailDto.setOrganizationName(logicWarehouseDto.getOrganizationName());
                detailDto.setLogicWarehouseCode(logicWarehouseDto.getWarehouseCode());
                detailDto.setLogicWarehouseName(logicWarehouseDto.getWarehouseName());
                if (itemSkuDgEoMap.containsKey(flowRespDto.getSkuCode())) {
                    ItemSkuDgEo itemSkuDgEo = (ItemSkuDgEo)itemSkuDgEoMap.get(flowRespDto.getSkuCode());
                    detailDto.setSkuName(Objects.nonNull(itemSkuDgEo) ? itemSkuDgEo.getName() : null);
                    detailDto.setSkuUnit(Objects.nonNull(itemSkuDgEo) ? itemSkuDgEo.getUnit() : null);
                }
                detailDtoList.add(detailDto);
            }
        }
        return detailDtoList;
    }

    private List<ItemSkuDgEo> getItemSkuDgEo(List<String> skuCodes) {
        ArrayList itemSkuDgEos = Lists.newArrayList();
        try {
            List itemSkuDgEoList;
            int length;
            int i = 0;
            for (length = skuCodes.size(); length > 500; length -= 500) {
                itemSkuDgEoList = ((ExtQueryChainWrapper)this.iItemSkuDgDomain.filter().in((Object)"code", skuCodes.subList(i, i + 500))).list();
                itemSkuDgEos.addAll(itemSkuDgEoList);
                i += 500;
            }
            if (length > 0) {
                itemSkuDgEoList = ((ExtQueryChainWrapper)this.iItemSkuDgDomain.filter().in((Object)"code", skuCodes.subList(i, i + length))).list();
                itemSkuDgEos.addAll(itemSkuDgEoList);
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5546\u54c1\u5931\u8d25:{}", (Object)Throwables.getStackTraceAsString((Throwable)e));
        }
        return itemSkuDgEos;
    }

    private List<ItemDgEo> getItemDgEo(List<Long> itemIds) {
        ArrayList itemDgEos = Lists.newArrayList();
        try {
            List itemDgEoList;
            int length;
            int i = 0;
            for (length = itemIds.size(); length > 500; length -= 500) {
                itemDgEoList = ((ExtQueryChainWrapper)this.iItemDgDomain.filter().in((Object)"id", itemIds.subList(i, i + 500))).list();
                itemDgEos.addAll(itemDgEoList);
                i += 500;
            }
            if (length > 0) {
                itemDgEoList = ((ExtQueryChainWrapper)this.iItemDgDomain.filter().in((Object)"id", itemIds.subList(i, i + length))).list();
                itemDgEos.addAll(itemDgEoList);
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5546\u54c1\u5931\u8d25:{}", (Object)Throwables.getStackTraceAsString((Throwable)e));
        }
        return itemDgEos;
    }
}

