/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.reconciliation.impl;

import com.alibaba.fastjson.JSONArray;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.constants.InventoryCompareTypeEnum;
import com.yunxi.dg.base.center.report.constants.reconciliation.InventoryReconciliationSourceEnum;
import com.yunxi.dg.base.center.report.convert.reconciliation.InventoryDiscrepancyCollectConverter;
import com.yunxi.dg.base.center.report.dao.vo.InventoryDiscrepancyPageReqVo;
import com.yunxi.dg.base.center.report.domain.reconciliation.IInventoryDiscrepancyCollectDomain;
import com.yunxi.dg.base.center.report.dto.reconciliation.InventoryDataDto;
import com.yunxi.dg.base.center.report.dto.reconciliation.InventoryDiscrepancyCollectDto;
import com.yunxi.dg.base.center.report.dto.reconciliation.InventoryDiscrepancyCollectPageReqDto;
import com.yunxi.dg.base.center.report.dto.reconciliation.InventoryDiscrepancyCollectRespDto;
import com.yunxi.dg.base.center.report.eo.reconciliation.InventoryDiscrepancyCollectEo;
import com.yunxi.dg.base.center.report.service.reconciliation.IInventoryDiscrepancyCollectService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class InventoryDiscrepancyCollectServiceImpl
extends BaseServiceImpl<InventoryDiscrepancyCollectDto, InventoryDiscrepancyCollectEo, IInventoryDiscrepancyCollectDomain>
implements IInventoryDiscrepancyCollectService {
    public InventoryDiscrepancyCollectServiceImpl(IInventoryDiscrepancyCollectDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<InventoryDiscrepancyCollectDto, InventoryDiscrepancyCollectEo> converter() {
        return InventoryDiscrepancyCollectConverter.INSTANCE;
    }

    @Override
    public List<InventoryDiscrepancyCollectEo> selectDataListByConditions(String bizDate) {
        InventoryDiscrepancyCollectEo collectEo = new InventoryDiscrepancyCollectEo();
        collectEo.setBizDate(bizDate);
        return ((IInventoryDiscrepancyCollectDomain)this.domain).selectList((BaseEo)collectEo, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
    }

    @Override
    public RestResponse<PageInfo<InventoryDiscrepancyCollectRespDto>> selectByParams(InventoryDiscrepancyCollectPageReqDto pageReqDto) {
        PageHelper.startPage((int)pageReqDto.getPageNum(), (int)pageReqDto.getPageSize());
        InventoryDiscrepancyPageReqVo pageReqVo = new InventoryDiscrepancyPageReqVo();
        BeanUtils.copyProperties((Object)pageReqDto, (Object)pageReqVo);
        PageInfo eoPageInfo = new PageInfo(((IInventoryDiscrepancyCollectDomain)this.domain).selectByParams(pageReqVo));
        PageInfo dtoPageInfo = new PageInfo();
        if (CollectionUtils.isNotEmpty((Collection)eoPageInfo.getList())) {
            BeanUtils.copyProperties((Object)eoPageInfo, (Object)dtoPageInfo);
            ArrayList<InventoryDiscrepancyCollectRespDto> collectRespDtoList = new ArrayList<InventoryDiscrepancyCollectRespDto>();
            for (InventoryDiscrepancyCollectEo collectEo : eoPageInfo.getList()) {
                List inventoryDataDtoList;
                InventoryDiscrepancyCollectRespDto respDto = new InventoryDiscrepancyCollectRespDto();
                BeanUtils.copyProperties((Object)collectEo, (Object)respDto);
                respDto.setTypeName(InventoryCompareTypeEnum.getName((String)respDto.getType()));
                if (StringUtils.isNotEmpty((CharSequence)collectEo.getInventoryResult()) && CollectionUtils.isNotEmpty((Collection)(inventoryDataDtoList = JSONArray.parseArray((String)collectEo.getInventoryResult(), InventoryDataDto.class)))) {
                    Map inventoryMap = inventoryDataDtoList.stream().collect(Collectors.toMap(InventoryDataDto::getCode, Function.identity(), (c1, c2) -> c2));
                    if (null != inventoryMap.get(InventoryReconciliationSourceEnum.HYX.getCode())) {
                        respDto.setOmsInventoryNum(((InventoryDataDto)inventoryMap.get(InventoryReconciliationSourceEnum.HYX.getCode())).getValue());
                    }
                    if (null != inventoryMap.get(InventoryReconciliationSourceEnum.U9.getCode())) {
                        respDto.setErpInventoryNum(((InventoryDataDto)inventoryMap.get(InventoryReconciliationSourceEnum.U9.getCode())).getValue());
                    }
                    if (null != inventoryMap.get(InventoryReconciliationSourceEnum.WMS.getCode())) {
                        respDto.setWmsInventoryNum(((InventoryDataDto)inventoryMap.get(InventoryReconciliationSourceEnum.WMS.getCode())).getValue());
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)collectEo.getDifferenceResult()) && CollectionUtils.isNotEmpty((Collection)(inventoryDataDtoList = JSONArray.parseArray((String)collectEo.getDifferenceResult(), InventoryDataDto.class)))) {
                    Map differenceMap = inventoryDataDtoList.stream().collect(Collectors.toMap(InventoryDataDto::getCode, Function.identity(), (c1, c2) -> c2));
                    if (null != differenceMap.get(InventoryReconciliationSourceEnum.U9.getCode())) {
                        respDto.setErpDifferenceResult(((InventoryDataDto)differenceMap.get(InventoryReconciliationSourceEnum.U9.getCode())).getValue());
                    }
                    if (null != differenceMap.get(InventoryReconciliationSourceEnum.WMS.getCode())) {
                        respDto.setWmsDifferenceResult(((InventoryDataDto)differenceMap.get(InventoryReconciliationSourceEnum.WMS.getCode())).getValue());
                    }
                }
                collectRespDtoList.add(respDto);
            }
            dtoPageInfo.setList(collectRespDtoList);
        }
        return new RestResponse((Object)dtoPageInfo);
    }

    @Override
    public RestResponse<Long> updateRemark(InventoryDiscrepancyCollectDto discrepancyDto) {
        AssertUtils.isTrue((null != discrepancyDto.getId() ? 1 : 0) != 0, (String)"ID\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)discrepancyDto.getRemark()), (String)"\u5907\u6ce8\u4e0d\u80fd\u4e3a\u7a7a");
        InventoryDiscrepancyCollectEo discrepancyEo = (InventoryDiscrepancyCollectEo)((IInventoryDiscrepancyCollectDomain)this.domain).selectByPrimaryKey(discrepancyDto.getId());
        AssertUtils.isTrue((null != discrepancyEo.getId() ? 1 : 0) != 0, (String)"\u65e0\u8be5\u6c47\u603b\u5bf9\u8d26\u8bb0\u5f55");
        discrepancyEo.setRemark(discrepancyDto.getRemark());
        ((IInventoryDiscrepancyCollectDomain)this.domain).updateSelective((BaseEo)discrepancyEo);
        return new RestResponse((Object)discrepancyEo.getId());
    }
}

