/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.reconciliation.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskAndBizCreateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskUpdateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.TaskQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.ITaskQueryApi;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.constants.reconciliation.FiltrationTypeEnum;
import com.yunxi.dg.base.center.report.convert.reconciliation.ReconciliationDispositionConverter;
import com.yunxi.dg.base.center.report.domain.inventory.IDgLogicWarehouseDomain;
import com.yunxi.dg.base.center.report.domain.reconciliation.IFiltrationDispositionDomain;
import com.yunxi.dg.base.center.report.domain.reconciliation.IReconciliationDispositionDomain;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehouseDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehousePageReqDto;
import com.yunxi.dg.base.center.report.dto.reconciliation.FiltrationDispositionDto;
import com.yunxi.dg.base.center.report.dto.reconciliation.FiltrationDispositionRespDto;
import com.yunxi.dg.base.center.report.dto.reconciliation.ReconciliationDispositionDto;
import com.yunxi.dg.base.center.report.dto.reconciliation.ReconciliationDispositionPageReqDto;
import com.yunxi.dg.base.center.report.dto.reconciliation.ReconciliationDispositionRespDto;
import com.yunxi.dg.base.center.report.enums.CodeGenEnum;
import com.yunxi.dg.base.center.report.enums.ValidFlagEnum;
import com.yunxi.dg.base.center.report.eo.inventory.DgLogicWarehouseEo;
import com.yunxi.dg.base.center.report.eo.reconciliation.FiltrationDispositionEo;
import com.yunxi.dg.base.center.report.eo.reconciliation.ReconciliationDispositionEo;
import com.yunxi.dg.base.center.report.service.reconciliation.IReconciliationDispositionService;
import com.yunxi.dg.base.center.report.service.utils.codegenerate.GenerateCodeUtil;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.io.Serializable;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReconciliationDispositionServiceImpl
extends BaseServiceImpl<ReconciliationDispositionDto, ReconciliationDispositionEo, IReconciliationDispositionDomain>
implements IReconciliationDispositionService {
    private static final Logger log = LoggerFactory.getLogger(ReconciliationDispositionServiceImpl.class);
    @Resource
    private GenerateCodeUtil generateCodeUtil;
    @Resource
    private IDgLogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private IFiltrationDispositionDomain filtrationDispositionDomain;
    @Value(value="${scheduler.client.app_code:ISALE_MARKETING}")
    private String appCode;
    @Resource
    private ITaskApi taskApi;
    @Resource
    private ITaskQueryApi taskQueryApi;

    public ReconciliationDispositionServiceImpl(IReconciliationDispositionDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<ReconciliationDispositionDto, ReconciliationDispositionEo> converter() {
        return ReconciliationDispositionConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long add(ReconciliationDispositionDto dto) {
        log.info("\u65b0\u589e\u3001\u7f16\u8f91\u5e93\u5b58\u5bf9\u8d26\u914d\u7f6e\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        this.checkParam(dto);
        ReconciliationDispositionEo eo = new ReconciliationDispositionEo();
        if (StringUtils.isNotEmpty((CharSequence)dto.getDispositionNo())) {
            eo = this.deleteByNo(dto.getDispositionNo());
            eo.setUpdateTime(new Date());
            eo.setUpdatePerson(ServiceContext.getContext().getRequestUserCode());
        }
        CubeBeanUtils.copyProperties((Object)eo, (Object)dto, (String[])new String[]{"id", "createTime", "createPerson", "updateTime", "updatePerson"});
        String dispositionNo = StringUtils.isNotEmpty((CharSequence)dto.getDispositionNo()) ? dto.getDispositionNo() : this.generateCodeUtil.generateCode(CodeGenEnum.RECONCILIATION_DISPOSITION);
        eo.setDispositionNo(dispositionNo);
        ((IReconciliationDispositionDomain)this.domain).insert((BaseEo)eo);
        List<FiltrationDispositionEo> filtrationDispositionEos = this.setFiltrationDispositionEos(dto.getWarehouseList(), eo, FiltrationTypeEnum.LOGIC.getCode());
        List<FiltrationDispositionEo> documentEos = this.setFiltrationDispositionEos(dto.getOrderList(), eo, FiltrationTypeEnum.DOCUMENT.getCode());
        filtrationDispositionEos.addAll(documentEos);
        this.filtrationDispositionDomain.insertBatch(filtrationDispositionEos);
        this.addOrUpdateSchedulerTask(eo);
        return eo.getId();
    }

    @NotNull
    private ReconciliationDispositionEo deleteByNo(String dispositionNo) {
        log.info("\u5220\u9664\u5e93\u5b58\u5bf9\u8d26\u914d\u7f6e\u5165\u53c2\uff1a{}", (Object)dispositionNo);
        List eos = ((ExtQueryChainWrapper)((IReconciliationDispositionDomain)this.domain).filter().eq((Object)"disposition_no", (Object)dispositionNo)).list();
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)eos), (String)"\u6839\u636e\u89c4\u5219\u7f16\u53f7\u627e\u4e0d\u5230\u5bf9\u5e94\u4fe1\u606f");
        ReconciliationDispositionEo eo = (ReconciliationDispositionEo)eos.get(0);
        ((IReconciliationDispositionDomain)this.domain).deleteById(eo.getId());
        FiltrationDispositionEo filtrationDispositionEo = new FiltrationDispositionEo();
        filtrationDispositionEo.setDispositionId(eo.getId());
        this.filtrationDispositionDomain.delete((BaseEo)filtrationDispositionEo);
        this.deleteSchedulerTask(eo.getId());
        return eo;
    }

    @Override
    public void deleteByDispositionNo(String dispositionNo) {
        this.deleteByNo(dispositionNo);
    }

    @Override
    public PageInfo<ReconciliationDispositionRespDto> queryByPage(ReconciliationDispositionPageReqDto pageReqDto) {
        log.info("\u5206\u9875\u67e5\u8be2\u5e93\u5b58\u5bf9\u8d26\u914d\u7f6e\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)pageReqDto));
        if (CollectionUtils.isNotEmpty((Collection)pageReqDto.getLogicWarehouseCodeList())) {
            List filtrationDispositionEos = ((ExtQueryChainWrapper)this.filtrationDispositionDomain.filter().in((Object)"encode_no", (Collection)pageReqDto.getLogicWarehouseCodeList())).list();
            if (CollectionUtils.isEmpty((Collection)filtrationDispositionEos)) {
                return new PageInfo();
            }
            List idList = filtrationDispositionEos.stream().map(e -> e.getDispositionId()).distinct().collect(Collectors.toList());
            pageReqDto.setIdList(idList);
        }
        PageHelper.startPage((int)pageReqDto.getPageNum(), (int)pageReqDto.getPageSize());
        List eos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IReconciliationDispositionDomain)this.domain).filter().like(StringUtils.isNotEmpty((CharSequence)pageReqDto.getDispositionNo()), (Object)"disposition_no", (Object)pageReqDto.getDispositionNo())).in(CollectionUtils.isNotEmpty((Collection)pageReqDto.getReconciliationObjectList()), (Object)"reconciliation_object", (Collection)pageReqDto.getReconciliationObjectList())).in(CollectionUtils.isNotEmpty((Collection)pageReqDto.getIdList()), (Object)"id", (Collection)pageReqDto.getIdList())).like(StringUtils.isNotEmpty((CharSequence)pageReqDto.getDispositionName()), (Object)"disposition_name", (Object)pageReqDto.getDispositionName())).list();
        PageInfo eoPageInfo = new PageInfo(eos);
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)eoPageInfo, (String[])new String[0]);
        ArrayList dtos = new ArrayList();
        CubeBeanUtils.copyCollection(dtos, (Collection)eos, ReconciliationDispositionRespDto.class);
        pageInfo.setList(dtos);
        return pageInfo;
    }

    @Override
    public ReconciliationDispositionRespDto queryById(Long id) {
        ReconciliationDispositionEo eo = (ReconciliationDispositionEo)((IReconciliationDispositionDomain)this.domain).getMapper().selectById((Serializable)id);
        ReconciliationDispositionRespDto dto = new ReconciliationDispositionRespDto();
        CubeBeanUtils.copyProperties((Object)dto, (Object)eo, (String[])new String[0]);
        if (Objects.isNull(eo)) {
            return dto;
        }
        List filtrationDispositionEos = ((ExtQueryChainWrapper)this.filtrationDispositionDomain.filter().eq((Object)"disposition_id", (Object)eo.getId())).list();
        if (CollectionUtils.isNotEmpty((Collection)filtrationDispositionEos)) {
            List logicWarehouseCodeList = filtrationDispositionEos.stream().filter(e -> "logic".equals(e.getFiltrationType()) && StringUtils.isNotEmpty((CharSequence)e.getEncodeNo())).map(e -> e.getEncodeNo()).distinct().collect(Collectors.toList());
            Map<Object, Object> map = new HashMap();
            if (CollectionUtils.isNotEmpty(logicWarehouseCodeList)) {
                map = ((List)Optional.ofNullable(((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().in((Object)"warehouse_code", logicWarehouseCodeList)).list()).orElse(new ArrayList())).stream().collect(Collectors.toMap(DgLogicWarehouseEo::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
            }
            ArrayList<FiltrationDispositionRespDto> warehouseList = new ArrayList<FiltrationDispositionRespDto>();
            ArrayList<FiltrationDispositionRespDto> orderList = new ArrayList<FiltrationDispositionRespDto>();
            for (FiltrationDispositionEo filtrationDispositionEo : filtrationDispositionEos) {
                FiltrationDispositionRespDto filtrationDispositionDto = new FiltrationDispositionRespDto();
                CubeBeanUtils.copyProperties((Object)filtrationDispositionDto, (Object)filtrationDispositionEo, (String[])new String[0]);
                if ("logic".equals(filtrationDispositionEo.getFiltrationType())) {
                    DgLogicWarehouseEo logicWarehouseEo = (DgLogicWarehouseEo)map.get(filtrationDispositionEo.getEncodeNo());
                    if (Objects.nonNull(logicWarehouseEo)) {
                        filtrationDispositionDto.setPhysicsWarehouseCode(logicWarehouseEo.getPhysicsWarehouseCode());
                        filtrationDispositionDto.setPhysicsWarehouseName(logicWarehouseEo.getPhysicsWarehouseName());
                        filtrationDispositionDto.setWarehouseStatus(logicWarehouseEo.getWarehouseStatus());
                    }
                    warehouseList.add(filtrationDispositionDto);
                }
                if (!"document".equals(filtrationDispositionEo.getFiltrationType())) continue;
                orderList.add(filtrationDispositionDto);
            }
            dto.setWarehouseList(warehouseList);
            dto.setOrderList(orderList);
        }
        return dto;
    }

    private List<FiltrationDispositionEo> setFiltrationDispositionEos(List<FiltrationDispositionDto> dtos, ReconciliationDispositionEo eo, String filtrationType) {
        return dtos.stream().map(e -> {
            FiltrationDispositionEo filtrationDispositionEo = new FiltrationDispositionEo();
            CubeBeanUtils.copyProperties((Object)filtrationDispositionEo, (Object)e, (String[])new String[]{"id", "createTime", "createPerson", "updateTime", "updatePerson"});
            filtrationDispositionEo.setFiltrationType(filtrationType);
            filtrationDispositionEo.setDispositionId(eo.getId());
            filtrationDispositionEo.setDispositionNo(eo.getDispositionNo());
            return filtrationDispositionEo;
        }).collect(Collectors.toList());
    }

    private void checkParam(ReconciliationDispositionDto dto) {
        AssertUtils.isTrue((boolean)Objects.nonNull(dto), (String)"\u5e93\u5b58\u5bf9\u8d26\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)dto.getDispositionName()), (String)"\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)dto.getReconciliationObject()), (String)"\u5bf9\u8d26\u65b9\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((boolean)Objects.nonNull(dto.getInventoryReconciliationTime()), (String)"\u5e93\u5b58\u5bf9\u8d26\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)dto.getInventoryReconciliationType()), (String)"\u5e93\u5b58\u5bf9\u8d26\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((boolean)Objects.nonNull(dto.getOrderReconciliationTime()), (String)"\u5355\u636e\u5bf9\u8d26\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)dto.getReconciliationInventoryProperty()), (String)"\u5bf9\u8d26\u5e93\u5b58\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        if (CollectionUtils.isNotEmpty((Collection)dto.getWarehouseList())) {
            dto.getWarehouseList().forEach(e -> {
                AssertUtils.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)e.getEncodeNo()), (String)"\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)e.getEncodeName()), (String)"\u4ed3\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getOrderList())) {
            dto.getOrderList().forEach(e -> {
                AssertUtils.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)e.getTypeNo()), (String)"\u4e2d\u53f0\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)e.getTypeName()), (String)"\u4e2d\u53f0\u5355\u636e\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)e.getBusinessType()), (String)"\u4e2d\u53f0\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)e.getBusinessName()), (String)"\u4e2d\u53f0\u4e1a\u52a1\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.isTrue((boolean)Objects.nonNull(e.getRelevanceBusinessOrder()), (String)"\u662f\u5426\u5173\u8054\u4e1a\u52a1\u5355\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)e.getResultType()), (String)"\u7ed3\u679c\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)e.getThreeOrderTypeField()), (String)"\u4e09\u65b9\u5355\u636e\u7c7b\u578b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)e.getThreeOrderTypeValue()), (String)"\u4e09\u65b9\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)e.getThreeBusinessTypeField()), (String)"\u4e09\u65b9\u4e1a\u52a1\u7c7b\u578b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)e.getThreeBusinessTypeValue()), (String)"\u4e09\u65b9\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                if (1 == e.getRelevanceBusinessOrder()) {
                    AssertUtils.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)e.getThreeFieldCode()), (String)"\u4e09\u65b9\u5b57\u6bb5\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    AssertUtils.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)e.getThreeFieldName()), (String)"\u4e09\u65b9\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                }
            });
        }
        List warehouseCodes = dto.getWarehouseList().stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getEncodeNo())).map(e -> e.getEncodeNo()).distinct().collect(Collectors.toList());
        DgLogicWarehousePageReqDto logicWarehousePageReqDto = new DgLogicWarehousePageReqDto();
        logicWarehousePageReqDto.setWarehouseCodes(warehouseCodes);
        List logicWarehouseDtos = this.logicWarehouseDomain.queryList(logicWarehousePageReqDto);
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)logicWarehouseDtos), (String)"\u903b\u8f91\u4ed3\u5e93\u90fd\u4e0d\u5b58\u5728");
        Map<String, String> logicWarehouseMap = logicWarehouseDtos.stream().collect(Collectors.toMap(DgLogicWarehouseDto::getWarehouseCode, DgLogicWarehouseDto::getWarehouseStatus, (k1, k2) -> k1));
        ArrayList noExistLogicWarehouseCode = new ArrayList();
        ArrayList disableLogicWarehouseCode = new ArrayList();
        dto.getWarehouseList().forEach(e -> {
            String warehouseStatus = (String)logicWarehouseMap.get(e.getEncodeNo());
            String paramWarehouse = e.getEncodeNo() + " " + e.getEncodeName();
            if (Objects.isNull(warehouseStatus)) {
                noExistLogicWarehouseCode.add(paramWarehouse);
            }
            if (ValidFlagEnum.DISABLE.getCode().equals(warehouseStatus)) {
                disableLogicWarehouseCode.add(paramWarehouse);
            }
        });
        AssertUtils.isTrue((boolean)CollectionUtils.isEmpty(noExistLogicWarehouseCode), (String)("\u4ee5\u4e0b\u903b\u8f91\u4ed3\u5e93\u4e0d\u5b58\u5728\uff1a" + JSON.toJSONString(noExistLogicWarehouseCode)));
        AssertUtils.isTrue((boolean)CollectionUtils.isEmpty(disableLogicWarehouseCode), (String)("\u4ee5\u4e0b\u903b\u8f91\u4ed3\u5e93\u72b6\u6001\u7981\u7528\uff0c\u4e0d\u80fd\u4fdd\u5b58\uff1a" + JSON.toJSONString(disableLogicWarehouseCode)));
    }

    private void addOrUpdateSchedulerTask(ReconciliationDispositionEo dispositionEo) {
        if (Objects.isNull(dispositionEo)) {
            return;
        }
        String timeStr = dispositionEo.getInventoryReconciliationTime();
        String inventoryCompareTaskCode = "threeInventoryReconciliationTask";
        String inventoryCompareTaskName = this.inventoryTaskNameGen(dispositionEo.getId());
        TaskQueryRespDto inventoryCompare = this.getTask(inventoryCompareTaskName);
        this.setTask(inventoryCompare, dispositionEo, inventoryCompareTaskName, inventoryCompareTaskCode, this.setCron(timeStr, timeStr.startsWith("00") ? 1 : 0));
        String orderTimeStr = dispositionEo.getOrderReconciliationTime();
        String documentCompareTaskCode = "threeDocumentReconciliationTask";
        String documentCompareTaskName = this.documentTaskNameGen(dispositionEo.getId());
        TaskQueryRespDto documentCompare = this.getTask(documentCompareTaskName);
        this.setTask(documentCompare, dispositionEo, documentCompareTaskName, documentCompareTaskCode, this.setCron(orderTimeStr, orderTimeStr.startsWith("00") ? 1 : 0));
    }

    public void deleteSchedulerTask(Long dispositionId) {
        TaskQueryRespDto documentCompare;
        TaskQueryRespDto inventoryCompare = this.getTask(this.inventoryTaskNameGen(dispositionId));
        if (inventoryCompare != null) {
            this.taskApi.disableById(inventoryCompare.getId(), "");
        }
        if ((documentCompare = this.getTask(this.documentTaskNameGen(dispositionId))) != null) {
            this.taskApi.disableById(documentCompare.getId(), "");
        }
    }

    public String inventoryTaskNameGen(Long dispositionId) {
        return "\u5e93\u5b58\u5bf9\u8d26\u5b9a\u65f6\u4efb\u52a1_" + dispositionId;
    }

    public String documentTaskNameGen(Long dispositionId) {
        return "\u5e93\u5b58\u5355\u636e\u5bf9\u8d26\u5b9a\u65f6\u4efb\u52a1_" + dispositionId;
    }

    private void setTask(TaskQueryRespDto taskQueryRespDto, ReconciliationDispositionEo dispositionEo, String taskName, String taskCode, String scheduleExpression) {
        if (Objects.isNull(taskQueryRespDto)) {
            TaskAndBizCreateReqDto taskAndBizCreateReqDto = this.initCreateReqDto(dispositionEo, taskName, taskCode, scheduleExpression);
            RestResponse response = this.taskApi.addWithBiz(taskAndBizCreateReqDto);
            log.info("\u521d\u59cb\u5316\u4efb\u52a1:" + taskName + JSONObject.toJSONString((Object)response));
            this.taskApi.enableById((Long)response.getData(), "{}");
        } else {
            TaskUpdateReqDto taskUpdateReqDto = this.initUpdateReqDto(dispositionEo, scheduleExpression, taskQueryRespDto);
            taskUpdateReqDto.setScheduleExpression(scheduleExpression);
            RestResponse response = this.taskApi.modifyById(taskQueryRespDto.getId(), taskUpdateReqDto);
            log.info("\u66f4\u65b0\u4efb\u52a1:" + taskName + JSONObject.toJSONString((Object)response));
            this.taskApi.enableById(taskQueryRespDto.getId(), "{}");
        }
    }

    private TaskAndBizCreateReqDto initCreateReqDto(ReconciliationDispositionEo dispositionEo, String taskName, String taskCode, String scheduleExpression) {
        TaskAndBizCreateReqDto taskAndBizCreateReqDto = new TaskAndBizCreateReqDto();
        taskAndBizCreateReqDto.setTaskName(taskName);
        taskAndBizCreateReqDto.setShardType("SINGLE");
        taskAndBizCreateReqDto.setAppCode("wh-enterprise-mgmt-application");
        taskAndBizCreateReqDto.setBizCode(taskCode);
        taskAndBizCreateReqDto.setBizName(taskName);
        taskAndBizCreateReqDto.setScheduleExpression(scheduleExpression);
        taskAndBizCreateReqDto.setParams(String.valueOf(dispositionEo.getId()));
        taskAndBizCreateReqDto.setInstanceId(Long.valueOf(null != dispositionEo.getInstanceId() ? dispositionEo.getInstanceId() : -1L));
        taskAndBizCreateReqDto.setTenantId(Long.valueOf(null != dispositionEo.getTenantId() ? dispositionEo.getTenantId() : -1L));
        return taskAndBizCreateReqDto;
    }

    private TaskUpdateReqDto initUpdateReqDto(ReconciliationDispositionEo dispositionEo, String scheduleExpression, TaskQueryRespDto taskQueryRespDto) {
        TaskUpdateReqDto taskAndBizCreateReqDto = new TaskUpdateReqDto();
        taskAndBizCreateReqDto.setScheduleExpression(scheduleExpression);
        taskAndBizCreateReqDto.setTenantId(Long.valueOf(null != dispositionEo.getTenantId() ? dispositionEo.getTenantId() : -1L));
        taskAndBizCreateReqDto.setInstanceId(Long.valueOf(null != dispositionEo.getInstanceId() ? dispositionEo.getInstanceId() : -1L));
        return taskAndBizCreateReqDto;
    }

    private TaskQueryRespDto getTask(String taskName) {
        TaskQueryReqDto taskQueryReqDto = new TaskQueryReqDto();
        taskQueryReqDto.setTaskName(taskName);
        String query = JSONObject.toJSON((Object)taskQueryReqDto).toString();
        PageInfo taskQueryRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.taskQueryApi.queryByPage(query, Integer.valueOf(1), Integer.valueOf(1)));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)taskQueryRespDtoPageInfo.getList())) {
            return (TaskQueryRespDto)taskQueryRespDtoPageInfo.getList().get(0);
        }
        return null;
    }

    private String setCron(String timeStr, Integer hours) {
        LocalTime time = LocalTime.parse(timeStr, DateTimeFormatter.ofPattern("HH:mm:ss"));
        if (null != hours && 0 != hours) {
            LocalTime newTime = time.plusHours(hours.intValue());
            return newTime.format(DateTimeFormatter.ofPattern("ss mm HH * * ?"));
        }
        return time.format(DateTimeFormatter.ofPattern("ss mm HH * * ?"));
    }
}

