/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.enterprice.impl.handler;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.yunxi.dg.base.center.report.domain.entity.IEnterpriceCrossOrderDomain;
import com.yunxi.dg.base.center.report.dto.companytrade.EnterprisePushErpEventDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossReceiveDeliveryResultReqDto;
import com.yunxi.dg.base.center.report.enums.EnterpriceCrossOrderSyncErpStatusEnum;
import com.yunxi.dg.base.center.report.eo.EnterpriceCrossOrderEo;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public abstract class EnterpriceCrossAbstractSceneServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(EnterpriceCrossAbstractSceneServiceImpl.class);
    @Resource
    private IContext context;
    @Resource
    private IEnterpriceCrossOrderDomain domain;
    @Resource
    private ApplicationEventPublisher applicationEventPublisher;

    public abstract Boolean checkEnterpriceOrderAndHandleBusinessType(EnterpriceCrossReceiveDeliveryResultReqDto var1);

    public abstract List<Long> createOrder(EnterpriceCrossReceiveDeliveryResultReqDto var1);

    public void handleReceiveDeliveryResultOrder(EnterpriceCrossReceiveDeliveryResultReqDto context) {
        List<Long> order = this.createOrder(context);
        log.info("=====\u63a5\u6536\u7ed3\u679c\u5355\u5b8c\u6210 --> orderIds {}", (Object)JSONUtil.toJsonStr(order));
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new EnterprisePushErpEventDto(order));
    }

    @NotNull
    protected EnterpriceCrossOrderEo createEo() {
        EnterpriceCrossOrderEo orderEo = new EnterpriceCrossOrderEo();
        orderEo.setTenantId(this.context.tenantId());
        orderEo.setInstanceId(this.context.instanceId());
        orderEo.setCreatePerson(this.context.userName());
        orderEo.setCreateTime(new Date());
        orderEo.setUpdatePerson(this.context.userName());
        orderEo.setUpdateTime(new Date());
        orderEo.setDr(0);
        orderEo.setSyncException("");
        return orderEo;
    }

    protected EnterpriceCrossOrderEo createEo(String businessType, String displayBusinessType, Long resultOrderId, String orderType) {
        EnterpriceCrossOrderEo orderEo = this.createEo();
        orderEo.setSyncStatus(EnterpriceCrossOrderSyncErpStatusEnum.SYNC_TODO.getType());
        orderEo.setBusinessType(businessType);
        orderEo.setDisplayBusinessType(displayBusinessType);
        orderEo.setResultOrderId(resultOrderId);
        orderEo.setType(orderType);
        orderEo.setDocumentNo(this.domain.createDocumentNo(orderEo.getType()));
        return orderEo;
    }

    protected void setExceptionToSyncException(EnterpriceCrossOrderEo orderEo, String errorMesage) {
        orderEo.setSyncStatus(EnterpriceCrossOrderSyncErpStatusEnum.SYNC_FAIL.getType());
        if (errorMesage.startsWith(";")) {
            errorMesage = errorMesage.substring(1);
        }
        if (orderEo.getSyncException().length() > 1) {
            orderEo.setSyncException(orderEo.getSyncException() + ";" + errorMesage);
        } else {
            orderEo.setSyncException(errorMesage);
        }
    }

    protected void deductFailSetSyncException(Boolean duductResult, EnterpriceCrossOrderEo orderEo) {
        if (!duductResult.booleanValue() && !StrUtil.contains((CharSequence)orderEo.getSyncException(), (CharSequence)"\u83b7\u53d6\u4ef7\u683c\u5931\u8d25")) {
            this.setExceptionToSyncException(orderEo, "\u83b7\u53d6\u4ef7\u683c\u5931\u8d25");
            this.domain.updateSelective((BaseEo)orderEo);
        }
    }
}

