/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.api.constant.DgReportMqConstant;
import com.yunxi.dg.base.center.report.constants.YesNoEnum;
import com.yunxi.dg.base.center.report.constants.tag.TagGroupEnum;
import com.yunxi.dg.base.center.report.constants.tag.TagSubGroupEnum;
import com.yunxi.dg.base.center.report.constants.tag.TagTypeEnum;
import com.yunxi.dg.base.center.report.convert.entity.BizTagConverter;
import com.yunxi.dg.base.center.report.convert.entity.BizTagSubGroupConverter;
import com.yunxi.dg.base.center.report.dao.das.IBizTagRecordDas;
import com.yunxi.dg.base.center.report.dao.das.IBizTagSubGroupDas;
import com.yunxi.dg.base.center.report.domain.entity.IBizTagDomain;
import com.yunxi.dg.base.center.report.dto.entity.BizTagDto;
import com.yunxi.dg.base.center.report.dto.entity.BizTagSubGroupDto;
import com.yunxi.dg.base.center.report.dto.tag.ReBizTagPageReqDto;
import com.yunxi.dg.base.center.report.dto.tag.ReBizTagReqDto;
import com.yunxi.dg.base.center.report.eo.BizTagEo;
import com.yunxi.dg.base.center.report.eo.BizTagSubGroupEo;
import com.yunxi.dg.base.center.report.service.anno.LabelTagSynchronizationAnnotation;
import com.yunxi.dg.base.center.report.service.entity.IBizTagService;
import com.yunxi.dg.base.center.report.service.utils.CommonCodeUtil;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizTagServiceImpl
extends BaseServiceImpl<BizTagDto, BizTagEo, IBizTagDomain>
implements IBizTagService {
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private CommonCodeUtil commonCodeUtil;
    @Resource
    private IBizTagSubGroupDas bizTagSubGroupDas;
    @Resource
    private IBizTagRecordDas bizTagRecordDas;
    @Resource
    private IContext context;

    public BizTagServiceImpl(IBizTagDomain domain) {
        super((IBaseDomain)domain);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long add(ReBizTagReqDto dto) {
        AssertUtils.notEmpty((String)dto.getTagType(), (String)"\u6807\u7b7e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty((String)dto.getTagName(), (String)"\u6807\u7b7e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty((String)dto.getTagGroupCode(), (String)"\u6807\u7b7e\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
        dto.setId(null);
        BizTagEo eo = this.createBizTagEo(dto);
        if (TagGroupEnum.ITEM.getCode().equals(dto.getTagGroupCode())) {
            AssertUtils.notEmpty((Collection)dto.getSubGroupDtos(), (String)"\u4e8c\u7ea7\u6807\u7b7e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ((IBizTagDomain)this.domain).insert((BaseEo)eo);
        if (CollectionUtil.isNotEmpty((Collection)dto.getSubGroupDtos())) {
            for (BizTagSubGroupDto subGroupDto : dto.getSubGroupDtos()) {
                BizTagSubGroupEo subGroupEo = (BizTagSubGroupEo)BizTagSubGroupConverter.INSTANCE.toEo((BaseDto)subGroupDto);
                subGroupEo.setTagSubGroupName(TagSubGroupEnum.getEnum((String)subGroupDto.getTagSubGroupCode()).getName());
                subGroupEo.setTagId(eo.getId());
                subGroupEo.setTagSubGroupCode(subGroupDto.getTagSubGroupCode());
                this.bizTagSubGroupDas.insert((BaseEo)subGroupEo);
            }
        }
        return eo.getId();
    }

    @Override
    @LabelTagSynchronizationAnnotation(desc="edit", returnType="LONG_TYPE")
    public Long edit(ReBizTagReqDto dto) {
        BizTagEo eo;
        AssertUtils.notEmpty((String)dto.getTagName(), (String)"\u6807\u7b7e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        BizTagEo tagEo = (BizTagEo)((IBizTagDomain)this.domain).selectByPrimaryKey(dto.getId());
        if (tagEo == null) {
            throw new BizException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (Objects.equals(tagEo.getTagStatus(), 1)) {
            AssertUtils.isTrue((boolean)Objects.equals(this.bizTagRecordDas.countTagRecordByTagId(tagEo.getId()), 0), (String)"\u8be5\u6807\u7b7e\u5df2\u5173\u8054\u5bf9\u8c61\uff0c\u4e0d\u5141\u8bb8\u7f16\u8f91");
        }
        if (TagGroupEnum.ITEM.getCode().equals(dto.getTagGroupCode())) {
            eo = new BizTagEo();
            eo.setId(tagEo.getId());
            eo.setTagName(dto.getTagName());
            eo.setRemark(dto.getRemark());
            eo.setUpdatePerson(this.context.userName());
            eo.setUpdateTime(new Date());
        } else {
            eo = new BizTagEo();
            eo.setId(tagEo.getId());
            eo.setTagName(dto.getTagName());
            eo.setTagBackgroudColor(dto.getTagBackgroudColor());
            eo.setTagFontColor(dto.getTagFontColor());
            eo.setTagDisplaySort(dto.getTagDisplaySort());
            eo.setRemark(dto.getRemark());
            eo.setTagType(dto.getTagType());
            eo.setTagExtend(dto.getTagExtend());
        }
        ((IBizTagDomain)this.domain).updateSelective((BaseEo)eo);
        return eo.getId();
    }

    @Override
    public void logicDel(Long id) {
        BizTagEo tagEo = (BizTagEo)((IBizTagDomain)this.domain).selectByPrimaryKey(id);
        if (tagEo == null || TagTypeEnum.SYSTEM_TAG.getCode().equals(tagEo.getTagType())) {
            throw new BizException("\u4e0d\u652f\u6301\u5220\u9664\u7cfb\u7edf\u6807\u7b7e\u4fe1\u606f");
        }
        AssertUtils.isTrue((boolean)Objects.equals(this.bizTagRecordDas.countTagRecordByTagId(id), 0), (String)"\u8be5\u6807\u7b7e\u5df2\u5173\u8054\u5bf9\u8c61\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        ((IBizTagDomain)this.domain).logicDel(id);
        ArrayList bizTypeCodeList = new ArrayList();
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)JSON.toJSONString(bizTypeCodeList));
        this.commonsMqService.publishMessageAsync(DgReportMqConstant.REPORT_PUBLISH_TOPIC.getCode(), DgReportMqConstant.ORDER_LABEL_CHANGE_TAG.getCode(), (Object)messageVo);
    }

    @Override
    public PageInfo<BizTagDto> queryByPage(ReBizTagPageReqDto pageDto) {
        PageHelper.startPage((int)pageDto.getPageNum(), (int)pageDto.getPageSize());
        PageInfo pi = new PageInfo(((IBizTagDomain)this.domain).queryList(pageDto));
        if (CollectionUtils.isNotEmpty((Collection)pi.getList())) {
            List ids = pi.getList().stream().map(BaseDto::getId).collect(Collectors.toList());
            LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
            lqw.in(BizTagSubGroupEo::getTagId, ids);
            List subGroupEos = this.bizTagSubGroupDas.getMapper().selectList((Wrapper)lqw);
            List subGroupDtos = BizTagSubGroupConverter.INSTANCE.toDtoList(subGroupEos);
            Map<Long, List<BizTagSubGroupDto>> subGroupDtoMap = subGroupDtos.stream().collect(Collectors.groupingBy(BizTagSubGroupDto::getTagId));
            for (BizTagDto tagDto : pi.getList()) {
                tagDto.setSubGroupDtos(subGroupDtoMap.get(tagDto.getId()));
            }
        }
        return pi;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @LabelTagSynchronizationAnnotation(desc="updateStatus", returnType="LIST_TYPE")
    public void updateStatus(Integer status, List<Long> ids) {
        for (Long id : ids) {
            if (Objects.equals(status, 0)) {
                AssertUtils.isTrue((boolean)Objects.equals(this.bizTagRecordDas.countTagRecordByTagId(id), 0), (String)"\u8be5\u6807\u7b7e\u5df2\u5173\u8054\u5bf9\u8c61\uff0c\u4e0d\u5141\u8bb8\u7981\u7528");
            }
            BizTagEo bizTagEo = new BizTagEo();
            bizTagEo.setId(id);
            bizTagEo.setTagStatus(status);
            ((IBizTagDomain)this.domain).updateSelective((BaseEo)bizTagEo);
        }
    }

    @Override
    public List<String> listByTagNames(List<String> tagNames) {
        return ((IBizTagDomain)this.domain).listByTagNames(tagNames);
    }

    public IConverter<BizTagDto, BizTagEo> converter() {
        return BizTagConverter.INSTANCE;
    }

    @Override
    public List<BizTagDto> findAll(ReBizTagPageReqDto pageDto) {
        return ((IBizTagDomain)this.domain).queryList(pageDto);
    }

    private BizTagEo createBizTagEo(ReBizTagReqDto dto) {
        if (((IBizTagDomain)this.domain).checkNameExist(dto.getTagName(), dto.getId(), dto.getTagGroupCode()).booleanValue()) {
            throw new BizException("\u540d\u79f0\u5df2\u5b58\u5728");
        }
        BizTagEo eo = new BizTagEo();
        eo.setInstanceId(this.context.instanceId());
        eo.setTenantId(this.context.tenantId());
        eo.setCreatePerson(this.context.userName());
        eo.setCreateTime(new Date());
        eo.setUpdatePerson(eo.getCreatePerson());
        eo.setUpdateTime(eo.getCreateTime());
        BeanUtils.copyProperties((Object)dto, (Object)eo);
        if (dto.getId() == null) {
            eo.setTagCode(this.commonCodeUtil.genTagCode("BM"));
            TagGroupEnum tagGroupEnum = TagGroupEnum.getEnum((String)dto.getTagGroupCode());
            eo.setTagGroupCode(tagGroupEnum.getCode());
            eo.setTagGroupName(tagGroupEnum.getName());
            eo.setTagStatus(YesNoEnum.YES.getCode());
            String tagType = Objects.nonNull(dto.getTagType()) ? dto.getTagType() : TagTypeEnum.ASSIST.getCode();
            eo.setTagType(tagType);
        }
        return eo;
    }

    @Override
    public BizTagDto selectById(Long id) {
        BizTagEo bizTagEo = (BizTagEo)((IBizTagDomain)this.domain).selectByPrimaryKey(id);
        BizTagDto bizTagDto = new BizTagDto();
        BeanUtils.copyProperties((Object)bizTagEo, (Object)bizTagDto);
        BizTagSubGroupEo subGroupEo = new BizTagSubGroupEo();
        subGroupEo.setTagId(id);
        List subGroupEos = this.bizTagSubGroupDas.selectList((BaseEo)subGroupEo);
        bizTagDto.setSubGroupDtos(BizTagSubGroupConverter.INSTANCE.toDtoList(subGroupEos));
        return bizTagDto;
    }

    @Override
    public List<BizTagDto> findByTypeAndGroup(ReBizTagPageReqDto dto) {
        List eos = ((IBizTagDomain)this.domain).findByTypeAndGroup(dto);
        return this.converter().toDtoList(eos);
    }

    @Override
    public List<BizTagDto> findIds(List<Long> ids) {
        List bizTagEos = ((IBizTagDomain)this.domain).selectByIds(ids);
        return BeanUtil.copyToList((Collection)bizTagEos, BizTagDto.class);
    }
}

